/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.client.RhqManagers;
import org.rhq.bindings.util.InterfaceSimplifier;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.LocalClientProxy;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerRemote;
import org.rhq.enterprise.server.alert.AlertManagerRemote;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;
import org.rhq.enterprise.server.authz.RoleManagerRemote;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.configuration.ConfigurationManagerRemote;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.content.RepoManagerRemote;
import org.rhq.enterprise.server.discovery.DiscoveryBossRemote;
import org.rhq.enterprise.server.drift.DriftManagerRemote;
import org.rhq.enterprise.server.drift.DriftTemplateManagerRemote;
import org.rhq.enterprise.server.event.EventManagerRemote;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerRemote;
import org.rhq.enterprise.server.measurement.AvailabilityManagerRemote;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerRemote;
import org.rhq.enterprise.server.operation.OperationManagerRemote;
import org.rhq.enterprise.server.report.DataAccessManagerRemote;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerRemote;
import org.rhq.enterprise.server.resource.ResourceTypeManagerRemote;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerRemote;
import org.rhq.enterprise.server.search.SavedSearchManagerRemote;
import org.rhq.enterprise.server.support.SupportManagerRemote;
import org.rhq.enterprise.server.sync.SynchronizationManagerRemote;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.tagging.TagManagerRemote;
import org.rhq.enterprise.server.util.LookupUtil;

public class LocalClient
implements RhqFacade {
    private static final Log LOG = LogFactory.getLog(LocalClient.class);
    private Subject subject;
    private Map<String, Object> managers;

    public LocalClient(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Subject login(String user, String password) throws Exception {
        return this.subject;
    }

    public void logout() {
    }

    public boolean isLoggedIn() {
        return true;
    }

    public AlertManagerRemote getAlertManager() {
        return AccessController.doPrivileged(new PrivilegedAction<AlertManagerRemote>(){

            @Override
            public AlertManagerRemote run() {
                return AccessController.doPrivileged(new PrivilegedAction<AlertManagerRemote>(){

                    @Override
                    public AlertManagerRemote run() {
                        return (AlertManagerRemote)LocalClient.this.getProxy(LookupUtil.getAlertManager(), AlertManagerRemote.class);
                    }
                });
            }
        });
    }

    public AlertDefinitionManagerRemote getAlertDefinitionManager() {
        return AccessController.doPrivileged(new PrivilegedAction<AlertDefinitionManagerRemote>(){

            @Override
            public AlertDefinitionManagerRemote run() {
                return (AlertDefinitionManagerRemote)LocalClient.this.getProxy(LookupUtil.getAlertDefinitionManager(), AlertDefinitionManagerRemote.class);
            }
        });
    }

    public AvailabilityManagerRemote getAvailabilityManager() {
        return AccessController.doPrivileged(new PrivilegedAction<AvailabilityManagerRemote>(){

            @Override
            public AvailabilityManagerRemote run() {
                return (AvailabilityManagerRemote)LocalClient.this.getProxy(LookupUtil.getAvailabilityManager(), AvailabilityManagerRemote.class);
            }
        });
    }

    public BundleManagerRemote getBundleManager() {
        return AccessController.doPrivileged(new PrivilegedAction<BundleManagerRemote>(){

            @Override
            public BundleManagerRemote run() {
                return AccessController.doPrivileged(new PrivilegedAction<BundleManagerRemote>(){

                    @Override
                    public BundleManagerRemote run() {
                        return (BundleManagerRemote)LocalClient.this.getProxy(LookupUtil.getBundleManager(), BundleManagerRemote.class);
                    }
                });
            }
        });
    }

    public CallTimeDataManagerRemote getCallTimeDataManager() {
        return AccessController.doPrivileged(new PrivilegedAction<CallTimeDataManagerRemote>(){

            @Override
            public CallTimeDataManagerRemote run() {
                return (CallTimeDataManagerRemote)LocalClient.this.getProxy(LookupUtil.getCallTimeDataManager(), CallTimeDataManagerRemote.class);
            }
        });
    }

    public RepoManagerRemote getRepoManager() {
        return AccessController.doPrivileged(new PrivilegedAction<RepoManagerRemote>(){

            @Override
            public RepoManagerRemote run() {
                return (RepoManagerRemote)LocalClient.this.getProxy(LookupUtil.getRepoManagerLocal(), RepoManagerRemote.class);
            }
        });
    }

    public ConfigurationManagerRemote getConfigurationManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ConfigurationManagerRemote>(){

            @Override
            public ConfigurationManagerRemote run() {
                return (ConfigurationManagerRemote)LocalClient.this.getProxy(LookupUtil.getConfigurationManager(), ConfigurationManagerRemote.class);
            }
        });
    }

    public ContentManagerRemote getContentManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ContentManagerRemote>(){

            @Override
            public ContentManagerRemote run() {
                return (ContentManagerRemote)LocalClient.this.getProxy(LookupUtil.getContentManager(), ContentManagerRemote.class);
            }
        });
    }

    public DataAccessManagerRemote getDataAccessManager() {
        return AccessController.doPrivileged(new PrivilegedAction<DataAccessManagerRemote>(){

            @Override
            public DataAccessManagerRemote run() {
                return (DataAccessManagerRemote)LocalClient.this.getProxy(LookupUtil.getDataAccessManager(), DataAccessManagerRemote.class);
            }
        });
    }

    public DiscoveryBossRemote getDiscoveryBoss() {
        return AccessController.doPrivileged(new PrivilegedAction<DiscoveryBossRemote>(){

            @Override
            public DiscoveryBossRemote run() {
                return (DiscoveryBossRemote)LocalClient.this.getProxy(LookupUtil.getDiscoveryBoss(), DiscoveryBossRemote.class);
            }
        });
    }

    public DriftManagerRemote getDriftManager() {
        return AccessController.doPrivileged(new PrivilegedAction<DriftManagerRemote>(){

            @Override
            public DriftManagerRemote run() {
                return (DriftManagerRemote)LocalClient.this.getProxy(LookupUtil.getDriftManager(), DriftManagerRemote.class);
            }
        });
    }

    public DriftTemplateManagerRemote getDriftTemplateManager() {
        return AccessController.doPrivileged(new PrivilegedAction<DriftTemplateManagerRemote>(){

            @Override
            public DriftTemplateManagerRemote run() {
                return (DriftTemplateManagerRemote)LocalClient.this.getProxy(LookupUtil.getDriftTemplateManager(), DriftTemplateManagerRemote.class);
            }
        });
    }

    public EventManagerRemote getEventManager() {
        return AccessController.doPrivileged(new PrivilegedAction<EventManagerRemote>(){

            @Override
            public EventManagerRemote run() {
                return (EventManagerRemote)LocalClient.this.getProxy(LookupUtil.getEventManager(), EventManagerRemote.class);
            }
        });
    }

    public MeasurementBaselineManagerRemote getMeasurementBaselineManager() {
        return AccessController.doPrivileged(new PrivilegedAction<MeasurementBaselineManagerRemote>(){

            @Override
            public MeasurementBaselineManagerRemote run() {
                return (MeasurementBaselineManagerRemote)LocalClient.this.getProxy(LookupUtil.getMeasurementBaselineManager(), MeasurementBaselineManagerRemote.class);
            }
        });
    }

    public MeasurementDataManagerRemote getMeasurementDataManager() {
        return AccessController.doPrivileged(new PrivilegedAction<MeasurementDataManagerRemote>(){

            @Override
            public MeasurementDataManagerRemote run() {
                return (MeasurementDataManagerRemote)LocalClient.this.getProxy(LookupUtil.getMeasurementDataManager(), MeasurementDataManagerRemote.class);
            }
        });
    }

    public MeasurementDefinitionManagerRemote getMeasurementDefinitionManager() {
        return AccessController.doPrivileged(new PrivilegedAction<MeasurementDefinitionManagerRemote>(){

            @Override
            public MeasurementDefinitionManagerRemote run() {
                return (MeasurementDefinitionManagerRemote)LocalClient.this.getProxy(LookupUtil.getMeasurementDefinitionManager(), MeasurementDefinitionManagerRemote.class);
            }
        });
    }

    public MeasurementScheduleManagerRemote getMeasurementScheduleManager() {
        return AccessController.doPrivileged(new PrivilegedAction<MeasurementScheduleManagerRemote>(){

            @Override
            public MeasurementScheduleManagerRemote run() {
                return (MeasurementScheduleManagerRemote)LocalClient.this.getProxy(LookupUtil.getMeasurementScheduleManager(), MeasurementScheduleManagerRemote.class);
            }
        });
    }

    public OperationManagerRemote getOperationManager() {
        return AccessController.doPrivileged(new PrivilegedAction<OperationManagerRemote>(){

            @Override
            public OperationManagerRemote run() {
                return (OperationManagerRemote)LocalClient.this.getProxy(LookupUtil.getOperationManager(), OperationManagerRemote.class);
            }
        });
    }

    public ResourceManagerRemote getResourceManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceManagerRemote>(){

            @Override
            public ResourceManagerRemote run() {
                return (ResourceManagerRemote)LocalClient.this.getProxy(LookupUtil.getResourceManager(), ResourceManagerRemote.class);
            }
        });
    }

    public ResourceFactoryManagerRemote getResourceFactoryManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceFactoryManagerRemote>(){

            @Override
            public ResourceFactoryManagerRemote run() {
                return (ResourceFactoryManagerRemote)LocalClient.this.getProxy(LookupUtil.getResourceFactoryManager(), ResourceFactoryManagerRemote.class);
            }
        });
    }

    public ResourceGroupManagerRemote getResourceGroupManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceGroupManagerRemote>(){

            @Override
            public ResourceGroupManagerRemote run() {
                return (ResourceGroupManagerRemote)LocalClient.this.getProxy(LookupUtil.getResourceGroupManager(), ResourceGroupManagerRemote.class);
            }
        });
    }

    public ResourceTypeManagerRemote getResourceTypeManager() {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceTypeManagerRemote>(){

            @Override
            public ResourceTypeManagerRemote run() {
                return (ResourceTypeManagerRemote)LocalClient.this.getProxy(LookupUtil.getResourceTypeManager(), ResourceTypeManagerRemote.class);
            }
        });
    }

    public RoleManagerRemote getRoleManager() {
        return AccessController.doPrivileged(new PrivilegedAction<RoleManagerRemote>(){

            @Override
            public RoleManagerRemote run() {
                return (RoleManagerRemote)LocalClient.this.getProxy(LookupUtil.getRoleManager(), RoleManagerRemote.class);
            }
        });
    }

    public SavedSearchManagerRemote getSavedSearchManager() {
        return AccessController.doPrivileged(new PrivilegedAction<SavedSearchManagerRemote>(){

            @Override
            public SavedSearchManagerRemote run() {
                return (SavedSearchManagerRemote)LocalClient.this.getProxy(LookupUtil.getSavedSearchManager(), SavedSearchManagerRemote.class);
            }
        });
    }

    public SubjectManagerRemote getSubjectManager() {
        return AccessController.doPrivileged(new PrivilegedAction<SubjectManagerRemote>(){

            @Override
            public SubjectManagerRemote run() {
                return (SubjectManagerRemote)LocalClient.this.getProxy(LookupUtil.getSubjectManager(), SubjectManagerRemote.class);
            }
        });
    }

    public SupportManagerRemote getSupportManager() {
        return AccessController.doPrivileged(new PrivilegedAction<SupportManagerRemote>(){

            @Override
            public SupportManagerRemote run() {
                return (SupportManagerRemote)LocalClient.this.getProxy(LookupUtil.getSupportManager(), SupportManagerRemote.class);
            }
        });
    }

    public SystemManagerRemote getSystemManager() {
        return AccessController.doPrivileged(new PrivilegedAction<SystemManagerRemote>(){

            @Override
            public SystemManagerRemote run() {
                return (SystemManagerRemote)LocalClient.this.getProxy(LookupUtil.getSystemManager(), SystemManagerRemote.class);
            }
        });
    }

    public RemoteInstallManagerRemote getRemoteInstallManager() {
        return AccessController.doPrivileged(new PrivilegedAction<RemoteInstallManagerRemote>(){

            @Override
            public RemoteInstallManagerRemote run() {
                return (RemoteInstallManagerRemote)LocalClient.this.getProxy(LookupUtil.getRemoteInstallManager(), RemoteInstallManagerRemote.class);
            }
        });
    }

    public TagManagerRemote getTagManager() {
        return AccessController.doPrivileged(new PrivilegedAction<TagManagerRemote>(){

            @Override
            public TagManagerRemote run() {
                return (TagManagerRemote)LocalClient.this.getProxy(LookupUtil.getTagManager(), TagManagerRemote.class);
            }
        });
    }

    public SynchronizationManagerRemote getSynchronizationManager() {
        return AccessController.doPrivileged(new PrivilegedAction<SynchronizationManagerRemote>(){

            @Override
            public SynchronizationManagerRemote run() {
                return (SynchronizationManagerRemote)LocalClient.this.getProxy(LookupUtil.getSynchronizationManager(), SynchronizationManagerRemote.class);
            }
        });
    }

    public Map<String, Object> getManagers() {
        if (this.managers == null) {
            this.managers = new HashMap<String, Object>();
            for (RhqManagers manager : RhqManagers.values()) {
                try {
                    Method m = this.getClass().getMethod("get" + manager.name(), new Class[0]);
                    this.managers.put(manager.name(), m.invoke((Object)this, new Object[0]));
                }
                catch (Throwable e) {
                    LOG.error((Object)("Failed to load manager " + manager + " due to missing class."), e);
                }
            }
        }
        return this.managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getProxy(Object slsb, Class<T> iface) {
        RhqManagers manager = RhqManagers.forInterface(iface);
        Class simplified = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(iface.getClassLoader());
            simplified = InterfaceSimplifier.simplify(iface);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        Object proxy = Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{simplified}, (InvocationHandler)((Object)new LocalClientProxy(slsb, this, manager)));
        return iface.cast(proxy);
    }
}

