/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.sonarqube;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.sonarqube.SonarQubeJSONUtility;
import org.rhq.plugins.sonarqube.SonarQubeServerComponent;

public class SonarQubeProjectDiscoveryComponent
implements ResourceDiscoveryComponent<SonarQubeServerComponent> {
    private static final Log LOG = LogFactory.getLog(SonarQubeJSONUtility.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<SonarQubeServerComponent> discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
        String serverPath = ((SonarQubeServerComponent)discoveryContext.getParentResourceComponent()).getPath();
        JSONArray projects = SonarQubeJSONUtility.getDatas(serverPath, "resources");
        try {
            for (int i = 0; i < projects.length(); ++i) {
                JSONObject project = projects.getJSONObject(i);
                String name = project.getString("name");
                String key = project.getString("key");
                String description = project.getString("lname");
                String version = project.getString("version");
                if (description.length() > 1000) {
                    description = description.substring(0, 999);
                }
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, description, null, null);
                found.add(detail);
            }
            return found;
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            throw e;
        }
    }
}

