/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.twitter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.twitter.TwitterComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedDiscovery
implements ResourceDiscoveryComponent<TwitterComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<TwitterComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List childConfigs = discoveryContext.getPluginConfigurations();
        for (Configuration config : childConfigs) {
            String kind = config.getSimpleValue("kind", "user");
            String keyword = config.getSimpleValue("keyword", null);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), "tw:" + kind + ":" + keyword, "Feed: " + kind + " : " + keyword, null, kind.equals("user") ? "Timeline " : "Search for " + keyword, config, null);
            discoveredResources.add(detail);
            this.log.info((Object)("Added new " + detail));
        }
        return discoveredResources;
    }
}

