/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.komodo.metadata.TeiidConnectionProvider;
import org.komodo.rest.TeiidSwarmConnectionProvider;
import org.komodo.rest.TeiidSwarmMetadataInstance;
import org.komodo.spi.metadata.MetadataInstance;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.spi.runtime.version.DefaultMetadataVersion;
import org.komodo.test.utils.TestUtilities;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.core.util.ApplicationInfo;

@RunWith(value=Arquillian.class)
public class IT_KomodoTestMetadataServer {
    private TeiidSwarmMetadataInstance instance;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws Exception {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/vdb-builder.war"));
    }

    private MetadataInstance getMetadataInstance() throws Exception {
        if (this.instance == null) {
            TeiidSwarmConnectionProvider connectionProvider = new TeiidSwarmConnectionProvider();
            this.instance = new TeiidSwarmMetadataInstance((TeiidConnectionProvider)connectionProvider);
        }
        return this.instance;
    }

    @Test
    public void testVersion() throws Exception {
        ApplicationInfo info = ApplicationInfo.getInstance();
        Assert.assertEquals((Object)new DefaultMetadataVersion(info.getReleaseNumber()), (Object)this.getMetadataInstance().getVersion());
    }

    @Test
    public void testCreateDataSource() throws Exception {
        String displayName = "h2-connector";
        String type = "h2";
        String dsName = "accounts-ds";
        String jndiName = "java:/accounts-ds";
        String connUrl = "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1";
        if (this.getMetadataInstance().dataSourceExists(dsName)) {
            this.getMetadataInstance().deleteDataSource(dsName);
        }
        Properties properties = new Properties();
        properties.setProperty("jndi-name", jndiName);
        properties.setProperty("connection-url", connUrl);
        TeiidDataSource accountsDS = this.getMetadataInstance().getOrCreateDataSource(displayName, dsName, type, properties);
        Assert.assertNotNull((Object)accountsDS);
        Assert.assertEquals((Object)dsName, (Object)accountsDS.getName());
        Assert.assertEquals((Object)type, (Object)accountsDS.getType());
        Assert.assertEquals((Object)jndiName, (Object)accountsDS.getPropertyValue("jndi-name"));
        Assert.assertEquals((Object)connUrl, (Object)accountsDS.getPropertyValue("connection-url"));
        this.getMetadataInstance().deleteDataSource(dsName);
        Assert.assertFalse((boolean)this.getMetadataInstance().dataSourceExists(dsName));
    }

    @Test
    @Ignore(value="Requires configuration of loopback translator")
    public void testDeployment() throws Exception {
        TeiidVdb vdb;
        this.getMetadataInstance().deployDynamicVdb("sample-vdb.xml", TestUtilities.sampleExample());
        Thread.sleep(2000L);
        Collection vdbs = this.getMetadataInstance().getVdbs();
        Assert.assertEquals((long)1L, (long)vdbs.size());
        long timeout = System.currentTimeMillis() + 120000L;
        do {
            vdb = this.getMetadataInstance().getVdb("sample");
            Assert.assertNotNull((Object)vdb);
            Assert.assertEquals((long)0L, (long)vdb.getValidityErrors().size());
            Thread.sleep(3000L);
        } while (vdb.isLoading() && System.currentTimeMillis() < timeout);
        Assert.assertFalse((boolean)vdb.isLoading());
        Assert.assertTrue((boolean)vdb.isActive());
        this.getMetadataInstance().undeployDynamicVdb("sample");
        vdbs = this.getMetadataInstance().getVdbs();
        Assert.assertEquals((long)0L, (long)vdbs.size());
    }

    @Test
    public void testGetSchema() throws Exception {
        try {
            this.getMetadataInstance().getSchema("blah", "1.0", "model");
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof AdminProcessingException));
            Assert.assertTrue((boolean)cause.getMessage().contains("does not exist or is not ACTIVE"));
        }
    }

    @Test
    public void testDataSourceDrivers() throws Exception {
        Collection dataSourceDrivers = this.getMetadataInstance().getDataSourceDrivers();
        Assert.assertTrue((dataSourceDrivers.size() > 0 ? 1 : 0) != 0);
        String[] driverNamesArr = new String[]{"h2", "teiid"};
        List<String> driverNames = Arrays.asList(driverNamesArr);
        Iterator iter = dataSourceDrivers.iterator();
        int found = 0;
        while (iter.hasNext()) {
            ConnectionDriver driver = (ConnectionDriver)iter.next();
            if (!driverNames.contains(driver.getName())) continue;
            ++found;
        }
        Assert.assertEquals((long)driverNamesArr.length, (long)found);
    }
}

