/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.rest.RestLink;

public final class RestLinkTest {
    private static final RestLink.LinkType LINK_TYPE = RestLink.LinkType.SELF;
    private static final RestLink.LinkType LINK_TYPE_2 = RestLink.LinkType.PARENT;
    private static final URI URI = UriBuilder.fromUri((String)"http://localhost:8080").build(new Object[0]);

    @Test
    public void shouldBeEqual() {
        RestLink thisLink = new RestLink(LINK_TYPE, URI);
        RestLink thatLink = new RestLink(thisLink.getRel(), thisLink.getHref());
        Assert.assertThat((Object)thisLink, (Matcher)Is.is((Object)thatLink));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenLinkTypeIsNull() {
        new RestLink(null, URI);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenLinkTypeIsNull2() {
        new RestLink(null, URI);
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestLink thisLink = new RestLink(LINK_TYPE, URI);
        RestLink thatLink = new RestLink(thisLink.getRel(), thisLink.getHref());
        Assert.assertThat((Object)thisLink.hashCode(), (Matcher)Is.is((Object)thatLink.hashCode()));
    }

    @Test
    public void shouldNotBeEqualWhenHrefDifferent() {
        RestLink thisLink = new RestLink(LINK_TYPE, URI);
        RestLink thatLink = new RestLink(thisLink.getRel(), UriBuilder.fromUri((String)"http://org.komodo:1234").build(new Object[0]));
        Assert.assertThat((Object)thisLink.getHref(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatLink.getHref())));
        Assert.assertThat((Object)thisLink, (Matcher)Is.is((Matcher)IsNot.not((Object)thatLink)));
    }

    @Test
    public void shouldNotBeEqualWhenRelDifferent() {
        RestLink thisLink = new RestLink(LINK_TYPE, URI);
        RestLink thatLink = new RestLink(LINK_TYPE_2, thisLink.getHref());
        Assert.assertThat((Object)thisLink.getRel(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatLink.getRel())));
        Assert.assertThat((Object)thisLink, (Matcher)Is.is((Matcher)IsNot.not((Object)thatLink)));
    }
}

