/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.json;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.rest.RestLink;
import org.komodo.rest.json.LinkSerializer;

public final class LinkSerializerTest {
    private static final String JSON = "{\"rel\":\"self\",\"href\":\"http://localhost:8080\"}";
    private static final RestLink.LinkType LINK_TYPE = RestLink.LinkType.SELF;
    private static final URI URI = UriBuilder.fromUri((String)"http://localhost:8080").build(new Object[0]);
    private static final LinkSerializer BUILDER = new LinkSerializer();

    @Test
    public void shouldExportJson() throws Exception {
        RestLink link = new RestLink(LINK_TYPE, URI);
        String json = BUILDER.toJson((Object)link);
        Assert.assertEquals((Object)JSON, (Object)json);
    }

    @Test
    public void shouldImportJson() throws Exception {
        RestLink link = (RestLink)BUILDER.fromJson(JSON);
        Assert.assertThat((Object)link.getRel(), (Matcher)Is.is((Object)LINK_TYPE));
        Assert.assertThat((Object)link.getHref(), (Matcher)Is.is((Object)URI));
    }
}

