/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.spi.repository.Repository;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class RestConnectionTest
implements KomodoRestV1Application.V1Constants {
    private static final String NAME = "MyConnection";
    private static final String DRIVER_NAME = "MySql";
    private static final String JNDI_NAME = "MyConnectionJndiName";
    private static final String BASE_URI_PREFIX = "http://localhost:8081/v1";
    private static final URI MY_BASE_URI = UriBuilder.fromUri((String)"http://localhost:8081/v1").build(new Object[0]);
    private static final String TEIID_SERVER = "DefaultServer";
    private Repository.UnitOfWork transaction;
    private Repository repository;
    private RestConnection connection;

    @Before
    public void init() throws Exception {
        this.transaction = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        Mockito.when((Object)this.transaction.getState()).thenReturn((Object)Repository.UnitOfWork.State.NOT_STARTED);
        Repository.UnitOfWork uow = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        Mockito.when((Object)uow.getState()).thenReturn((Object)Repository.UnitOfWork.State.NOT_STARTED);
        this.repository = (Repository)Mockito.mock(Repository.class);
        Repository.UnitOfWorkListener listener = (Repository.UnitOfWorkListener)Matchers.any();
        Mockito.when((Object)this.repository.createTransaction(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), listener)).thenReturn((Object)uow);
        this.connection = new RestConnection();
        this.connection.setId(NAME);
        this.connection.setDriverName(DRIVER_NAME);
        this.connection.setJdbc(true);
        this.connection.setJndiName(JNDI_NAME);
    }

    @Test
    public void shouldBeEqual() {
        RestConnection thatConnection = new RestConnection();
        thatConnection.setId(this.connection.getId());
        thatConnection.setDriverName(this.connection.getDriverName());
        thatConnection.setJndiName(this.connection.getJndiName());
        thatConnection.setJdbc(this.connection.isJdbc());
        thatConnection.setLinks(this.connection.getLinks());
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Object)thatConnection));
    }

    @Test
    public void shouldBeEqualWhenComparingEmptyConnections() {
        RestConnection empty1 = new RestConnection();
        RestConnection empty2 = new RestConnection();
        Assert.assertThat((Object)empty1, (Matcher)Is.is((Object)empty2));
    }

    @Test
    public void shouldConstructEmptyConnection() {
        RestConnection empty = new RestConnection();
        Assert.assertThat((Object)empty.getId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getDriverName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getJndiName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.isJdbc(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)empty.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)empty.getLinks().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestConnection thatConnection = new RestConnection();
        thatConnection.setId(this.connection.getId());
        thatConnection.setDriverName(this.connection.getDriverName());
        thatConnection.setJndiName(this.connection.getJndiName());
        thatConnection.setJdbc(this.connection.isJdbc());
        thatConnection.setProperties(this.connection.getProperties());
        thatConnection.setLinks(this.connection.getLinks());
        Assert.assertThat((Object)this.connection.hashCode(), (Matcher)Is.is((Object)thatConnection.hashCode()));
    }

    @Test
    public void shouldNotBeEqualWhenNameIsDifferent() {
        RestConnection thatConnection = new RestConnection();
        thatConnection.setId(this.connection.getId() + "blah");
        thatConnection.setDriverName(this.connection.getDriverName());
        thatConnection.setJndiName(this.connection.getJndiName());
        thatConnection.setJdbc(this.connection.isJdbc());
        thatConnection.setProperties(this.connection.getProperties());
        thatConnection.setLinks(this.connection.getLinks());
        Assert.assertThat((Object)this.connection.getId(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatConnection.getId())));
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNot.not((Object)thatConnection)));
    }

    @Test
    public void shouldNotBeEqualWhenPropertiesAreDifferent() {
        RestConnection thatConnection = new RestConnection();
        thatConnection.setId(this.connection.getId());
        thatConnection.setDriverName(this.connection.getDriverName());
        thatConnection.setJndiName(this.connection.getJndiName());
        thatConnection.setJdbc(this.connection.isJdbc());
        thatConnection.setLinks(this.connection.getLinks());
        ArrayList<RestProperty> props = new ArrayList<RestProperty>();
        props.addAll(this.connection.getProperties());
        props.add(new RestProperty("blah", (Object)"blah"));
        thatConnection.setProperties(props);
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNot.not((Object)thatConnection)));
    }

    @Test
    public void shouldNotBeEqualWhenJndiNameIsDifferent() {
        RestConnection thatConnection = new RestConnection();
        thatConnection.setId(this.connection.getId());
        thatConnection.setId(this.connection.getId());
        thatConnection.setDriverName(this.connection.getDriverName());
        thatConnection.setJndiName(this.connection.getJndiName() + "blah");
        thatConnection.setJdbc(this.connection.isJdbc());
        thatConnection.setProperties(this.connection.getProperties());
        thatConnection.setLinks(this.connection.getLinks());
        Assert.assertThat((Object)this.connection.getJndiName(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatConnection.getJndiName())));
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNot.not((Object)thatConnection)));
    }
}

