/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.resource.Driver;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.relational.dataservice.RestDataservice;
import org.komodo.spi.repository.Descriptor;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.PropertyDescriptor;
import org.komodo.spi.repository.Repository;
import org.mockito.Mockito;

public final class RestDataserviceTest {
    private static final URI BASE_URI = UriBuilder.fromUri((String)"http://localhost:8081/v1/").build(new Object[0]);
    private static final String WORKSPACE_DATA_PATH = "/workspace";
    private static final String DATASERVICE_NAME = "MyDataservice";
    private static final String DATASERVICE_DATA_PATH = "/workspace/dataservices/dataservice1";
    private static final KomodoType kType = KomodoType.DATASERVICE;
    private static final String DESCRIPTION = "my description";
    private static final String SERVICE_VDB_NAME = "serviceVdbName";
    private static final String SERVICE_VDB_VERSION = "1";
    private static final String SERVICE_VIEW_MODEL = "serviceViewModel";
    private static final String SERVICE_VIEW = "serviceView";
    private static final String SERVICE_VIEW_SRCTABLE1 = "sourceTable1";
    private static final String SERVICE_VIEW_SRCTABLE2 = "sourceTable2";
    private RestDataservice dataservice;

    private RestDataservice copy() {
        RestDataservice copy = new RestDataservice();
        copy.setBaseUri(this.dataservice.getBaseUri());
        copy.setId(this.dataservice.getId());
        copy.setDescription(this.dataservice.getDescription());
        copy.setDataPath(this.dataservice.getDataPath());
        copy.setkType(this.dataservice.getkType());
        copy.setHasChildren(this.dataservice.hasChildren());
        copy.setLinks(this.dataservice.getLinks());
        copy.setProperties(this.dataservice.getProperties());
        copy.setServiceVdbName(this.dataservice.getServiceVdbName());
        copy.setServiceVdbVersion(this.dataservice.getServiceVdbVersion());
        copy.setServiceViewModel(this.dataservice.getServiceViewModel());
        copy.setServiceViewName(this.dataservice.getServiceViewName());
        copy.setServiceViewTables(this.dataservice.getServiceViewTables());
        copy.setDriverTotal(this.dataservice.getDriverTotal());
        copy.setConnectionTotal(this.dataservice.getConnectionTotal());
        return copy;
    }

    @Before
    public void init() throws Exception {
        Repository.UnitOfWork transaction = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        KomodoObject workspace = (KomodoObject)Mockito.mock(KomodoObject.class);
        Mockito.when((Object)workspace.getAbsolutePath()).thenReturn((Object)WORKSPACE_DATA_PATH);
        Descriptor dataserviceType = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)dataserviceType.getName()).thenReturn((Object)"dv:dataService");
        Vdb serviceVdb = (Vdb)Mockito.mock(Vdb.class);
        Mockito.when((Object)serviceVdb.getName(transaction)).thenReturn((Object)"ServiceVdb");
        Mockito.when((Object)serviceVdb.getVersion(transaction)).thenReturn((Object)1);
        Dataservice theDataservice = (Dataservice)Mockito.mock(Dataservice.class);
        Mockito.when((Object)theDataservice.getPrimaryType(transaction)).thenReturn((Object)dataserviceType);
        Mockito.when((Object)theDataservice.getName(transaction)).thenReturn((Object)DATASERVICE_NAME);
        Mockito.when((Object)theDataservice.getAbsolutePath()).thenReturn((Object)DATASERVICE_DATA_PATH);
        Mockito.when((Object)theDataservice.getTypeIdentifier(transaction)).thenReturn((Object)kType);
        Mockito.when((Object)theDataservice.hasChildren(transaction)).thenReturn((Object)true);
        Mockito.when((Object)theDataservice.getPropertyNames(transaction)).thenReturn((Object)new String[0]);
        Mockito.when((Object)theDataservice.getPropertyDescriptors(transaction)).thenReturn((Object)new PropertyDescriptor[0]);
        Mockito.when((Object)theDataservice.getParent(transaction)).thenReturn((Object)workspace);
        Mockito.when((Object)theDataservice.getServiceVdb(transaction)).thenReturn((Object)serviceVdb);
        Mockito.when((Object)theDataservice.getDrivers(transaction, new String[0])).thenReturn((Object)new Driver[0]);
        Mockito.when((Object)theDataservice.getConnections(transaction, new String[0])).thenReturn((Object)new Connection[0]);
        this.dataservice = new RestDataservice(BASE_URI, theDataservice, false, transaction);
        this.dataservice.setId(DATASERVICE_NAME);
        this.dataservice.setDescription(DESCRIPTION);
        this.dataservice.setServiceVdbName(SERVICE_VDB_NAME);
        this.dataservice.setServiceVdbVersion(SERVICE_VDB_VERSION);
        this.dataservice.setServiceViewModel(SERVICE_VIEW_MODEL);
        this.dataservice.setServiceViewName(SERVICE_VIEW);
        String[] viewTables = new String[]{SERVICE_VIEW_SRCTABLE1, SERVICE_VIEW_SRCTABLE2};
        this.dataservice.setServiceViewTables(viewTables);
    }

    @Test
    public void shouldHaveBaseUri() {
        Assert.assertEquals((Object)BASE_URI, (Object)this.dataservice.getBaseUri());
    }

    @Test
    public void shouldBeEqual() {
        RestDataservice thatDataservice = this.copy();
        Assert.assertEquals((Object)this.dataservice, (Object)thatDataservice);
    }

    @Test
    public void shouldBeEqualWhenComparingEmptyDataservices() {
        RestDataservice empty1 = new RestDataservice();
        RestDataservice empty2 = new RestDataservice();
        Assert.assertEquals((Object)empty1, (Object)empty2);
    }

    @Test
    public void shouldConstructEmptyDataservice() {
        RestDataservice empty = new RestDataservice();
        Assert.assertNull((Object)empty.getBaseUri());
        Assert.assertNull((Object)empty.getId());
        Assert.assertNull((Object)empty.getDescription());
        Assert.assertEquals((Object)empty.getProperties().isEmpty(), (Object)true);
        Assert.assertEquals((long)empty.getLinks().size(), (long)0L);
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestDataservice thatDataservice = this.copy();
        Assert.assertEquals((long)this.dataservice.hashCode(), (long)thatDataservice.hashCode());
    }

    @Test
    public void shouldNotBeEqualWhenNameIsDifferent() {
        RestDataservice thatDataservice = this.copy();
        thatDataservice.setId(this.dataservice.getId() + "blah");
        Assert.assertNotEquals((Object)this.dataservice, (Object)thatDataservice);
    }

    @Test
    public void shouldSetName() {
        String newName = "blah";
        this.dataservice.setId("blah");
        Assert.assertEquals((Object)this.dataservice.getId(), (Object)"blah");
    }

    @Test
    public void shouldSetDescription() {
        String newDescription = "blah";
        this.dataservice.setDescription("blah");
        Assert.assertEquals((Object)this.dataservice.getDescription(), (Object)"blah");
    }

    @Test
    public void shouldSetServiceVdbName() {
        String newServiceVdb = "blah";
        this.dataservice.setServiceVdbName("blah");
        Assert.assertEquals((Object)this.dataservice.getServiceVdbName(), (Object)"blah");
    }

    @Test
    public void shouldSetServiceVdbVersion() {
        String newServiceVdbVersion = "2";
        this.dataservice.setServiceVdbVersion("2");
        Assert.assertEquals((Object)this.dataservice.getServiceVdbVersion(), (Object)"2");
    }

    @Test
    public void shouldSetServiceViewModel() {
        String newServiceViewModel = "blah";
        this.dataservice.setServiceViewModel("blah");
        Assert.assertEquals((Object)this.dataservice.getServiceViewModel(), (Object)"blah");
    }

    @Test
    public void shouldSetServiceView() {
        String newServiceView = "blah";
        this.dataservice.setServiceViewName("blah");
        Assert.assertEquals((Object)this.dataservice.getServiceViewName(), (Object)"blah");
    }
}

