/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.rest.relational.response.RestVdbDataRole;

public final class RestVdbDataRoleTest {
    private static final String NAME = "MyDataRole";
    private static final String[] MAPPED_ROLES = new String[]{"sledge", "hammer"};
    private RestVdbDataRole dataRole;

    @Before
    public void init() {
        this.dataRole = new RestVdbDataRole();
        this.dataRole.setName(NAME);
        this.dataRole.setMappedRoles(MAPPED_ROLES);
    }

    @Test
    public void shouldBeEqual() {
        RestVdbDataRole thatDataRole = new RestVdbDataRole();
        thatDataRole.setName(this.dataRole.getName());
        thatDataRole.setAllowCreateTempTables(this.dataRole.isAllowCreateTempTables());
        thatDataRole.setAnyAuthenticated(this.dataRole.isAnyAuthenticated());
        thatDataRole.setGrantAll(this.dataRole.isGrantAll());
        thatDataRole.setMappedRoles(this.dataRole.getMappedRoles());
        thatDataRole.setLinks(this.dataRole.getLinks());
        thatDataRole.setProperties(this.dataRole.getProperties());
        Assert.assertThat((Object)this.dataRole, (Matcher)Is.is((Object)thatDataRole));
    }

    @Test
    public void shouldBeEqualWhenComparingEmptyEntries() {
        RestVdbDataRole empty1 = new RestVdbDataRole();
        RestVdbDataRole empty2 = new RestVdbDataRole();
        Assert.assertThat((Object)empty1, (Matcher)Is.is((Object)empty2));
    }

    @Test
    public void shouldConstructEmptyDataRole() {
        RestVdbDataRole empty = new RestVdbDataRole();
        Assert.assertThat((Object)empty.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getMappedRoles().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)empty.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)empty.getLinks().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestVdbDataRole thatDataRole = new RestVdbDataRole();
        thatDataRole.setName(this.dataRole.getName());
        thatDataRole.setAllowCreateTempTables(this.dataRole.isAllowCreateTempTables());
        thatDataRole.setAnyAuthenticated(this.dataRole.isAnyAuthenticated());
        thatDataRole.setGrantAll(this.dataRole.isGrantAll());
        thatDataRole.setMappedRoles(this.dataRole.getMappedRoles());
        thatDataRole.setLinks(this.dataRole.getLinks());
        thatDataRole.setProperties(this.dataRole.getProperties());
        Assert.assertThat((Object)this.dataRole.hashCode(), (Matcher)Is.is((Object)thatDataRole.hashCode()));
    }

    @Test
    public void shouldNotBeEqualWhenAllowCreateTempTablesIsDifferent() {
        RestVdbDataRole thatDataRole = new RestVdbDataRole();
        thatDataRole.setName(this.dataRole.getName());
        thatDataRole.setAllowCreateTempTables(!this.dataRole.isAllowCreateTempTables());
        thatDataRole.setAnyAuthenticated(this.dataRole.isAnyAuthenticated());
        thatDataRole.setGrantAll(this.dataRole.isGrantAll());
        thatDataRole.setMappedRoles(this.dataRole.getMappedRoles());
        thatDataRole.setLinks(this.dataRole.getLinks());
        thatDataRole.setProperties(this.dataRole.getProperties());
        Assert.assertThat((Object)this.dataRole.isAllowCreateTempTables(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole.isAllowCreateTempTables())));
        Assert.assertThat((Object)this.dataRole, (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole)));
    }

    @Test
    public void shouldNotBeEqualWhenAnyAuthenticatedIsDifferent() {
        RestVdbDataRole thatDataRole = new RestVdbDataRole();
        thatDataRole.setName(this.dataRole.getName());
        thatDataRole.setAllowCreateTempTables(this.dataRole.isAllowCreateTempTables());
        thatDataRole.setAnyAuthenticated(!this.dataRole.isAnyAuthenticated());
        thatDataRole.setGrantAll(this.dataRole.isGrantAll());
        thatDataRole.setMappedRoles(this.dataRole.getMappedRoles());
        thatDataRole.setLinks(this.dataRole.getLinks());
        thatDataRole.setProperties(this.dataRole.getProperties());
        Assert.assertThat((Object)this.dataRole.isAnyAuthenticated(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole.isAnyAuthenticated())));
        Assert.assertThat((Object)this.dataRole, (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole)));
    }

    @Test
    public void shouldNotBeEqualWhenGrantAllIsDifferent() {
        RestVdbDataRole thatDataRole = new RestVdbDataRole();
        thatDataRole.setName(this.dataRole.getName());
        thatDataRole.setAllowCreateTempTables(this.dataRole.isAllowCreateTempTables());
        thatDataRole.setAnyAuthenticated(this.dataRole.isAnyAuthenticated());
        thatDataRole.setGrantAll(!this.dataRole.isGrantAll());
        thatDataRole.setMappedRoles(this.dataRole.getMappedRoles());
        thatDataRole.setLinks(this.dataRole.getLinks());
        thatDataRole.setProperties(this.dataRole.getProperties());
        Assert.assertThat((Object)this.dataRole.isGrantAll(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole.isGrantAll())));
        Assert.assertThat((Object)this.dataRole, (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole)));
    }

    @Test
    public void shouldNotBeEqualWhenMappedRolesAreDifferent() {
        RestVdbDataRole thatDataRole = new RestVdbDataRole();
        thatDataRole.setName(this.dataRole.getName());
        thatDataRole.setAllowCreateTempTables(this.dataRole.isAllowCreateTempTables());
        thatDataRole.setAnyAuthenticated(this.dataRole.isAnyAuthenticated());
        thatDataRole.setGrantAll(this.dataRole.isGrantAll());
        thatDataRole.setMappedRoles(new String[]{"red", "white", "blue"});
        thatDataRole.setLinks(this.dataRole.getLinks());
        thatDataRole.setProperties(this.dataRole.getProperties());
        Assert.assertThat((Object)Arrays.deepEquals(this.dataRole.getMappedRoles(), thatDataRole.getMappedRoles()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.dataRole, (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole)));
    }

    @Test
    public void shouldNotBeEqualWhenNameIsDifferent() {
        RestVdbDataRole thatDataRole = new RestVdbDataRole();
        thatDataRole.setName(this.dataRole.getName() + "blah");
        thatDataRole.setAllowCreateTempTables(this.dataRole.isAllowCreateTempTables());
        thatDataRole.setAnyAuthenticated(this.dataRole.isAnyAuthenticated());
        thatDataRole.setGrantAll(this.dataRole.isGrantAll());
        thatDataRole.setLinks(this.dataRole.getLinks());
        thatDataRole.setProperties(this.dataRole.getProperties());
        Assert.assertThat((Object)this.dataRole.getName(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole.getName())));
        Assert.assertThat((Object)this.dataRole, (Matcher)Is.is((Matcher)IsNot.not((Object)thatDataRole)));
    }

    @Test
    public void shouldSetAllowCreateTempTables() {
        boolean newValue = !this.dataRole.isAllowCreateTempTables();
        this.dataRole.setAllowCreateTempTables(newValue);
        Assert.assertThat((Object)this.dataRole.isAllowCreateTempTables(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetAnyAuthenticated() {
        boolean newValue = !this.dataRole.isAnyAuthenticated();
        this.dataRole.setAnyAuthenticated(newValue);
        Assert.assertThat((Object)this.dataRole.isAnyAuthenticated(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetGrantAll() {
        boolean newValue = !this.dataRole.isGrantAll();
        this.dataRole.setGrantAll(newValue);
        Assert.assertThat((Object)this.dataRole.isGrantAll(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetName() {
        String newName = "blah";
        this.dataRole.setName("blah");
        Assert.assertThat((Object)this.dataRole.getName(), (Matcher)Is.is((Object)"blah"));
    }
}

