/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.rest.relational.response.RestVdbImport;

public final class RestVdbImportTest {
    private static final String NAME = "MyVdbImport";
    private static final int VERSION = 2;
    private static final boolean IMPORT_DATA_POLICIES = true;
    private RestVdbImport vdbImport;

    @Before
    public void init() {
        this.vdbImport = new RestVdbImport();
        this.vdbImport.setName(NAME);
        this.vdbImport.setVersion(2);
        this.vdbImport.setImportDataPolicies(true);
    }

    @Test
    public void shouldBeEqual() {
        RestVdbImport thatImport = new RestVdbImport();
        thatImport.setName(this.vdbImport.getName());
        thatImport.setVersion(this.vdbImport.getVersion());
        thatImport.setImportDataPolicies(this.vdbImport.isImportDataPolicies());
        thatImport.setLinks(this.vdbImport.getLinks());
        thatImport.setProperties(this.vdbImport.getProperties());
        Assert.assertThat((Object)this.vdbImport, (Matcher)Is.is((Object)thatImport));
    }

    @Test
    public void shouldBeEqualWhenComparingEmptyEntries() {
        RestVdbImport empty1 = new RestVdbImport();
        RestVdbImport empty2 = new RestVdbImport();
        Assert.assertThat((Object)empty1, (Matcher)Is.is((Object)empty2));
    }

    @Test
    public void shouldConstructEmptyImport() {
        RestVdbImport empty = new RestVdbImport();
        Assert.assertThat((Object)empty.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getVersion(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)empty.isImportDataPolicies(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)empty.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)empty.getLinks().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestVdbImport thatImport = new RestVdbImport();
        thatImport.setName(this.vdbImport.getName());
        thatImport.setVersion(this.vdbImport.getVersion());
        thatImport.setImportDataPolicies(this.vdbImport.isImportDataPolicies());
        thatImport.setLinks(this.vdbImport.getLinks());
        thatImport.setProperties(this.vdbImport.getProperties());
        Assert.assertThat((Object)this.vdbImport.hashCode(), (Matcher)Is.is((Object)thatImport.hashCode()));
    }

    @Test
    public void shouldNotBeEqualWhenImportDataPoliciesIsDifferent() {
        RestVdbImport thatImport = new RestVdbImport();
        thatImport.setName(this.vdbImport.getName());
        thatImport.setVersion(this.vdbImport.getVersion());
        thatImport.setImportDataPolicies(!this.vdbImport.isImportDataPolicies());
        thatImport.setLinks(this.vdbImport.getLinks());
        thatImport.setProperties(this.vdbImport.getProperties());
        Assert.assertThat((Object)this.vdbImport.isImportDataPolicies(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatImport.isImportDataPolicies())));
        Assert.assertThat((Object)this.vdbImport, (Matcher)Is.is((Matcher)IsNot.not((Object)thatImport)));
    }

    @Test
    public void shouldNotBeEqualWhenNameIsDifferent() {
        RestVdbImport thatImport = new RestVdbImport();
        thatImport.setName(this.vdbImport.getName() + "blah");
        thatImport.setVersion(this.vdbImport.getVersion());
        thatImport.setImportDataPolicies(this.vdbImport.isImportDataPolicies());
        thatImport.setLinks(this.vdbImport.getLinks());
        thatImport.setProperties(this.vdbImport.getProperties());
        Assert.assertThat((Object)this.vdbImport.getName(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatImport.getName())));
        Assert.assertThat((Object)this.vdbImport, (Matcher)Is.is((Matcher)IsNot.not((Object)thatImport)));
    }

    @Test
    public void shouldNotBeEqualWhenVersionIsDifferent() {
        RestVdbImport thatImport = new RestVdbImport();
        thatImport.setName(this.vdbImport.getName());
        thatImport.setVersion(this.vdbImport.getVersion() + 1);
        thatImport.setImportDataPolicies(this.vdbImport.isImportDataPolicies());
        thatImport.setLinks(this.vdbImport.getLinks());
        thatImport.setProperties(this.vdbImport.getProperties());
        Assert.assertThat((Object)this.vdbImport.getVersion(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatImport.getVersion())));
        Assert.assertThat((Object)this.vdbImport, (Matcher)Is.is((Matcher)IsNot.not((Object)thatImport)));
    }

    @Test
    public void shouldSetImportDataPolicies() {
        boolean newImportDataPolicies = !this.vdbImport.isImportDataPolicies();
        this.vdbImport.setImportDataPolicies(newImportDataPolicies);
        Assert.assertThat((Object)this.vdbImport.isImportDataPolicies(), (Matcher)Is.is((Object)newImportDataPolicies));
    }

    @Test
    public void shouldSetName() {
        String newName = "blah";
        this.vdbImport.setName("blah");
        Assert.assertThat((Object)this.vdbImport.getName(), (Matcher)Is.is((Object)"blah"));
    }

    @Test
    public void shouldSetVersion() {
        int newVersion = this.vdbImport.getVersion() + 1;
        this.vdbImport.setVersion(newVersion);
        Assert.assertThat((Object)this.vdbImport.getVersion(), (Matcher)Is.is((Object)newVersion));
    }
}

