/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.rest.relational.response.RestVdbCondition;
import org.komodo.rest.relational.response.RestVdbMask;
import org.komodo.rest.relational.response.RestVdbPermission;

public final class RestVdbPermissionTest {
    private static final String NAME = "MyPermission";
    private static final boolean ALLOW_ALTER = true;
    private static final boolean ALLOW_CREATE = true;
    private static final boolean ALLOW_DELETE = true;
    private static final boolean ALLOW_EXECUTE = true;
    private static final boolean ALLOW_LANGUAGE = true;
    private static final boolean ALLOW_READ = true;
    private static final boolean ALLOW_UPDATE = true;
    private static final List<RestVdbCondition> CONDITIONS = new ArrayList<RestVdbCondition>();
    private static final List<RestVdbMask> MASKS = new ArrayList<RestVdbMask>();
    private RestVdbPermission permission;

    private RestVdbPermission copy() {
        RestVdbPermission copy = new RestVdbPermission();
        copy.setName(this.permission.getName());
        copy.setAllowAlter(this.permission.isAllowAlter());
        copy.setAllowCreate(this.permission.isAllowCreate());
        copy.setAllowDelete(this.permission.isAllowDelete());
        copy.setAllowExecute(this.permission.isAllowExecute());
        copy.setAllowLanguage(this.permission.isAllowLanguage());
        copy.setAllowRead(this.permission.isAllowRead());
        copy.setAllowUpdate(this.permission.isAllowUpdate());
        copy.setLinks(this.permission.getLinks());
        copy.setProperties(this.permission.getProperties());
        return copy;
    }

    @Before
    public void init() {
        this.permission = new RestVdbPermission();
        this.permission.setName(NAME);
        this.permission.setAllowAlter(true);
        this.permission.setAllowCreate(true);
        this.permission.setAllowDelete(true);
        this.permission.setAllowExecute(true);
        this.permission.setAllowLanguage(true);
        this.permission.setAllowRead(true);
        this.permission.setAllowUpdate(true);
    }

    @Test
    public void shouldBeEqual() {
        RestVdbPermission thatPermission = this.copy();
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Object)thatPermission));
    }

    @Test
    public void shouldBeEqualWhenComparingEmptyEntries() {
        RestVdbPermission empty1 = new RestVdbPermission();
        RestVdbPermission empty2 = new RestVdbPermission();
        Assert.assertThat((Object)empty1, (Matcher)Is.is((Object)empty2));
    }

    @Test
    public void shouldConstructEmptyPermission() {
        RestVdbPermission empty = new RestVdbPermission();
        Assert.assertThat((Object)empty.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)empty.getLinks().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestVdbPermission thatPermission = this.copy();
        Assert.assertThat((Object)this.permission.hashCode(), (Matcher)Is.is((Object)thatPermission.hashCode()));
    }

    @Test
    public void shouldNotBeEqualWhenAllowAlterIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setAllowAlter(!this.permission.isAllowAlter());
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldNotBeEqualWhenAllowCreateIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setAllowCreate(!this.permission.isAllowCreate());
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldNotBeEqualWhenAllowDeleteIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setAllowDelete(!this.permission.isAllowDelete());
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldNotBeEqualWhenAllowExecuteIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setAllowExecute(!this.permission.isAllowExecute());
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldNotBeEqualWhenAllowLanguageIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setAllowLanguage(!this.permission.isAllowLanguage());
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldNotBeEqualWhenAllowReadIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setAllowRead(!this.permission.isAllowRead());
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldNotBeEqualWhenAllowUpdateIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setAllowUpdate(!this.permission.isAllowUpdate());
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldNotBeEqualWhenNameIsDifferent() {
        RestVdbPermission thatPermission = this.copy();
        thatPermission.setName(this.permission.getName() + "blah");
        Assert.assertThat((Object)this.permission, (Matcher)Is.is((Matcher)IsNot.not((Object)thatPermission)));
    }

    @Test
    public void shouldSetAllowAlter() {
        boolean newValue = !this.permission.isAllowAlter();
        this.permission.setAllowAlter(newValue);
        Assert.assertThat((Object)this.permission.isAllowAlter(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetAllowCreate() {
        boolean newValue = !this.permission.isAllowCreate();
        this.permission.setAllowCreate(newValue);
        Assert.assertThat((Object)this.permission.isAllowCreate(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetAllowDelete() {
        boolean newValue = !this.permission.isAllowDelete();
        this.permission.setAllowDelete(newValue);
        Assert.assertThat((Object)this.permission.isAllowDelete(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetAllowExecute() {
        boolean newValue = !this.permission.isAllowExecute();
        this.permission.setAllowExecute(newValue);
        Assert.assertThat((Object)this.permission.isAllowExecute(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetAllowLanguage() {
        boolean newValue = !this.permission.isAllowLanguage();
        this.permission.setAllowLanguage(newValue);
        Assert.assertThat((Object)this.permission.isAllowLanguage(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetAllowRead() {
        boolean newValue = !this.permission.isAllowRead();
        this.permission.setAllowRead(newValue);
        Assert.assertThat((Object)this.permission.isAllowRead(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetAllowUpdate() {
        boolean newValue = !this.permission.isAllowUpdate();
        this.permission.setAllowUpdate(newValue);
        Assert.assertThat((Object)this.permission.isAllowUpdate(), (Matcher)Is.is((Object)newValue));
    }

    @Test
    public void shouldSetName() {
        String newName = "blah";
        this.permission.setName("blah");
        Assert.assertThat((Object)this.permission.getName(), (Matcher)Is.is((Object)"blah"));
    }

    static {
        RestVdbCondition condition1 = new RestVdbCondition();
        condition1.setName("over");
        condition1.setConstraint(true);
        RestVdbCondition condition2 = new RestVdbCondition();
        condition1.setName("the");
        condition1.setConstraint(false);
        RestVdbCondition condition3 = new RestVdbCondition();
        condition1.setName("rainbow");
        condition1.setConstraint(true);
        CONDITIONS.add(condition1);
        CONDITIONS.add(condition2);
        CONDITIONS.add(condition3);
        RestVdbMask mask1 = new RestVdbMask();
        mask1.setName("this");
        mask1.setOrder("that");
        RestVdbMask mask2 = new RestVdbMask();
        mask1.setName("either");
        mask1.setOrder("or");
        RestVdbMask mask3 = new RestVdbMask();
        mask1.setName("sixofone");
        mask1.setOrder("halfdozenofanother");
        MASKS.add(mask1);
        MASKS.add(mask2);
        MASKS.add(mask3);
    }
}

