/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.repository.Descriptor;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.PropertyDescriptor;
import org.komodo.spi.repository.Repository;
import org.mockito.Mockito;

public final class RestVdbTest
implements StringConstants {
    private static final URI BASE_URI = UriBuilder.fromUri((String)"http://localhost:8081/v1/").build(new Object[0]);
    private static final URI BASE_TEIID_URI = UriBuilder.fromUri((String)"http://localhost:8081/v1/teiid").build(new Object[0]);
    private static final String WORKSPACE_DATA_PATH = "/workspace";
    private static final String VDB_NAME = "MyVdb";
    private static final String VDB_DATA_PATH = "/workspace/vdbs/vdb1";
    private static final KomodoType kType = KomodoType.VDB;
    private static final String DESCRIPTION = "my description";
    private static final String ORIGINAL_FILE = "/Users/ElvisIsKing/MyVdb.xml";
    private static final String CONNECTION_TYPE = "BY_VERSION";
    private static final int VERSION = 1;
    private RestVdb vdb;

    private RestVdb copy() {
        RestVdb copy = new RestVdb();
        copy.setBaseUri(this.vdb.getBaseUri());
        copy.setId(this.vdb.getName());
        copy.setDataPath(this.vdb.getDataPath());
        copy.setkType(this.vdb.getkType());
        copy.setHasChildren(this.vdb.hasChildren());
        copy.setName(this.vdb.getName());
        copy.setDescription(this.vdb.getDescription());
        copy.setOriginalFilePath(this.vdb.getOriginalFilePath());
        copy.setConnectionType(this.vdb.getConnectionType());
        copy.setPreview(this.vdb.isPreview());
        copy.setVersion(this.vdb.getVersion());
        copy.setLinks(this.vdb.getLinks());
        copy.setProperties(this.vdb.getProperties());
        return copy;
    }

    @Before
    public void init() throws Exception {
        Repository.UnitOfWork transaction = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        KomodoObject workspace = (KomodoObject)Mockito.mock(KomodoObject.class);
        Mockito.when((Object)workspace.getAbsolutePath()).thenReturn((Object)WORKSPACE_DATA_PATH);
        Descriptor vdbType = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)vdbType.getName()).thenReturn((Object)"vdb:virtualDatabase");
        Vdb theVdb = (Vdb)Mockito.mock(Vdb.class);
        Mockito.when((Object)theVdb.getPrimaryType(transaction)).thenReturn((Object)vdbType);
        Mockito.when((Object)theVdb.getName(transaction)).thenReturn((Object)VDB_NAME);
        Mockito.when((Object)theVdb.getAbsolutePath()).thenReturn((Object)VDB_DATA_PATH);
        Mockito.when((Object)theVdb.getTypeIdentifier(transaction)).thenReturn((Object)kType);
        Mockito.when((Object)theVdb.hasChildren(transaction)).thenReturn((Object)true);
        Mockito.when((Object)theVdb.getPropertyNames(transaction)).thenReturn((Object)new String[0]);
        Mockito.when((Object)theVdb.getPropertyDescriptors(transaction)).thenReturn((Object)new PropertyDescriptor[0]);
        Mockito.when((Object)theVdb.getParent(transaction)).thenReturn((Object)workspace);
        this.vdb = new RestVdb(BASE_URI, theVdb, false, transaction);
        this.vdb.setName(VDB_NAME);
        this.vdb.setDescription(DESCRIPTION);
        this.vdb.setOriginalFilePath(ORIGINAL_FILE);
        this.vdb.setConnectionType(CONNECTION_TYPE);
        this.vdb.setPreview(false);
        this.vdb.setVersion(1);
    }

    @Test
    public void shouldHaveBaseUri() {
        Assert.assertEquals((Object)BASE_URI, (Object)this.vdb.getBaseUri());
    }

    @Test
    public void shouldBeEqual() {
        RestVdb thatVdb = this.copy();
        Assert.assertEquals((Object)this.vdb, (Object)thatVdb);
    }

    @Test
    public void shouldBeEqualWhenComparingEmptyVdbs() {
        RestVdb empty1 = new RestVdb();
        RestVdb empty2 = new RestVdb();
        Assert.assertEquals((Object)empty1, (Object)empty2);
    }

    @Test
    public void shouldConstructEmptyVdb() {
        RestVdb empty = new RestVdb();
        Assert.assertNull((Object)empty.getBaseUri());
        Assert.assertNull((Object)empty.getName());
        Assert.assertNull((Object)empty.getDescription());
        Assert.assertEquals((Object)empty.getProperties().isEmpty(), (Object)true);
        Assert.assertEquals((long)empty.getLinks().size(), (long)0L);
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestVdb thatVdb = this.copy();
        Assert.assertEquals((long)this.vdb.hashCode(), (long)thatVdb.hashCode());
    }

    @Test
    public void shouldNotBeEqualWhenDescriptionIsDifferent() {
        RestVdb thatVdb = this.copy();
        thatVdb.setDescription(this.vdb.getDescription() + "blah");
        Assert.assertNotEquals((Object)this.vdb, (Object)IsNot.not((Object)thatVdb));
    }

    @Test
    public void shouldNotBeEqualWhenNameIsDifferent() {
        RestVdb thatVdb = this.copy();
        thatVdb.setName(this.vdb.getName() + "blah");
        Assert.assertNotEquals((Object)this.vdb, (Object)thatVdb);
    }

    @Test
    public void shouldNotBeEqualWhenOriginalFileIsDifferent() {
        RestVdb thatVdb = this.copy();
        thatVdb.setOriginalFilePath(this.vdb.getOriginalFilePath() + "blah");
        Assert.assertNotEquals((Object)this.vdb, (Object)thatVdb);
    }

    @Test
    public void shouldSetDescription() {
        String newDescription = "blah";
        this.vdb.setDescription("blah");
        Assert.assertEquals((Object)this.vdb.getDescription(), (Object)"blah");
    }

    @Test
    public void shouldSetName() {
        String newName = "blah";
        this.vdb.setName("blah");
        Assert.assertEquals((Object)this.vdb.getName(), (Object)"blah");
    }

    @Test
    public void shouldSetOriginalFilePath() {
        String newPath = "blah";
        this.vdb.setOriginalFilePath("blah");
        Assert.assertEquals((Object)this.vdb.getOriginalFilePath(), (Object)"blah");
    }
}

