/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.core.repository.DescriptorImpl;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.RestLink;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.response.RestVdbTranslator;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.PropertyDescriptor;
import org.komodo.spi.repository.Repository;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class RestVdbTranslatorTest
implements KomodoRestV1Application.V1Constants {
    private static final String DESCRIPTION = "my description";
    private static final String NAME = "MyTranslator";
    private static final String TYPE = "oracle";
    private static final List<RestProperty> PROPS = new ArrayList<RestProperty>();
    private static final String BASE_URI_PREFIX = "http://localhost:8081/v1";
    private static final URI MY_BASE_URI;
    private static final String VDB_NAME = "vdb1";
    private static final String WKSP_VDB_DATA_PATH = "/workspace/vdbs/vdb1";
    private static final String TEIID_SERVER = "DefaultServer";
    private Repository.UnitOfWork transaction;
    private Repository repository;
    private RestVdbTranslator translator;

    @Before
    public void init() throws Exception {
        this.transaction = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        Mockito.when((Object)this.transaction.getState()).thenReturn((Object)Repository.UnitOfWork.State.NOT_STARTED);
        Repository.UnitOfWork uow = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        Mockito.when((Object)uow.getState()).thenReturn((Object)Repository.UnitOfWork.State.NOT_STARTED);
        this.repository = (Repository)Mockito.mock(Repository.class);
        Repository.UnitOfWorkListener listener = (Repository.UnitOfWorkListener)Matchers.any();
        Mockito.when((Object)this.repository.createTransaction(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), listener)).thenReturn((Object)uow);
        this.translator = new RestVdbTranslator();
        this.translator.setId(NAME);
        this.translator.setType(TYPE);
        this.translator.setDescription(DESCRIPTION);
        this.translator.setProperties(PROPS);
    }

    @Test
    public void shouldBeEqual() {
        RestVdbTranslator thatTranslator = new RestVdbTranslator();
        thatTranslator.setId(this.translator.getId());
        thatTranslator.setType(this.translator.getType());
        thatTranslator.setDescription(this.translator.getDescription());
        thatTranslator.setProperties(this.translator.getProperties());
        thatTranslator.setLinks(this.translator.getLinks());
        Assert.assertThat((Object)this.translator, (Matcher)Is.is((Object)thatTranslator));
    }

    @Test
    public void shouldBeEqualWhenComparingEmptyTranslators() {
        RestVdbTranslator empty1 = new RestVdbTranslator();
        RestVdbTranslator empty2 = new RestVdbTranslator();
        Assert.assertThat((Object)empty1, (Matcher)Is.is((Object)empty2));
    }

    @Test
    public void shouldConstructEmptyTranslator() {
        RestVdbTranslator empty = new RestVdbTranslator();
        Assert.assertThat((Object)empty.getDescription(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)empty.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)empty.getLinks().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldHaveSameHashCode() {
        RestVdbTranslator thatTranslator = new RestVdbTranslator();
        thatTranslator.setId(this.translator.getId());
        thatTranslator.setType(this.translator.getType());
        thatTranslator.setDescription(this.translator.getDescription());
        thatTranslator.setProperties(this.translator.getProperties());
        thatTranslator.setLinks(this.translator.getLinks());
        Assert.assertThat((Object)this.translator.hashCode(), (Matcher)Is.is((Object)thatTranslator.hashCode()));
    }

    @Test
    public void shouldNotBeEqualWhenNameIsDifferent() {
        RestVdbTranslator thatTranslator = new RestVdbTranslator();
        thatTranslator.setId(this.translator.getId() + "blah");
        thatTranslator.setType(this.translator.getType());
        thatTranslator.setDescription(this.translator.getDescription());
        thatTranslator.setProperties(this.translator.getProperties());
        thatTranslator.setLinks(this.translator.getLinks());
        Assert.assertThat((Object)this.translator.getId(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatTranslator.getId())));
        Assert.assertThat((Object)this.translator, (Matcher)Is.is((Matcher)IsNot.not((Object)thatTranslator)));
    }

    @Test
    public void shouldNotBeEqualWhenPropertiesAreDifferent() {
        RestVdbTranslator thatTranslator = new RestVdbTranslator();
        thatTranslator.setId(this.translator.getId());
        thatTranslator.setType(this.translator.getType());
        thatTranslator.setDescription(this.translator.getDescription());
        thatTranslator.setLinks(this.translator.getLinks());
        ArrayList<RestProperty> props = new ArrayList<RestProperty>();
        props.addAll(this.translator.getProperties());
        props.add(new RestProperty("blah", (Object)"blah"));
        thatTranslator.setProperties(props);
        Assert.assertThat((Object)this.translator, (Matcher)Is.is((Matcher)IsNot.not((Object)thatTranslator)));
    }

    @Test
    public void shouldNotBeEqualWhenTypeIsDifferent() {
        RestVdbTranslator thatTranslator = new RestVdbTranslator();
        thatTranslator.setId(this.translator.getId());
        thatTranslator.setType(this.translator.getType() + "blah");
        thatTranslator.setDescription(this.translator.getDescription());
        thatTranslator.setProperties(this.translator.getProperties());
        thatTranslator.setLinks(this.translator.getLinks());
        Assert.assertThat((Object)this.translator.getType(), (Matcher)Is.is((Matcher)IsNot.not((Object)thatTranslator.getType())));
        Assert.assertThat((Object)this.translator, (Matcher)Is.is((Matcher)IsNot.not((Object)thatTranslator)));
    }

    @Test
    public void shouldSetDescription() {
        String newDescription = "blah";
        this.translator.setDescription("blah");
        Assert.assertThat((Object)this.translator.getDescription(), (Matcher)Is.is((Object)"blah"));
    }

    @Test
    public void shouldSetName() {
        String newName = "blah";
        this.translator.setId("blah");
        Assert.assertThat((Object)this.translator.getId(), (Matcher)Is.is((Object)"blah"));
    }

    @Test
    public void shouldSetProperties() {
        ArrayList<RestProperty> newProperties = new ArrayList<RestProperty>();
        newProperties.add(new RestProperty("blah", (Object)"blah"));
        this.translator.setProperties(newProperties);
        Assert.assertThat((Object)this.translator.getProperties().size(), (Matcher)Is.is((Object)newProperties.size()));
    }

    @Test
    public void shouldSetType() {
        String newType = "blah";
        this.translator.setType("blah");
        Assert.assertThat((Object)this.translator.getType(), (Matcher)Is.is((Object)"blah"));
    }

    @Test
    public void shouldHaveCorrectLinks() throws Exception {
        String name = "mysql";
        String dataPath = "/workspace/vdbs/vdb1/vdbTranslators/" + name;
        KomodoType kType = KomodoType.VDB_TRANSLATOR;
        boolean hasChildren = false;
        DescriptorImpl vdbType = new DescriptorImpl(this.repository, "vdb:virtualDatabase");
        Vdb vdb = (Vdb)Mockito.mock(Vdb.class);
        Mockito.when((Object)vdb.getName(this.transaction)).thenReturn((Object)VDB_NAME);
        Mockito.when((Object)vdb.getPrimaryType(this.transaction)).thenReturn((Object)vdbType);
        Translator translator = (Translator)Mockito.mock(Translator.class);
        Mockito.when((Object)translator.getName(this.transaction)).thenReturn((Object)name);
        Mockito.when((Object)translator.getAbsolutePath()).thenReturn((Object)dataPath);
        Mockito.when((Object)translator.getParent(this.transaction)).thenReturn((Object)vdb);
        Mockito.when((Object)translator.getTypeIdentifier(this.transaction)).thenReturn((Object)kType);
        Mockito.when((Object)translator.hasChildren(this.transaction)).thenReturn((Object)hasChildren);
        Mockito.when((Object)translator.getRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)translator.getPropertyNames(this.transaction)).thenReturn((Object)new String[0]);
        Mockito.when((Object)translator.getPropertyDescriptors(this.transaction)).thenReturn((Object)new PropertyDescriptor[0]);
        RestVdbTranslator restTranslator = new RestVdbTranslator(MY_BASE_URI, translator, this.transaction);
        Collection links = restTranslator.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
        int linkCounter = 0;
        for (RestLink link : links) {
            String href = link.getHref().toString();
            if (RestLink.LinkType.SELF.equals((Object)link.getRel())) {
                ++linkCounter;
                Assert.assertEquals((Object)("http://localhost:8081/v1/workspace/vdbs/vdb1/VdbTranslators/" + name), (Object)href);
                continue;
            }
            if (RestLink.LinkType.PARENT.equals((Object)link.getRel())) {
                ++linkCounter;
                Assert.assertEquals((Object)"http://localhost:8081/v1/workspace/vdbs/vdb1", (Object)href);
                continue;
            }
            if (!RestLink.LinkType.CHILDREN.equals((Object)link.getRel())) continue;
            ++linkCounter;
        }
        Assert.assertEquals((long)3L, (long)linkCounter);
    }

    static {
        PROPS.add(new RestProperty("larry", (Object)"bird"));
        PROPS.add(new RestProperty("magic", (Object)"johnson"));
        PROPS.add(new RestProperty("michael", (Object)"jordan"));
        MY_BASE_URI = UriBuilder.fromUri((String)BASE_URI_PREFIX).build(new Object[0]);
    }
}

