/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.junit.Before;
import org.komodo.rest.json.JsonConstants;
import org.komodo.spi.KException;
import org.komodo.spi.repository.Descriptor;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractSerializerTest
implements JsonConstants {
    protected static final String BASE_URI_PREFIX = "http://localhost:8081/v1";
    protected static final URI MY_BASE_URI = UriBuilder.fromUri((String)"http://localhost:8081/v1").build(new Object[0]);
    protected static final String WORKSPACE_DATA_PATH = "/workspace";
    protected static final String VDB_NAME = "vdb1";
    protected static final String VDB_DATA_PATH = "/workspace/vdbs/vdb1";
    protected static final String DATASERVICE_NAME = "dataservice1";
    protected static final String DATASERVICE_DATA_PATH = "/workspace/dataservices/dataservice1";
    protected static final String SEARCH = "/workspace/search?";
    @Mock
    protected Repository.UnitOfWork transaction;
    protected Repository repository;

    protected static String q(String value) {
        return "\"" + value + "\"";
    }

    protected static String colon() {
        return ": ";
    }

    protected static String tab(int freq) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < freq; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    @Before
    public void basicInit() throws KException {
        this.transaction = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        Mockito.when((Object)this.transaction.getState()).thenReturn((Object)Repository.UnitOfWork.State.NOT_STARTED);
        Repository.UnitOfWork uow = (Repository.UnitOfWork)Mockito.mock(Repository.UnitOfWork.class);
        Mockito.when((Object)uow.getState()).thenReturn((Object)Repository.UnitOfWork.State.NOT_STARTED);
        this.repository = (Repository)Mockito.mock(Repository.class);
        Repository.UnitOfWorkListener listener = (Repository.UnitOfWorkListener)Matchers.any();
        Mockito.when((Object)this.repository.createTransaction(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), listener)).thenReturn((Object)uow);
    }

    protected <T extends KomodoObject> T mockObject(Class<T> mockClass, String name, String dataPath, KomodoType kType, boolean hasChildren, String descriptorName) throws KException {
        KomodoObject kObject = (KomodoObject)Mockito.mock(mockClass);
        Mockito.when((Object)kObject.getName(this.transaction)).thenReturn((Object)name);
        Mockito.when((Object)kObject.getAbsolutePath()).thenReturn((Object)dataPath);
        Mockito.when((Object)kObject.getTypeIdentifier(this.transaction)).thenReturn((Object)kType);
        Mockito.when((Object)kObject.hasChildren(this.transaction)).thenReturn((Object)hasChildren);
        Mockito.when((Object)kObject.getRepository()).thenReturn((Object)this.repository);
        if (descriptorName != null) {
            Descriptor primaryDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
            Mockito.when((Object)primaryDescriptor.getName()).thenReturn((Object)descriptorName.toString());
            Mockito.when((Object)kObject.getPrimaryType(this.transaction)).thenReturn((Object)primaryDescriptor);
        }
        return (T)kObject;
    }

    protected <T extends KomodoObject> T mockObject(Class<T> mockClass, String name, String dataPath, KomodoType kType, boolean hasChildren) throws KException {
        return this.mockObject(mockClass, name, dataPath, kType, hasChildren, null);
    }
}

