/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.net.URLEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.dataservice.RestDataservice;
import org.komodo.rest.relational.json.AbstractSerializerTest;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.PropertyDescriptor;
import org.mockito.Mockito;

public final class DataserviceSerializerTest
extends AbstractSerializerTest {
    private static final String DESCRIPTION = "my description";
    private static final KomodoType kType = KomodoType.DATASERVICE;
    private static final String JSON = "{\n  \"keng__baseUri\": \"" + MY_BASE_URI + "\"," + "\n" + "  \"keng__id\": \"" + "dataservice1" + "\"," + "\n" + "  \"keng__dataPath\": \"" + "/workspace/dataservices/dataservice1" + "\"," + "\n" + "  \"keng__kType\": \"Dataservice\"," + "\n" + "  \"keng__hasChildren\": true," + "\n" + "  \"tko__description\": \"my description\"," + "\n" + "  \"serviceVdbVersion\": \"1\"," + "\n" + "  \"serviceViewTables\": []," + "\n" + "  \"connections\": 0," + "\n" + "  \"drivers\": 0," + "\n" + "  \"keng___links\": [" + "\n" + "    " + "{" + "\n" + "      \"rel\": \"self\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/dataservices/dataservice1" + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"parent\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/dataservices\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"children\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode("/workspace/dataservices/dataservice1") + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"vdbs\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/dataservices/dataservice1" + "/Vdbs\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"connections\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/dataservices/dataservice1" + "/connections\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "\n" + "}";
    private RestDataservice dataservice;

    @Before
    public void init() throws Exception {
        KomodoObject workspace = (KomodoObject)Mockito.mock(KomodoObject.class);
        Mockito.when((Object)workspace.getAbsolutePath()).thenReturn((Object)"/workspace");
        Vdb serviceVdb = (Vdb)Mockito.mock(Vdb.class);
        Mockito.when((Object)serviceVdb.getName(this.transaction)).thenReturn((Object)"ServiceVdb");
        Mockito.when((Object)serviceVdb.getVersion(this.transaction)).thenReturn((Object)1);
        Dataservice theService = this.mockObject(Dataservice.class, "dataservice1", "/workspace/dataservices/dataservice1", kType, true);
        Mockito.when((Object)theService.getPropertyNames(this.transaction)).thenReturn((Object)new String[0]);
        Mockito.when((Object)theService.getPropertyDescriptors(this.transaction)).thenReturn((Object)new PropertyDescriptor[0]);
        Mockito.when((Object)theService.getParent(this.transaction)).thenReturn((Object)workspace);
        Mockito.when((Object)theService.getServiceVdb(this.transaction)).thenReturn((Object)serviceVdb);
        this.dataservice = new RestDataservice(MY_BASE_URI, theService, false, this.transaction);
        this.dataservice.setDescription(DESCRIPTION);
    }

    @Test
    public void shouldExportJson() {
        String json = KomodoJsonMarshaller.marshall((KRestEntity)this.dataservice);
        Assert.assertEquals((Object)JSON, (Object)json);
    }

    @Test
    public void shouldImportJson() {
        RestDataservice descriptor = (RestDataservice)KomodoJsonMarshaller.unmarshall((String)JSON, RestDataservice.class);
        Assert.assertEquals((Object)"dataservice1", (Object)descriptor.getId());
        Assert.assertEquals((Object)DESCRIPTION, (Object)descriptor.getDescription());
        Assert.assertEquals((long)5L, (long)descriptor.getLinks().size());
        Assert.assertEquals((Object)true, (Object)descriptor.getProperties().isEmpty());
    }

    @Test(expected=Exception.class)
    public void shouldNotExportJsonWhenNameIsMissing() {
        RestDataservice descriptor = new RestDataservice();
        KomodoJsonMarshaller.marshall((KRestEntity)descriptor);
    }

    @Test(expected=Exception.class)
    public void shouldNotImportJsonWhenIdIsMissing() {
        String malformed = "{\"description\":\"my description\",\"links\":[{\"rel\":\"self\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb\",\"method\":\"GET\"},{\"rel\":\"parent\",\"href\":\"http://localhost:8080/v1/workspace/vdbs\",\"method\":\"GET\"},{\"rel\":\"manifest\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb/manifest\",\"method\":\"GET\"}]}";
        KomodoJsonMarshaller.unmarshall((String)"{\"description\":\"my description\",\"links\":[{\"rel\":\"self\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb\",\"method\":\"GET\"},{\"rel\":\"parent\",\"href\":\"http://localhost:8080/v1/workspace/vdbs\",\"method\":\"GET\"},{\"rel\":\"manifest\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb/manifest\",\"method\":\"GET\"}]}", RestDataservice.class);
    }
}

