/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestQueryColumn;
import org.komodo.rest.relational.response.RestQueryResult;
import org.komodo.rest.relational.response.RestQueryRow;
import org.komodo.spi.constants.StringConstants;

public class QueryResultSerializerTest
implements StringConstants {
    private static String[][] columnsData = new String[][]{{"Id", "ID", "long"}, {"Name", "Name", "varchar"}, {"Code", "Code", "varchar"}};
    private static Object[][] rowsData = new Object[][]{{1, "Florida", "FL"}, {2, "Washington", "WA"}, {3, "Missouri", "MI"}, {4, "District of Columbia", "DC"}, {5, "Montana", "MO"}};
    private static int COLUMN_NAME = 0;
    private static int COLUMN_LABEL = 1;
    private static int COLUMN_TYPE = 2;
    private RestQueryResult queryResult;
    private String JSON;

    private String tab(String text, int num) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            buf.append(" ").append(" ");
        }
        buf.append(text);
        return buf.toString();
    }

    private String tab(String text) {
        return this.tab(text, 1);
    }

    @Before
    public void init() throws Exception {
        StringBuffer jsonBuf = new StringBuffer("{").append("\n");
        jsonBuf.append(this.tab("\"columns\"")).append(":").append(" ").append("[").append("\n");
        ArrayList<RestQueryColumn> columns = new ArrayList<RestQueryColumn>();
        for (int i = 0; i < columnsData.length; ++i) {
            String[] columnData = columnsData[i];
            jsonBuf.append(this.tab("{", 2)).append("\n").append(this.tab("\"name\"", 3)).append(":").append(" ").append("\"").append(columnsData[i][COLUMN_NAME]).append("\"").append(",").append("\n").append(this.tab("\"label\"", 3)).append(":").append(" ").append("\"").append(columnsData[i][COLUMN_LABEL]).append("\"").append(",").append("\n").append(this.tab("\"type\"", 3)).append(":").append(" ").append("\"").append(columnsData[i][COLUMN_TYPE]).append("\"").append("\n").append(this.tab("}", 2));
            if (i + 1 < columnData.length) {
                jsonBuf.append(",");
            }
            jsonBuf.append("\n");
            RestQueryColumn column = new RestQueryColumn();
            column.setName(columnData[COLUMN_NAME]);
            column.setLabel(columnData[COLUMN_LABEL]);
            column.setType(columnData[COLUMN_TYPE]);
            columns.add(column);
        }
        jsonBuf.append(this.tab("]")).append(",").append("\n");
        jsonBuf.append(this.tab("\"rows\"")).append(":").append(" ").append("[").append("\n");
        ArrayList<RestQueryRow> rows = new ArrayList<RestQueryRow>();
        for (int i = 0; i < rowsData.length; ++i) {
            Object[] rowData = rowsData[i];
            jsonBuf.append(this.tab("{", 2)).append("\n").append(this.tab("\"row\"", 3)).append(":").append(" ").append("[").append("\n").append(this.tab("\"", 4)).append(rowData[COLUMN_NAME]).append("\"").append(",").append("\n").append(this.tab("\"", 4)).append(rowData[COLUMN_LABEL]).append("\"").append(",").append("\n").append(this.tab("\"", 4)).append(rowData[COLUMN_TYPE]).append("\"").append("\n").append(this.tab("]", 3)).append("\n").append(this.tab("}", 2));
            if (i + 1 < rowsData.length) {
                jsonBuf.append(",");
            }
            jsonBuf.append("\n");
            RestQueryRow row = new RestQueryRow();
            row.setValues(rowData);
            rows.add(row);
        }
        jsonBuf.append(this.tab("]")).append("\n").append("}");
        this.JSON = jsonBuf.toString();
        this.queryResult = new RestQueryResult();
        this.queryResult.setColumns(columns.toArray(new RestQueryColumn[0]));
        this.queryResult.setRows(rows.toArray(new RestQueryRow[0]));
    }

    @Test
    public void shouldExportResult() throws Exception {
        String json = KomodoJsonMarshaller.marshall((KRestEntity)this.queryResult);
        Assert.assertEquals((Object)this.JSON, (Object)json);
    }

    @Test
    public void shouldImportResult() throws Exception {
        RestQueryResult queryResult = (RestQueryResult)KomodoJsonMarshaller.unmarshall((String)this.JSON, RestQueryResult.class);
        Assert.assertEquals((long)columnsData.length, (long)queryResult.getColumns().length);
        Assert.assertEquals((long)rowsData.length, (long)queryResult.getRows().length);
    }
}

