/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.json.AbstractSerializerTest;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestVdbDataRole;
import org.komodo.rest.relational.response.RestVdbPermission;
import org.komodo.spi.repository.KomodoType;
import org.mockito.Mockito;

public final class VdbDataRoleSerializerTest
extends AbstractSerializerTest {
    private static final String NAME = "MyDataRole";
    private static final String DESCRIPTION = "my description";
    private static final String ROLE_DATA_PATH = "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole";
    private static final String PERMISSION_DATA_PATH = "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission";
    private static final boolean ALLOW_CREATE_TEMP_TABLES = true;
    private static final boolean ANY_AUTHENTICATED = false;
    private static final boolean GRANT_ALL = false;
    private static final List<String> MAPPED_ROLES = Arrays.asList("larry", "curly", "moe");
    private static final String PERMISSION_NAME = "MyPermission";
    private static final boolean ALLOW_ALTER = true;
    private static final boolean ALLOW_CREATE = false;
    private static final boolean ALLOW_DELETE = true;
    private static final boolean ALLOW_EXECUTE = false;
    private static final boolean ALLOW_LANGUAGE = true;
    private static final boolean ALLOW_READ = false;
    private static final boolean ALLOW_UPDATE = true;
    private static final String JSON = "{\n  \"keng__baseUri\": \"" + MY_BASE_URI + "\"," + "\n" + "  \"" + "keng__id" + "\": \"" + "MyDataRole" + "\"," + "\n" + "  \"" + "keng__dataPath" + "\": \"" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole" + "\"," + "\n" + "  \"" + "keng__kType" + "\": \"" + KomodoType.VDB_DATA_ROLE.getType() + "\"," + "\n" + "  \"" + "keng__hasChildren" + "\": true," + "\n" + "  \"vdb__dataRole\": \"" + "MyDataRole" + "\"," + "\n" + "  \"vdb__description\": \"" + "my description" + "\"," + "\n" + "  \"vdb__allowCreateTemporaryTables\": true," + "\n" + "  \"vdb__anyAuthenticated\": false," + "\n" + "  \"vdb__grantAll\": false," + "\n" + "  \"vdb__mappedRoleNames\": [" + "\n" + "    \"larry\"," + "\n" + "    \"curly\"," + "\n" + "    \"moe\"" + "\n" + "  ]," + "\n" + "  \"" + "keng___links" + "\": " + "[" + "\n" + "    " + "{" + "\n" + "      \"rel\": \"self\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole" + '\"' + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"parent\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"children\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode("/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole") + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"permissions\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole" + "/VdbPermissions\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "\n" + "}";
    private static final String JSON2 = "{\n  \"keng__baseUri\": \"" + MY_BASE_URI + "\"," + "\n" + "  \"" + "keng__id" + "\": \"" + "MyDataRole" + "\"," + "\n" + "  \"" + "keng__dataPath" + "\": \"" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole" + "\"," + "\n" + "  \"" + "keng__kType" + "\": \"" + KomodoType.VDB_DATA_ROLE.getType() + "\"," + "\n" + "  \"" + "keng__hasChildren" + "\": true," + "\n" + "  \"vdb__dataRole\": \"" + "MyDataRole" + "\"," + "\n" + "  \"vdb__description\": \"" + "my description" + "\"," + "\n" + "  \"vdb__allowCreateTemporaryTables\": true," + "\n" + "  \"vdb__anyAuthenticated\": false," + "\n" + "  \"vdb__grantAll\": false," + "\n" + "  \"vdb__mappedRoleNames\": [" + "\n" + "    \"larry\"," + "\n" + "    \"curly\"," + "\n" + "    \"moe\"" + "\n" + "  ]," + "\n" + "  \"vdb__permissions\": [\n    {\n      \"" + "keng__baseUri" + "\": \"" + MY_BASE_URI + "\"," + "\n" + "      \"" + "keng__id" + "\": \"" + "MyPermission" + "\"," + "\n" + "      \"" + "keng__dataPath" + "\": \"" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission" + "\"," + "\n" + "      \"" + "keng__kType" + "\": \"" + KomodoType.VDB_PERMISSION.getType() + "\"," + "\n" + "      \"" + "keng__hasChildren" + "\": true," + "\n" + "      \"vdb__permission\": \"" + "MyPermission" + "\",\n      \"vdb__allowAlter\" : " + true + ",\n      \"vdb__allowCreate\" : " + false + ",\n      \"vdb__allowDelete\" : " + true + ",\n      \"vdb__allowExecute\" : " + false + ",\n      \"vdb__allowLanguage\" : " + true + ",\n      \"vdb__allowRead\" : " + false + ",\n      \"vdb__allowUpdate\" : " + true + ",\n      \"" + "keng___links" + "\": [\n        {\n          \"rel\": \"self\"," + "\n" + "          \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission" + '\"' + "\n" + "        },\n        {\n          \"rel\": \"parent\"," + "\n" + "          \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbDataRoles/MyDataRole\"" + "\n" + "        },\n        {\n          \"rel\": \"children\"," + "\n" + "          \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode("/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission") + "\"" + "\n" + "        },\n        {\n          \"rel\": \"conditions\"," + "\n" + "          \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission" + "/VdbConditions\"" + "\n" + "        },\n        {\n          \"rel\": \"masks\"," + "\n" + "          \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission" + "/VdbMasks\"" + "\n" + "        }\n      ]\n    }\n  ],\n  \"" + "keng___links" + "\": " + "[" + "\n" + "    " + "{" + "\n" + "      \"rel\": \"self\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole" + '\"' + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"parent\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"children\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode("/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole") + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"permissions\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1/VdbDataRoles/MyDataRole" + "/VdbPermissions\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "\n" + "}";
    private RestVdbDataRole dataRole;
    private DataRole modelDataRole;

    @Before
    public void init() throws Exception {
        Vdb theVdb = this.mockObject(Vdb.class, "vdb1", "/workspace/vdbs/vdb1", KomodoType.VDB, true);
        this.modelDataRole = this.mockObject(DataRole.class, NAME, ROLE_DATA_PATH, KomodoType.VDB_DATA_ROLE, true);
        Mockito.when((Object)this.modelDataRole.getParent(this.transaction)).thenReturn((Object)theVdb);
        Mockito.when((Object)this.modelDataRole.getPermissions(this.transaction, new String[0])).thenReturn((Object)Permission.NO_PERMISSIONS);
        this.dataRole = new RestVdbDataRole(MY_BASE_URI, this.modelDataRole, this.transaction);
        this.dataRole.setName(NAME);
        this.dataRole.setDescription(DESCRIPTION);
        this.dataRole.setAllowCreateTempTables(true);
        this.dataRole.setAnyAuthenticated(false);
        this.dataRole.setGrantAll(false);
        this.dataRole.setMappedRoles(MAPPED_ROLES.toArray(new String[MAPPED_ROLES.size()]));
    }

    @Test
    public void shouldExportJson() {
        String json = KomodoJsonMarshaller.marshall((KRestEntity)this.dataRole);
        Assert.assertEquals((Object)JSON, (Object)json);
    }

    @Test
    public void shouldExportJsonWithPermissions() throws Exception {
        Permission permission = this.mockObject(Permission.class, PERMISSION_NAME, PERMISSION_DATA_PATH, KomodoType.VDB_PERMISSION, true);
        Mockito.when((Object)permission.getParent(this.transaction)).thenReturn((Object)this.modelDataRole);
        RestVdbPermission restPermission = new RestVdbPermission(MY_BASE_URI, permission, this.transaction);
        restPermission.setAllowAlter(true);
        restPermission.setAllowCreate(false);
        restPermission.setAllowDelete(true);
        restPermission.setAllowExecute(false);
        restPermission.setAllowLanguage(true);
        restPermission.setAllowRead(false);
        restPermission.setAllowUpdate(true);
        restPermission.setName(PERMISSION_NAME);
        restPermission.setId(PERMISSION_NAME);
        restPermission.setDataPath(PERMISSION_DATA_PATH);
        restPermission.setkType(KomodoType.VDB_PERMISSION);
        this.dataRole.setPermissions(new RestVdbPermission[]{restPermission});
        String json = KomodoJsonMarshaller.marshall((KRestEntity)this.dataRole);
        Assert.assertThat((Object)json.contains(RestVdbDataRole.PERMISSIONS_LABEL), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(PERMISSION_NAME), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(RestVdbPermission.ALLOW_ALTER_LABEL), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(RestVdbPermission.ALLOW_CREATE_LABEL), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(RestVdbPermission.ALLOW_DELETE_LABEL), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(RestVdbPermission.ALLOW_EXECUTE_LABEL), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(RestVdbPermission.ALLOW_LANGUAGE_LABEL), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(RestVdbPermission.ALLOW_READ_LABEL), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)json.contains(RestVdbPermission.ALLOW_UPDATE_LABEL), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldImportJson() {
        RestVdbDataRole dataRole = (RestVdbDataRole)KomodoJsonMarshaller.unmarshall((String)JSON, RestVdbDataRole.class);
        Assert.assertThat((Object)dataRole.getDescription(), (Matcher)Is.is((Object)DESCRIPTION));
        Assert.assertThat((Object)dataRole.getName(), (Matcher)Is.is((Object)NAME));
        Assert.assertThat((Object)dataRole.isAllowCreateTempTables(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dataRole.isAnyAuthenticated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)dataRole.isGrantAll(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)dataRole.getLinks().size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)dataRole.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dataRole.getMappedRoles().length, (Matcher)Is.is((Object)MAPPED_ROLES.size()));
        Assert.assertThat((Object)dataRole.getPermissions().length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldImportJsonWithPermissions() {
        RestVdbDataRole dataRole = (RestVdbDataRole)KomodoJsonMarshaller.unmarshall((String)JSON2, RestVdbDataRole.class);
        RestVdbPermission[] permissions = dataRole.getPermissions();
        Assert.assertThat((Object)permissions.length, (Matcher)Is.is((Object)1));
        RestVdbPermission permission = permissions[0];
        Assert.assertThat((Object)permission.getName(), (Matcher)Is.is((Object)PERMISSION_NAME));
        Assert.assertThat((Object)permission.isAllowAlter(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.isAllowCreate(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permission.isAllowDelete(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.isAllowExecute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permission.isAllowLanguage(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.isAllowRead(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permission.isAllowUpdate(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.getLinks().size(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)permission.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=Exception.class)
    public void shouldNotExportWhenNameIsMissing() {
        RestVdbDataRole incomplete = new RestVdbDataRole();
        KomodoJsonMarshaller.marshall((KRestEntity)incomplete);
    }

    @Test(expected=Exception.class)
    public void shouldNotImportJsonWhenIdIsMissing() {
        String malformed = "{\"description\":\"my description\"anyAuthenticated,\"allowCreateTempTables\":true,\"grantAll\":false,\"mappedRoles\":[\"larry\",\"curly\",\"moe\"]}";
        KomodoJsonMarshaller.unmarshall((String)"{\"description\":\"my description\"anyAuthenticated,\"allowCreateTempTables\":true,\"grantAll\":false,\"mappedRoles\":[\"larry\",\"curly\",\"moe\"]}", RestVdbDataRole.class);
    }
}

