/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.net.URLEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.json.AbstractSerializerTest;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestVdbImport;
import org.komodo.spi.repository.KomodoType;
import org.mockito.Mockito;

public final class VdbImportSerializerTest
extends AbstractSerializerTest {
    private static final String IMP_DATA_PATH = "/workspace/vdbs/vdb1/vdbImports/MyImport";
    private static final boolean IMPORT_DATA_POLICIES = true;
    private static final String NAME = "MyImport";
    private static final int VERSION = 2;
    private static final String JSON = "{\n  \"keng__baseUri\": \"" + MY_BASE_URI + "\"," + "\n" + "  \"" + "keng__id" + "\": \"" + "MyImport" + "\"," + "\n" + "  \"" + "keng__dataPath" + "\": \"" + "/workspace/vdbs/vdb1/vdbImports/MyImport" + "\"," + "\n" + "  \"" + "keng__kType" + "\": \"" + KomodoType.VDB_IMPORT.getType() + "\"," + "\n" + "  \"" + "keng__hasChildren" + "\": false," + "\n" + "  \"vdb__importVdb\": \"" + "MyImport" + "\"," + "\n" + "  \"vdb__version\": 2," + "\n" + "  \"vdb__importDataPolicies\": true," + "\n" + "  \"" + "keng___links" + "\": " + "[" + "\n" + "    " + "{" + "\n" + "      \"rel\": \"self\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbImports/MyImport\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"parent\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"children\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode("/workspace/vdbs/vdb1/vdbImports/MyImport") + "\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "\n" + "}";
    private RestVdbImport vdbImport;

    @Before
    public void init() throws Exception {
        Vdb theVdb = this.mockObject(Vdb.class, "vdb1", "/workspace/vdbs/vdb1", KomodoType.VDB, true);
        VdbImport theImport = this.mockObject(VdbImport.class, NAME, IMP_DATA_PATH, KomodoType.VDB_IMPORT, false);
        Mockito.when((Object)theImport.getParent(this.transaction)).thenReturn((Object)theVdb);
        this.vdbImport = new RestVdbImport(MY_BASE_URI, theImport, this.transaction);
        this.vdbImport.setName(NAME);
        this.vdbImport.setVersion(2);
        this.vdbImport.setImportDataPolicies(true);
    }

    @Test
    public void shouldExport() {
        String importValue = KomodoJsonMarshaller.marshall((KRestEntity)this.vdbImport);
        Assert.assertEquals((Object)JSON, (Object)importValue);
    }

    @Test
    public void shouldImport() {
        RestVdbImport vdbImport = (RestVdbImport)KomodoJsonMarshaller.unmarshall((String)JSON, RestVdbImport.class);
        Assert.assertThat((Object)vdbImport.isImportDataPolicies(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)vdbImport.getName(), (Matcher)Is.is((Object)NAME));
        Assert.assertThat((Object)vdbImport.getVersion(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)vdbImport.getLinks().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)vdbImport.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=Exception.class)
    public void shouldNotExportWhenNameIsMissing() {
        RestVdbImport incomplete = new RestVdbImport();
        incomplete.setImportDataPolicies(true);
        incomplete.setVersion(2);
        KomodoJsonMarshaller.marshall((KRestEntity)incomplete);
    }

    @Test(expected=Exception.class)
    public void shouldNotImportWhenIdIsMissing() {
        String malformed = "{\"vdb__version\":5,\"vdb__importDataPolicies\":false}";
        KomodoJsonMarshaller.unmarshall((String)"{\"vdb__version\":5,\"vdb__importDataPolicies\":false}", RestVdbImport.class);
    }
}

