/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.net.URLEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.json.AbstractSerializerTest;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestVdbPermission;
import org.komodo.spi.repository.KomodoType;
import org.mockito.Mockito;

public final class VdbPermissionSerializerTest
extends AbstractSerializerTest {
    private static final String DATA_ROLE_NAME = "MyDataRole";
    private static final String DATA_ROLE_DATA_PATH = "/workspace/vdbs/vdb1/vdbDataRoles/MyDataRole";
    private static final String NAME = "MyPermission";
    private static final String PERM_DATA_PATH = "/workspace/vdbs/vdb1/vdbDataRoles/MyDataRole/permissions/MyPermission";
    private static final boolean ALLOW_ALTER = true;
    private static final boolean ALLOW_CREATE = false;
    private static final boolean ALLOW_DELETE = true;
    private static final boolean ALLOW_EXECUTE = false;
    private static final boolean ALLOW_LANGUAGE = true;
    private static final boolean ALLOW_READ = false;
    private static final boolean ALLOW_UPDATE = true;
    private static final String JSON = "{\n  \"keng__baseUri\": \"" + MY_BASE_URI + "\"," + "\n" + "  \"" + "keng__id" + "\": \"" + "MyPermission" + "\"," + "\n" + "  \"" + "keng__dataPath" + "\": \"" + "/workspace/vdbs/vdb1/vdbDataRoles/MyDataRole/permissions/MyPermission" + "\"," + "\n" + "  \"" + "keng__kType" + "\": \"" + KomodoType.VDB_PERMISSION.getType() + "\"," + "\n" + "  \"" + "keng__hasChildren" + "\": true," + "\n" + "  \"vdb__permission\": \"" + "MyPermission" + "\"," + "\n" + "  \"vdb__allowAlter\": true," + "\n" + "  \"vdb__allowCreate\": false," + "\n" + "  \"vdb__allowDelete\": true," + "\n" + "  \"vdb__allowExecute\": false," + "\n" + "  \"vdb__allowLanguage\": true," + "\n" + "  \"vdb__allowRead\": false," + "\n" + "  \"vdb__allowUpdate\": true," + "\n" + "  \"" + "keng___links" + "\": " + "[" + "\n" + "    " + "{" + "\n" + "      \"rel\": \"self\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"parent\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbDataRoles/MyDataRole\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"children\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode("/workspace/vdbs/vdb1/vdbDataRoles/MyDataRole/permissions/MyPermission") + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"conditions\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission/VdbConditions\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"masks\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbDataRoles/MyDataRole/VdbPermissions/MyPermission/VdbMasks\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "\n" + "}";
    private RestVdbPermission permission;

    @Before
    public void init() throws Exception {
        Vdb theVdb = this.mockObject(Vdb.class, "vdb1", "/workspace/vdbs/vdb1", KomodoType.VDB, true);
        DataRole theDataRole = this.mockObject(DataRole.class, DATA_ROLE_NAME, DATA_ROLE_DATA_PATH, KomodoType.VDB_DATA_ROLE, true);
        Mockito.when((Object)theDataRole.getParent(this.transaction)).thenReturn((Object)theVdb);
        Permission thePermission = this.mockObject(Permission.class, NAME, PERM_DATA_PATH, KomodoType.VDB_PERMISSION, true);
        Mockito.when((Object)thePermission.getParent(this.transaction)).thenReturn((Object)theDataRole);
        this.permission = new RestVdbPermission(MY_BASE_URI, thePermission, this.transaction);
        this.permission.setName(NAME);
        this.permission.setAllowAlter(true);
        this.permission.setAllowCreate(false);
        this.permission.setAllowDelete(true);
        this.permission.setAllowExecute(false);
        this.permission.setAllowLanguage(true);
        this.permission.setAllowRead(false);
        this.permission.setAllowUpdate(true);
    }

    @Test
    public void shouldExportJson() {
        String json = KomodoJsonMarshaller.marshall((KRestEntity)this.permission);
        Assert.assertEquals((Object)JSON, (Object)json);
    }

    @Test
    public void shouldImportJson() {
        RestVdbPermission permission = (RestVdbPermission)KomodoJsonMarshaller.unmarshall((String)JSON, RestVdbPermission.class);
        Assert.assertThat((Object)permission.getName(), (Matcher)Is.is((Object)NAME));
        Assert.assertThat((Object)permission.isAllowAlter(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.isAllowCreate(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permission.isAllowDelete(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.isAllowExecute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permission.isAllowLanguage(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.isAllowRead(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permission.isAllowUpdate(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permission.getLinks().size(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)permission.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=Exception.class)
    public void shouldNotExportWhenNameIsMissing() {
        RestVdbPermission incomplete = new RestVdbPermission();
        KomodoJsonMarshaller.marshall((KRestEntity)incomplete);
    }

    @Test(expected=Exception.class)
    public void shouldNotImportJsonWhenIdIsMissing() {
        String malformed = "{\"allowAlter\":true,\"allowCreate\":false,\"allowDelete\":true,\"allowExecute\":false,\"allowLanguage\":true,\"allowRead\":false,\"allowUpdate\":true,\"conditions\":{\"over\":true,\"the\":false,\"rainbow\":true},\"masks\":{\"this\":\"that\",\"either\":\"or\",\"sixofone\":\"halfdozenofanother\"}}";
        KomodoJsonMarshaller.unmarshall((String)"{\"allowAlter\":true,\"allowCreate\":false,\"allowDelete\":true,\"allowExecute\":false,\"allowLanguage\":true,\"allowRead\":false,\"allowUpdate\":true,\"conditions\":{\"over\":true,\"the\":false,\"rainbow\":true},\"masks\":{\"this\":\"that\",\"either\":\"or\",\"sixofone\":\"halfdozenofanother\"}}", RestVdbPermission.class);
    }
}

