/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.net.URLEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.json.AbstractSerializerTest;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.PropertyDescriptor;
import org.mockito.Mockito;

public final class VdbSerializerTest
extends AbstractSerializerTest {
    private static final String DESCRIPTION = "my description";
    private static final String ORIGINAL_FILE = "/Users/ElvisIsKing/MyVdb.xml";
    private static final KomodoType kType = KomodoType.VDB;
    private static final String CONNECTION_TYPE = "BY_VERSION";
    private static final int VERSION = 1;
    private static final String JSON = "{\n  \"keng__baseUri\": \"" + MY_BASE_URI + "\"," + "\n" + "  \"keng__id\": \"" + "vdb1" + "\"," + "\n" + "  \"keng__dataPath\": \"" + "/workspace/vdbs/vdb1" + "\"," + "\n" + "  \"keng__kType\": \"Vdb\"," + "\n" + "  \"keng__hasChildren\": true," + "\n" + "  \"vdb__name\": \"" + "vdb1" + "\"," + "\n" + "  \"vdb__description\": \"my description\"," + "\n" + "  \"vdb__originalFile\": \"/Users/ElvisIsKing/MyVdb.xml\"," + "\n" + "  \"vdb__preview\": false," + "\n" + "  \"vdb__connectionType\": \"BY_VERSION\"," + "\n" + "  \"vdb__version\": 1," + "\n" + "  \"keng___links\": [" + "\n" + "    " + "{" + "\n" + "      \"rel\": \"self\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"parent\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"children\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode("/workspace/vdbs/vdb1") + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"imports\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbImports\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"models\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/Models\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"translators\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbTranslators\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"dataRoles\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbDataRoles\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "\n" + "}";
    private RestVdb vdb;

    @Before
    public void init() throws Exception {
        KomodoObject workspace = (KomodoObject)Mockito.mock(KomodoObject.class);
        Mockito.when((Object)workspace.getAbsolutePath()).thenReturn((Object)"/workspace");
        Vdb theVdb = this.mockObject(Vdb.class, "vdb1", "/workspace/vdbs/vdb1", kType, true);
        Mockito.when((Object)theVdb.getPropertyNames(this.transaction)).thenReturn((Object)new String[0]);
        Mockito.when((Object)theVdb.getPropertyDescriptors(this.transaction)).thenReturn((Object)new PropertyDescriptor[0]);
        Mockito.when((Object)theVdb.getParent(this.transaction)).thenReturn((Object)workspace);
        this.vdb = new RestVdb(MY_BASE_URI, theVdb, false, this.transaction);
        this.vdb.setName("vdb1");
        this.vdb.setDescription(DESCRIPTION);
        this.vdb.setOriginalFilePath(ORIGINAL_FILE);
        this.vdb.setConnectionType(CONNECTION_TYPE);
        this.vdb.setPreview(false);
        this.vdb.setVersion(1);
    }

    @Test
    public void shouldExportJson() {
        String json = KomodoJsonMarshaller.marshall((KRestEntity)this.vdb);
        Assert.assertEquals((Object)JSON, (Object)json);
    }

    @Test
    public void shouldImportJson() {
        RestVdb descriptor = (RestVdb)KomodoJsonMarshaller.unmarshall((String)JSON, RestVdb.class);
        Assert.assertEquals((Object)"vdb1", (Object)descriptor.getName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)descriptor.getDescription());
        Assert.assertEquals((Object)ORIGINAL_FILE, (Object)descriptor.getOriginalFilePath());
        Assert.assertEquals((long)7L, (long)descriptor.getLinks().size());
        Assert.assertEquals((Object)true, (Object)descriptor.getProperties().isEmpty());
    }

    @Test(expected=Exception.class)
    public void shouldNotExportJsonWhenNameIsMissing() {
        RestVdb descriptor = new RestVdb();
        KomodoJsonMarshaller.marshall((KRestEntity)descriptor);
    }

    @Test(expected=Exception.class)
    public void shouldNotImportJsonWhenIdIsMissing() {
        String malformed = "{\"description\":\"my description\",\"links\":[{\"rel\":\"self\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb\",\"method\":\"GET\"},{\"rel\":\"parent\",\"href\":\"http://localhost:8080/v1/workspace/vdbs\",\"method\":\"GET\"},{\"rel\":\"manifest\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb/manifest\",\"method\":\"GET\"}]}";
        KomodoJsonMarshaller.unmarshall((String)"{\"description\":\"my description\",\"links\":[{\"rel\":\"self\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb\",\"method\":\"GET\"},{\"rel\":\"parent\",\"href\":\"http://localhost:8080/v1/workspace/vdbs\",\"method\":\"GET\"},{\"rel\":\"manifest\",\"href\":\"http://localhost:8080/v1/workspace/vdbs/MyVdb/manifest\",\"method\":\"GET\"}]}", RestVdb.class);
    }
}

