/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.core.repository.DescriptorImpl;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.json.AbstractSerializerTest;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestVdbTranslator;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.PropertyDescriptor;
import org.mockito.Mockito;

public final class VdbTranslatorSerializerTest
extends AbstractSerializerTest {
    private static final String TR_DATA_PATH = "/workspace/vdbs/vdb1/vdbTranslators/MyTranslator";
    private static final String DESCRIPTION = "my description";
    private static final String NAME = "MyTranslator";
    private static final int NUM_PROPS = 3;
    private static final String TYPE = "oracle";
    private static final String[] PROPS_KEYS = new String[]{"larry", "magic", "michael"};
    private static final String[] PROPS_VALUES = new String[]{"bird", "johnson", "jordan"};
    private static final List<RestProperty> PROPS = new ArrayList<RestProperty>();
    private static final String JSON;
    private RestVdbTranslator translator;

    @Before
    public void init() throws Exception {
        DescriptorImpl vdbType = new DescriptorImpl(this.repository, "vdb:virtualDatabase");
        Vdb theVdb = this.mockObject(Vdb.class, "vdb1", "/workspace/vdbs/vdb1", KomodoType.VDB, true);
        Mockito.when((Object)theVdb.getPrimaryType(this.transaction)).thenReturn((Object)vdbType);
        Translator theTranslator = this.mockObject(Translator.class, NAME, TR_DATA_PATH, KomodoType.VDB_TRANSLATOR, false);
        Mockito.when((Object)theTranslator.getParent(this.transaction)).thenReturn((Object)theVdb);
        Mockito.when((Object)theTranslator.getPropertyNames(this.transaction)).thenReturn((Object)PROPS_KEYS);
        Mockito.when((Object)theTranslator.getPropertyDescriptors(this.transaction)).thenReturn((Object)new PropertyDescriptor[0]);
        this.translator = new RestVdbTranslator(MY_BASE_URI, theTranslator, this.transaction);
        this.translator.setDescription(DESCRIPTION);
        this.translator.setType(TYPE);
        this.translator.setProperties(PROPS);
    }

    @Test
    public void shouldExportJson() {
        String json = KomodoJsonMarshaller.marshall((KRestEntity)this.translator);
        Assert.assertEquals((Object)JSON, (Object)json);
    }

    @Test
    public void shouldImportJson() {
        RestVdbTranslator translator = (RestVdbTranslator)KomodoJsonMarshaller.unmarshall((String)JSON, RestVdbTranslator.class);
        Assert.assertThat((Object)translator.getDescription(), (Matcher)Is.is((Object)DESCRIPTION));
        Assert.assertThat((Object)translator.getId(), (Matcher)Is.is((Object)NAME));
        Assert.assertThat((Object)translator.getType(), (Matcher)Is.is((Object)TYPE));
        Assert.assertThat((Object)translator.getLinks().size(), (Matcher)Is.is((Object)3));
        Assert.assertEquals((long)translator.getProperties().size(), (long)3L);
        for (RestProperty property : translator.getProperties()) {
            Assert.assertTrue((boolean)PROPS.contains(property));
        }
    }

    @Test(expected=Exception.class)
    public void shouldNotExportWhenNameIsMissing() {
        RestVdbTranslator incomplete = new RestVdbTranslator();
        this.translator.setType(TYPE);
        KomodoJsonMarshaller.marshall((KRestEntity)incomplete);
    }

    @Test(expected=Exception.class)
    public void shouldNotExportWhenTypeIsMissing() {
        RestVdbTranslator incomplete = new RestVdbTranslator();
        this.translator.setId(NAME);
        KomodoJsonMarshaller.marshall((KRestEntity)incomplete);
    }

    @Test(expected=Exception.class)
    public void shouldNotImportJsonWhenIdIsMissing() {
        String malformed = "{\"type\":\"oracle\",\"description\":\"my description\",\"properties\":{\"magic\":\"johnson\",\"michael\":\"jordan\",\"larry\":\"bird\"}}";
        KomodoJsonMarshaller.unmarshall((String)"{\"type\":\"oracle\",\"description\":\"my description\",\"properties\":{\"magic\":\"johnson\",\"michael\":\"jordan\",\"larry\":\"bird\"}}", RestVdbTranslator.class);
    }

    @Test(expected=Exception.class)
    public void shouldNotImportJsonWhenTypeIsMissing() {
        String malformed = "{\"id\":\"MyTranslator\",\"description\":\"my description\",\"properties\":{\"magic\":\"johnson\",\"michael\":\"jordan\",\"larry\":\"bird\"}}";
        KomodoJsonMarshaller.unmarshall((String)"{\"id\":\"MyTranslator\",\"description\":\"my description\",\"properties\":{\"magic\":\"johnson\",\"michael\":\"jordan\",\"larry\":\"bird\"}}", RestVdbTranslator.class);
    }

    static {
        for (int i = 0; i < PROPS_KEYS.length; ++i) {
            PROPS.add(new RestProperty(PROPS_KEYS[i], (Object)PROPS_VALUES[i]));
        }
        JSON = "{\n  \"keng__baseUri\": \"" + MY_BASE_URI + "\"," + "\n" + "  \"" + "keng__id" + "\": \"" + NAME + "\"," + "\n" + "  \"" + "keng__dataPath" + "\": \"" + TR_DATA_PATH + "\"," + "\n" + "  \"" + "keng__kType" + "\": \"" + KomodoType.VDB_TRANSLATOR.getType() + "\"," + "\n" + "  \"" + "keng__hasChildren" + "\": false," + "\n" + "  \"vdb__description\": \"my description\"" + "," + "\n" + "  \"vdb__type\": \"oracle\"" + "," + "\n" + "  \"keng__properties\": " + "[" + "\n" + "    " + "{" + "\n" + "      \"name\": \"larry\"" + "," + "\n" + "      \"value\": \"bird\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"name\": \"magic\"" + "," + "\n" + "      \"value\": \"johnson\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"name\": \"michael\"" + "," + "\n" + "      \"value\": \"jordan\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "," + "\n" + "  \"" + "keng___links" + "\": " + "[" + "\n" + "    " + "{" + "\n" + "      \"rel\": \"self\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "/VdbTranslators/MyTranslator\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"parent\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/vdbs/vdb1" + "\"" + "\n" + "    " + "}" + "," + "\n" + "    " + "{" + "\n" + "      \"rel\": \"children\"," + "\n" + "      \"href\": \"" + "http://localhost:8081/v1" + "/workspace/search?" + "parent\\u003d" + URLEncoder.encode(TR_DATA_PATH) + "\"" + "\n" + "    " + "}" + "\n" + "  " + "]" + "\n" + "}";
    }
}

