/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.spi.constants.StringConstants;
import org.komodo.utils.FileUtils;

public class AbstractFrameworkTest
implements StringConstants,
KomodoRestV1Application.V1Constants {
    protected static int TEST_PORT = 8080;
    protected static String USER_NAME = "anonymous";
    protected static String PASSWORD = "user";
    protected static Path _kengineDataDir;
    protected static KomodoRestUriBuilder _uriBuilder;

    @BeforeClass
    public static void beforeAll() throws Exception {
        _kengineDataDir = Files.createTempDirectory(null, new FileAttribute[0]);
        System.setProperty("komodo.dataDir", _kengineDataDir.toString());
    }

    @AfterClass
    public static void afterAll() throws Exception {
        if (_kengineDataDir != null) {
            FileUtils.removeDirectoryAndChildren((File)_kengineDataDir.toFile());
        }
        try {
            Files.deleteIfExists(_kengineDataDir);
        }
        catch (Exception ex) {
            _kengineDataDir.toFile().deleteOnExit();
        }
    }

    protected HttpClient requestClient() {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        return httpClient;
    }

    protected HttpResponse execute(HttpUriRequest request) throws Exception {
        return this.requestClient().execute(request);
    }

    protected HttpResponse executeOk(HttpUriRequest request) throws Exception {
        HttpResponse response = this.execute(request);
        this.okResponse(response);
        return response;
    }

    protected void addHeader(HttpUriRequest request, String name, Object value) {
        Assert.assertNotNull((Object)name);
        Assert.assertNotNull((Object)value);
        request.setHeader(name, value.toString());
    }

    protected void addJsonConsumeContentType(HttpUriRequest request) {
        this.addHeader(request, "Content-Type", "application/json");
    }

    protected void addXmlConsumeContentType(HttpUriRequest request) {
        this.addHeader(request, "Content-Type", "application/xml");
    }

    protected void addBody(HttpEntityEnclosingRequestBase request, String bodyText) throws UnsupportedEncodingException {
        StringEntity requestEntity = new StringEntity(bodyText, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)requestEntity);
    }

    protected void addBody(HttpEntityEnclosingRequestBase request, KRestEntity bodyObject) throws UnsupportedEncodingException {
        String body = KomodoJsonMarshaller.marshall((KRestEntity)bodyObject);
        StringEntity requestEntity = new StringEntity(body, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)requestEntity);
    }

    protected void addBody(HttpEntityEnclosingRequestBase request, KRestEntity[] bodyObject) throws UnsupportedEncodingException {
        String body = KomodoJsonMarshaller.marshallArray((KRestEntity[])bodyObject, (boolean)false);
        StringEntity requestEntity = new StringEntity(body, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)requestEntity);
    }

    protected <T extends HttpUriRequest> T request(URI uri, RequestType requestType, MediaType type) throws Exception {
        switch (requestType) {
            case GET: {
                HttpGet request = new HttpGet(uri);
                if (type != null) {
                    request.setHeader("Accept", type.toString());
                }
                return (T)request;
            }
            case POST: {
                HttpPost request = new HttpPost(uri);
                if (type != null) {
                    request.setHeader("Accept", type.toString());
                }
                return (T)request;
            }
            case PUT: {
                HttpPut request = new HttpPut(uri);
                if (type != null) {
                    request.setHeader("Accept", type.toString());
                }
                return (T)request;
            }
            case DELETE: {
                HttpDelete request = new HttpDelete(uri);
                if (type != null) {
                    request.setHeader("Accept", type.toString());
                }
                return (T)request;
            }
        }
        Assert.fail((String)("Request type " + (Object)((Object)requestType) + " not supported"));
        return null;
    }

    protected <T extends HttpUriRequest> T jsonRequest(URI uri, RequestType requestType) throws Exception {
        return this.request(uri, requestType, MediaType.APPLICATION_JSON_TYPE);
    }

    protected String extractResponse(HttpResponse response) throws IOException {
        Assert.assertNotNull((Object)response);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        String value = EntityUtils.toString((HttpEntity)entity);
        Assert.assertNotNull((Object)value);
        return value;
    }

    protected void assertResponse(HttpResponse response, int expectedStatusCode) throws Exception {
        Assert.assertNotNull((Object)response);
        StatusLine status = response.getStatusLine();
        if (expectedStatusCode != status.getStatusCode()) {
            String value = EntityUtils.toString((HttpEntity)response.getEntity());
            Assert.fail((String)(status + ":" + " " + value));
        }
    }

    protected void okResponse(HttpResponse response) throws Exception {
        Assert.assertNotNull((Object)response);
        StatusLine status = response.getStatusLine();
        if (200 != status.getStatusCode()) {
            String value = EntityUtils.toString((HttpEntity)response.getEntity());
            Assert.fail((String)(status + ":" + " " + value));
        }
    }

    public static enum RequestType {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

