/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.komodo.core.internal.repository.search.ComparisonOperator;
import org.komodo.core.internal.repository.search.ObjectSearcher;
import org.komodo.core.repository.SynchronousCallback;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.RestLink;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;
import org.komodo.test.utils.TestUtilities;

public abstract class AbstractKomodoServiceTest
extends AbstractFrameworkTest {
    protected static KomodoRestV1Application _restApp;
    protected static TJWSEmbeddedJaxrsServer _server;
    private static URI _appUri;

    @BeforeClass
    public static void beforeAll() throws Exception {
        _restApp = new KomodoRestV1Application();
        _server = new TJWSEmbeddedJaxrsServer();
        _server.setPort(TEST_PORT);
        _server.getDeployment().setApplication((Application)_restApp);
        _server.start();
        System.setProperty("org.jboss.resteasy.port", Integer.toString(TEST_PORT));
        URI baseUri = URI.create("http://localhost:8080");
        _appUri = UriBuilder.fromUri((URI)baseUri).scheme("http").build(new Object[0]);
        _uriBuilder = new KomodoRestUriBuilder(_appUri);
    }

    @AfterClass
    public static void afterAll() throws Exception {
        if (_server != null) {
            _server.stop();
        }
        if (_restApp != null) {
            _restApp.stop();
        }
    }

    @After
    public void afterEach() throws Exception {
        _restApp.clearRepository();
    }

    @Before
    public void beforeEach() {
    }

    protected KomodoRestV1Application getRestApp() {
        return _restApp;
    }

    protected void loadVdbs() throws Exception {
        _restApp.importVdb(TestUtilities.allElementsExample(), USER_NAME);
        _restApp.importVdb(TestUtilities.portfolioExample(), USER_NAME);
        _restApp.importVdb(TestUtilities.partsWithKeysExample(), USER_NAME);
        _restApp.importVdb(TestUtilities.tweetExample(), USER_NAME);
        Assert.assertEquals((long)4L, (long)_restApp.getVdbs(USER_NAME).length);
    }

    protected void loadStatesDataService() throws Exception {
        _restApp.importDataservice(TestUtilities.usStatesDataserviceExample(), USER_NAME);
    }

    protected void loadServiceSourceVdb() throws Exception {
        _restApp.importVdb(TestUtilities.usStatesSourceExample(), USER_NAME);
        Assert.assertEquals((long)1L, (long)_restApp.getVdbs(USER_NAME).length);
    }

    protected void loadDsbSingleSourceDataService() throws Exception {
        _restApp.importDataservice(TestUtilities.dsbDataserviceSingleSourceParts(), USER_NAME);
    }

    protected void loadDsbJoinDifferentTableNamesDataService() throws Exception {
        _restApp.importDataservice(TestUtilities.dsbDataserviceJoinDifferentTableNames(), USER_NAME);
    }

    protected void loadDsbJoinSameTableNamesDataService() throws Exception {
        _restApp.importDataservice(TestUtilities.dsbDataserviceJoinSameTableNames(), USER_NAME);
    }

    protected void createDataservice(String serviceName) throws Exception {
        _restApp.createDataservice(serviceName, false, USER_NAME);
        Assert.assertEquals((long)1L, (long)_restApp.getDataservices(USER_NAME).length);
    }

    protected void createConnection(String connectionName) throws Exception {
        _restApp.createConnection(connectionName, USER_NAME);
        Assert.assertEquals((long)1L, (long)_restApp.getConnections(USER_NAME).length);
    }

    protected void createDriver(String driverName) throws Exception {
        _restApp.createDriver(driverName);
        Assert.assertEquals((long)1L, (long)_restApp.getDrivers().length);
    }

    protected void createVdb(String vdbName) throws Exception {
        _restApp.createVdb(vdbName, USER_NAME);
        Assert.assertEquals((long)1L, (long)_restApp.getVdbs(USER_NAME).length);
    }

    protected void createVdbModel(String vdbName, String modelName) throws Exception {
        _restApp.createVdbModel(vdbName, modelName, USER_NAME);
        Assert.assertEquals((long)1L, (long)_restApp.getVdbs(USER_NAME).length);
    }

    protected List<String> loadSampleSearches() throws Exception {
        ArrayList<String> searchNames = new ArrayList<String>();
        Repository repository = _restApp.getDefaultRepository();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "SaveSearchInWorkspace" + ":" + System.currentTimeMillis(), false, (Repository.UnitOfWorkListener)callback);
        ObjectSearcher vdbsSearch = new ObjectSearcher(repository);
        vdbsSearch.setFromType("vdb:virtualDatabase", "vdbs");
        String vdbSearchName = "Vdbs Search";
        vdbsSearch.write(uow, vdbSearchName);
        ObjectSearcher columnsSearch = new ObjectSearcher(repository);
        columnsSearch.setFromType("teiidddl:tableElement", "c");
        String columnSearchName = "Columns Search";
        columnsSearch.write(uow, columnSearchName);
        ObjectSearcher columnsWithParamSearch = new ObjectSearcher(repository);
        columnsWithParamSearch.setFromType("teiidddl:tableElement", "c");
        columnsWithParamSearch.addWhereCompareClause(null, "c", "mode:localName", ComparisonOperator.LIKE, "{valueParam}");
        String columnsWithParamSearchName = "Columns Search With Where Parameter";
        columnsWithParamSearch.write(uow, columnsWithParamSearchName);
        ObjectSearcher fromParameterSearch = new ObjectSearcher(repository);
        fromParameterSearch.setFromType("{fromTypeParam}", "c");
        String fromParamSearchName = "From Parameter Search";
        fromParameterSearch.write(uow, fromParamSearchName);
        uow.commit();
        if (!callback.await(3L, TimeUnit.MINUTES)) {
            throw new Exception("Timed out while loading saved searches");
        }
        if (callback.error() != null) {
            throw new Exception(callback.error());
        }
        searchNames.add(vdbSearchName);
        searchNames.add(columnSearchName);
        searchNames.add(columnsWithParamSearchName);
        searchNames.add(fromParamSearchName);
        return searchNames;
    }

    protected void assertPortfolio(RestVdb vdb) {
        String expectedPath = "/tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio";
        Assert.assertEquals((Object)expectedPath, (Object)vdb.getDataPath());
        Assert.assertEquals((Object)KomodoType.VDB, (Object)vdb.getkType());
        Assert.assertTrue((boolean)vdb.hasChildren());
        Assert.assertEquals((Object)"Portfolio", (Object)vdb.getName());
        Assert.assertEquals((Object)"The Portfolio Dynamic VDB", (Object)vdb.getDescription());
        Assert.assertEquals((Object)expectedPath, (Object)vdb.getOriginalFilePath());
        Assert.assertFalse((boolean)vdb.isPreview());
        Assert.assertEquals((long)1L, (long)vdb.getVersion());
        List properties = vdb.getProperties();
        Assert.assertEquals((long)1L, (long)properties.size());
        RestProperty property = (RestProperty)properties.iterator().next();
        Assert.assertEquals((Object)"UseConnectorMetadata", (Object)property.getName());
        Assert.assertEquals((Object)"true", (Object)property.getValue());
        Collection links = vdb.getLinks();
        Assert.assertEquals((long)7L, (long)links.size());
        int linkCounter = 0;
        for (RestLink link : links) {
            String href = link.getHref().toString();
            if (link.getRel().equals((Object)RestLink.LinkType.SELF)) {
                ++linkCounter;
                Assert.assertTrue((boolean)href.startsWith(_appUri.toString() + "/workspace/vdbs"));
                Assert.assertTrue((boolean)href.endsWith("Portfolio"));
                continue;
            }
            if (link.getRel().equals((Object)RestLink.LinkType.PARENT)) {
                ++linkCounter;
                Assert.assertTrue((boolean)href.startsWith(_appUri.toString() + "/workspace/vdbs"));
                continue;
            }
            if (link.getRel().equals((Object)RestLink.LinkType.CHILDREN)) {
                ++linkCounter;
                Assert.assertTrue((boolean)href.startsWith(_appUri.toString() + "/workspace/search"));
                continue;
            }
            Assert.assertTrue((boolean)href.startsWith(_appUri.toString() + "/workspace/vdbs"));
            String suffixPrefix = "Portfolio/";
            if (link.getRel().equals((Object)RestLink.LinkType.IMPORTS)) {
                ++linkCounter;
                Assert.assertTrue((boolean)href.endsWith(suffixPrefix + RestLink.LinkType.IMPORTS.uriName()));
                continue;
            }
            if (link.getRel().equals((Object)RestLink.LinkType.MODELS)) {
                ++linkCounter;
                Assert.assertTrue((boolean)href.endsWith(suffixPrefix + RestLink.LinkType.MODELS.uriName()));
                continue;
            }
            if (link.getRel().equals((Object)RestLink.LinkType.TRANSLATORS)) {
                ++linkCounter;
                Assert.assertTrue((boolean)href.endsWith(suffixPrefix + RestLink.LinkType.TRANSLATORS.uriName()));
                continue;
            }
            if (!link.getRel().equals((Object)RestLink.LinkType.DATA_ROLES)) continue;
            ++linkCounter;
            Assert.assertTrue((boolean)href.endsWith(suffixPrefix + RestLink.LinkType.DATA_ROLES.uriName()));
        }
        Assert.assertEquals((long)7L, (long)linkCounter);
    }
}

