/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoConnectionAttributes;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.AbstractKomodoServiceTest;

public class KomodoConnectionServiceTest
extends AbstractKomodoServiceTest {
    public static String CONNECTION_NAME = "MyConnection";
    @Rule
    public TestName testName = new TestName();

    @Test
    public void shouldGetConnections() throws Exception {
        this.createConnection(CONNECTION_NAME);
        URI uri = _uriBuilder.workspaceConnectionsUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        Assert.assertThat((Object)entities, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestConnection[] connection = (RestConnection[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestConnection[].class);
        Assert.assertEquals((long)1L, (long)connection.length);
        RestConnection mySource = connection[0];
        Assert.assertNotNull((Object)mySource.getId());
        Assert.assertTrue((boolean)CONNECTION_NAME.equals(mySource.getId()));
        Assert.assertNotNull((Object)mySource.getDataPath());
        Assert.assertNotNull((Object)mySource.getkType());
    }

    @Test
    public void shouldReturnEmptyListWhenNoDataservicesInWorkspace() throws Exception {
        URI uri = _uriBuilder.workspaceDataservicesUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestConnection[] connections = (RestConnection[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestConnection[].class);
        Assert.assertNotNull((Object)connections);
        Assert.assertEquals((long)0L, (long)connections.length);
    }

    @Test
    public void shouldGetConnection() throws Exception {
        this.createConnection(CONNECTION_NAME);
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.CONNECTION_NAME, CONNECTION_NAME);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, _uriBuilder.workspaceConnectionsUri());
        URI uri = _uriBuilder.connectionUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestConnection connection = (RestConnection)KomodoJsonMarshaller.unmarshall((String)entity, RestConnection.class);
        Assert.assertNotNull((Object)connection);
        Assert.assertEquals((Object)connection.getId(), (Object)CONNECTION_NAME);
    }

    @Test
    public void shouldCreateConnection() throws Exception {
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.CONNECTION_NAME, CONNECTION_NAME);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, _uriBuilder.workspaceConnectionsUri());
        URI uri = _uriBuilder.connectionUri(RestLink.LinkType.SELF, settings);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        KomodoConnectionAttributes rcAttr = new KomodoConnectionAttributes();
        rcAttr.setJndi("jndi:/MySqlDS1");
        rcAttr.setDriver("mysql");
        rcAttr.setJdbc(true);
        rcAttr.setParameter("username", (Object)"test");
        rcAttr.setParameter("password", (Object)"myPassword");
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)rcAttr);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        System.out.println("Response:\n" + entity);
        RestConnection rsObj = (RestConnection)KomodoJsonMarshaller.unmarshall((String)entity, RestConnection.class);
        Assert.assertEquals((Object)rcAttr.getDriver(), (Object)rsObj.getDriverName());
        Assert.assertEquals((Object)rcAttr.getJndi(), (Object)rsObj.getJndiName());
        Assert.assertEquals((Object)rcAttr.isJdbc(), (Object)rsObj.isJdbc());
        List rsProps = rsObj.getProperties();
        for (Map.Entry parameter : rcAttr.getParameters().entrySet()) {
            RestProperty rsProp = null;
            for (RestProperty rsp : rsProps) {
                if (!rsp.getName().equals(parameter.getKey())) continue;
                rsProp = rsp;
            }
            Assert.assertNotNull((String)((String)parameter.getKey() + " property not handled"), (Object)rsProp);
            Assert.assertEquals(parameter.getValue(), (Object)rsProp.getValue());
        }
    }

    @Test
    public void shouldUpdateConnection() throws Exception {
        this.createConnection(CONNECTION_NAME);
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.CONNECTION_NAME, CONNECTION_NAME);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, _uriBuilder.workspaceConnectionsUri());
        URI uri = _uriBuilder.connectionUri(RestLink.LinkType.SELF, settings);
        HttpPut request = (HttpPut)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.PUT);
        KomodoConnectionAttributes rcAttr = new KomodoConnectionAttributes();
        rcAttr.setJndi("jndi:/MySqlDS1");
        rcAttr.setDriver("mysql");
        rcAttr.setJdbc(true);
        rcAttr.setParameter("username", (Object)"test");
        rcAttr.setParameter("password", (Object)"myPassword");
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)rcAttr);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        System.out.println("Response:\n" + entity);
        RestConnection rsObj = (RestConnection)KomodoJsonMarshaller.unmarshall((String)entity, RestConnection.class);
        Assert.assertEquals((Object)rcAttr.getDriver(), (Object)rsObj.getDriverName());
        Assert.assertEquals((Object)rcAttr.getJndi(), (Object)rsObj.getJndiName());
        Assert.assertEquals((Object)rcAttr.isJdbc(), (Object)rsObj.isJdbc());
        List rsProps = rsObj.getProperties();
        for (Map.Entry parameter : rcAttr.getParameters().entrySet()) {
            RestProperty rsProp = null;
            for (RestProperty rsp : rsProps) {
                if (!rsp.getName().equals(parameter.getKey())) continue;
                rsProp = rsp;
            }
            Assert.assertNotNull((String)((String)parameter.getKey() + " property not handled"), (Object)rsProp);
            Assert.assertEquals(parameter.getValue(), (Object)rsProp.getValue());
        }
    }
}

