/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.komodo.relational.ViewBuilderCriteriaPredicate;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.rest.relational.dataservice.RestDataservice;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoDataserviceUpdateAttributes;
import org.komodo.rest.relational.response.RestConnectionDriver;
import org.komodo.rest.relational.response.RestDataserviceViewInfo;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.AbstractKomodoServiceTest;

public class KomodoDataserviceServiceTest
extends AbstractKomodoServiceTest {
    public static String DATASERVICE_NAME = "MyDataService";
    @Rule
    public TestName testName = new TestName();

    @Test
    public void shouldGetDataservices() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI uri = _uriBuilder.workspaceDataservicesUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entities = this.extractResponse(response);
        Assert.assertThat((Object)entities, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataservice[] dataservices = (RestDataservice[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestDataservice[].class);
        Assert.assertEquals((long)1L, (long)dataservices.length);
        RestDataservice myService = dataservices[0];
        Assert.assertNotNull((Object)myService.getId());
        Assert.assertTrue((boolean)DATASERVICE_NAME.equals(myService.getId()));
        Assert.assertNotNull((Object)myService.getDataPath());
        Assert.assertNotNull((Object)myService.getkType());
    }

    @Test
    public void shouldReturnEmptyListWhenNoDataservicesInWorkspace() throws Exception {
        URI uri = _uriBuilder.workspaceDataservicesUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataservice[] dataservices = (RestDataservice[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestDataservice[].class);
        Assert.assertNotNull((Object)dataservices);
        Assert.assertEquals((long)0L, (long)dataservices.length);
    }

    @Test
    public void shouldGetDataservice() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, DATASERVICE_NAME);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataservice dataservice = (RestDataservice)KomodoJsonMarshaller.unmarshall((String)entity, RestDataservice.class);
        Assert.assertNotNull((Object)dataservice);
        Assert.assertEquals((Object)dataservice.getId(), (Object)DATASERVICE_NAME);
    }

    @Test
    public void shouldGetDataserviceConnections() throws Exception {
        this.loadStatesDataService();
        String dsName = "UsStatesService";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, dsName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.CONNECTIONS, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        System.out.println("Response:\n" + entity);
        RestConnection[] connections = (RestConnection[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestConnection[].class);
        Assert.assertNotNull((Object)connections);
        Assert.assertEquals((long)1L, (long)connections.length);
        RestConnection connection = connections[0];
        Assert.assertEquals((Object)"MySqlPool", (Object)connection.getId());
        Assert.assertEquals((Object)"java:/MySqlDS", (Object)connection.getJndiName());
        Assert.assertEquals((Object)"mysql-connector-java-5.1.39-bin.jar_com.mysql.jdbc.Driver_5_1", (Object)connection.getDriverName());
        Collection links = connection.getLinks();
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)3L, (long)links.size());
        for (RestLink link : links) {
            RestLink.LinkType rel = link.getRel();
            Assert.assertTrue((RestLink.LinkType.SELF.equals((Object)rel) || RestLink.LinkType.PARENT.equals((Object)rel) || RestLink.LinkType.CHILDREN.equals((Object)rel) ? 1 : 0) != 0);
            if (!RestLink.LinkType.SELF.equals((Object)rel)) continue;
            String href = _uriBuilder.workspaceConnectionsUri() + "/" + connection.getId();
            Assert.assertEquals((Object)href, (Object)link.getHref().toString());
        }
    }

    @Test
    public void shouldGetDataserviceDrivers() throws Exception {
        this.loadStatesDataService();
        String dsName = "UsStatesService";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, dsName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.DRIVERS, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        System.out.println("Response:\n" + entity);
        RestConnectionDriver[] drivers = (RestConnectionDriver[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestConnectionDriver[].class);
        Assert.assertNotNull((Object)drivers);
        Assert.assertEquals((long)1L, (long)drivers.length);
        RestConnectionDriver connectionDriver = drivers[0];
        Assert.assertEquals((Object)"mysql-connector-java-5.1.39-bin.jar", (Object)connectionDriver.getName());
    }

    @Test
    public void shouldGetViewInfoForSingleSourceDataService() throws Exception {
        this.loadDsbSingleSourceDataService();
        String dsName = "PartsSingleSource";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, dsName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.SERVICE_VIEW_INFO, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataserviceViewInfo[] viewInfos = (RestDataserviceViewInfo[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestDataserviceViewInfo[].class);
        Assert.assertEquals((long)2L, (long)viewInfos.length);
        for (int i = 0; i < viewInfos.length; ++i) {
            String infoType = viewInfos[i].getInfoType();
            if (infoType.equals("LHTABLE")) {
                Assert.assertEquals((Object)"OracleParts", (Object)viewInfos[i].getSourceVdbName());
                Assert.assertEquals((Object)"SUPPLIER", (Object)viewInfos[i].getTableName());
                List<String> colList = Arrays.asList(viewInfos[i].getColumnNames());
                Assert.assertTrue((boolean)colList.contains("SUPPLIER_ID"));
                Assert.assertTrue((boolean)colList.contains("SUPPLIER_NAME"));
                Assert.assertTrue((boolean)colList.contains("SUPPLIER_STATUS"));
                Assert.assertTrue((boolean)colList.contains("SUPPLIER_CITY"));
                Assert.assertTrue((boolean)colList.contains("SUPPLIER_STATE"));
                continue;
            }
            if (!infoType.equals("DDL")) continue;
            Assert.assertEquals((Object)true, (Object)viewInfos[i].isViewEditable());
            Assert.assertEquals((Object)"CREATE VIEW PartsSingleSourceView (\n\tSUPPLIER_ID string,\n\tSUPPLIER_NAME string,\n\tSUPPLIER_STATUS bigdecimal,\n\tSUPPLIER_CITY string,\n\tSUPPLIER_STATE string,\n\tPRIMARY KEY(SUPPLIER_ID)\n)\nAS\nSELECT SUPPLIER_ID, SUPPLIER_NAME, SUPPLIER_STATUS, SUPPLIER_CITY, SUPPLIER_STATE FROM OracleParts.SUPPLIER;\n", (Object)viewInfos[i].getViewDdl());
        }
    }

    @Test
    public void shouldGetViewInfoForJoinSameTableNamesDataService() throws Exception {
        this.loadDsbJoinSameTableNamesDataService();
        String dsName = "JoinServiceSameTableNames";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, dsName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.SERVICE_VIEW_INFO, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataserviceViewInfo[] viewInfos = (RestDataserviceViewInfo[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestDataserviceViewInfo[].class);
        Assert.assertEquals((long)4L, (long)viewInfos.length);
        for (int i = 0; i < viewInfos.length; ++i) {
            List<String> colList;
            String infoType = viewInfos[i].getInfoType();
            if (infoType.equals("LHTABLE")) {
                Assert.assertEquals((Object)"BQTOracle", (Object)viewInfos[i].getSourceVdbName());
                Assert.assertEquals((Object)"SMALLA", (Object)viewInfos[i].getTableName());
                colList = Arrays.asList(viewInfos[i].getColumnNames());
                Assert.assertTrue((boolean)colList.contains("INTKEY"));
                Assert.assertTrue((boolean)colList.contains("STRINGKEY"));
                continue;
            }
            if (infoType.equals("RHTABLE")) {
                Assert.assertEquals((Object)"BQTOracle2", (Object)viewInfos[i].getSourceVdbName());
                Assert.assertEquals((Object)"SMALLA", (Object)viewInfos[i].getTableName());
                colList = Arrays.asList(viewInfos[i].getColumnNames());
                Assert.assertTrue((boolean)colList.contains("STRINGKEY"));
                Assert.assertTrue((boolean)colList.contains("INTNUM"));
                continue;
            }
            if (infoType.equals("CRITERIA")) {
                Assert.assertEquals((Object)"INNER", (Object)viewInfos[i].getJoinType());
                colList = viewInfos[i].getCriteriaPredicates();
                Assert.assertEquals((long)1L, (long)colList.size());
                ViewBuilderCriteriaPredicate predicate = (ViewBuilderCriteriaPredicate)colList.get(0);
                Assert.assertEquals((Object)"INTKEY", (Object)predicate.getLhColumn());
                Assert.assertEquals((Object)"INTKEY", (Object)predicate.getRhColumn());
                Assert.assertEquals((Object)"=", (Object)predicate.getOperator());
                continue;
            }
            if (!infoType.equals("DDL")) continue;
            Assert.assertEquals((Object)true, (Object)viewInfos[i].isViewEditable());
            Assert.assertEquals((Object)"CREATE VIEW JoinServiceSameTableNamesView (\n\tRowId integer,\n\tINTKEY bigdecimal,\n\tA_STRINGKEY string,\n\tB_STRINGKEY string,\n\tINTNUM bigdecimal,\n\tPRIMARY KEY(RowId)\n)\nAS\nSELECT ROW_NUMBER() OVER (ORDER BY A.INTKEY), A.INTKEY, A.STRINGKEY, B.STRINGKEY, B.INTNUM FROM BQTOracle.SMALLA AS A INNER JOIN BQTOracle2.SMALLA AS B ON A.INTKEY = B.INTKEY;\n", (Object)viewInfos[i].getViewDdl());
        }
    }

    @Test
    public void shouldGetViewInfoForJoinDifferentTableNamesDataService() throws Exception {
        this.loadDsbJoinDifferentTableNamesDataService();
        String dsName = "JoinServiceDifferentTableNames";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, dsName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.SERVICE_VIEW_INFO, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataserviceViewInfo[] viewInfos = (RestDataserviceViewInfo[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestDataserviceViewInfo[].class);
        Assert.assertEquals((long)4L, (long)viewInfos.length);
        for (int i = 0; i < viewInfos.length; ++i) {
            List<String> colList;
            String infoType = viewInfos[i].getInfoType();
            if (infoType.equals("LHTABLE")) {
                Assert.assertEquals((Object)"BQTOracle", (Object)viewInfos[i].getSourceVdbName());
                Assert.assertEquals((Object)"SMALLA", (Object)viewInfos[i].getTableName());
                colList = Arrays.asList(viewInfos[i].getColumnNames());
                Assert.assertTrue((boolean)colList.contains("INTKEY"));
                Assert.assertTrue((boolean)colList.contains("STRINGKEY"));
                continue;
            }
            if (infoType.equals("RHTABLE")) {
                Assert.assertEquals((Object)"BQTOracle2", (Object)viewInfos[i].getSourceVdbName());
                Assert.assertEquals((Object)"SMALLB", (Object)viewInfos[i].getTableName());
                colList = Arrays.asList(viewInfos[i].getColumnNames());
                Assert.assertTrue((boolean)colList.contains("STRINGKEY"));
                Assert.assertTrue((boolean)colList.contains("INTNUM"));
                continue;
            }
            if (infoType.equals("CRITERIA")) {
                Assert.assertEquals((Object)"INNER", (Object)viewInfos[i].getJoinType());
                colList = viewInfos[i].getCriteriaPredicates();
                Assert.assertEquals((long)1L, (long)colList.size());
                ViewBuilderCriteriaPredicate predicate = (ViewBuilderCriteriaPredicate)colList.get(0);
                Assert.assertEquals((Object)"INTKEY", (Object)predicate.getLhColumn());
                Assert.assertEquals((Object)"INTKEY", (Object)predicate.getRhColumn());
                Assert.assertEquals((Object)"=", (Object)predicate.getOperator());
                continue;
            }
            if (!infoType.equals("DDL")) continue;
            Assert.assertEquals((Object)true, (Object)viewInfos[i].isViewEditable());
            Assert.assertEquals((Object)"CREATE VIEW JoinServiceDifferentTableNamesView (\n\tRowId integer,\n\tINTKEY bigdecimal,\n\tA_STRINGKEY string,\n\tB_STRINGKEY string,\n\tINTNUM bigdecimal,\n\tPRIMARY KEY(RowId)\n)\nAS\nSELECT ROW_NUMBER() OVER (ORDER BY A.INTKEY), A.INTKEY, A.STRINGKEY, B.STRINGKEY, B.INTNUM FROM BQTOracle.SMALLA AS A INNER JOIN BQTOracle2.SMALLB AS B ON A.INTKEY = B.INTKEY;\n", (Object)viewInfos[i].getViewDdl());
        }
    }

    @Test
    public void shouldGetWorkspaceSourceVdbForDataService() throws Exception {
        this.loadServiceSourceVdb();
        this.loadStatesDataService();
        String dsName = "UsStatesService";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, dsName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.SOURCE_VDB_MATCHES, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestVdb[] vdbs = (RestVdb[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdb[].class);
        Assert.assertNotNull((Object)vdbs);
        Assert.assertEquals((long)1L, (long)vdbs.length);
        RestVdb vdb = vdbs[0];
        Assert.assertEquals((Object)"ServiceSource", (Object)vdb.getId());
    }

    @Test
    public void shouldNotGetWorkspaceSourceVdbForDataService() throws Exception {
        this.loadStatesDataService();
        String dsName = "UsStatesService";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, dsName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, _uriBuilder.workspaceDataservicesUri());
        URI uri = _uriBuilder.dataserviceUri(RestLink.LinkType.SOURCE_VDB_MATCHES, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestVdb[] vdbs = (RestVdb[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdb[].class);
        Assert.assertNotNull((Object)vdbs);
        Assert.assertEquals((long)0L, (long)vdbs.length);
    }

    @Test
    public void shouldNotSetServiceVdbForSingleTableMissingParameter() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceVdbForSingleTable").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("/path/to/table");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("missing one or more required parameters"));
    }

    @Test
    public void shouldNotSetServiceVdbForSingleTableBadTablePath() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceVdbForSingleTable").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("/path/to/table");
        updateAttr.setModelSourcePath("/path/to/ModelSource");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("specified Table does not exist"));
    }

    @Test
    public void shouldNotSetServiceVdbForSingleTableBadDdl() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceVdbForSingleTable").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/PersonalValuations/Sheet1");
        updateAttr.setModelSourcePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/Accounts/vdb:sources/h2-connector");
        updateAttr.setViewDdl("CREATE VIEW blah blah");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 500);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("DDL Parsing encountered a problem"));
    }

    @Test
    public void shouldSetServiceVdbForSingleTable() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceVdbForSingleTable").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/PersonalValuations/Sheet1");
        updateAttr.setModelSourcePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/Accounts/vdb:sources/h2-connector");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("Successfully updated"));
    }

    @Test
    public void shouldNotSetServiceVdbForJoinTablesMissingParameter() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceVdbForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("/path/to/lhTable");
        updateAttr.setRhTablePath("/path/to/rhTable");
        updateAttr.setModelSourcePath("/path/to/lhModelSource");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("missing one or more required parameters"));
    }

    @Test
    public void shouldNotSetServiceVdbForJoinTablesBadTablePath() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceVdbForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("/path/to/lhTable");
        updateAttr.setRhTablePath("/path/to/rhTable");
        updateAttr.setModelSourcePath("/path/to/lhModelSource");
        updateAttr.setRhModelSourcePath("/path/to/rhModelSource");
        updateAttr.setViewDdl("CREATE VIEW blah blah");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("specified Table does not exist"));
    }

    @Test
    public void shouldNotSetServiceVdbForJoinTablesBadDdl() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceVdbForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/PersonalValuations/Sheet1");
        updateAttr.setRhTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/PersonalValuations/Sheet1");
        updateAttr.setModelSourcePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/Accounts/vdb:sources/h2-connector");
        updateAttr.setRhModelSourcePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/Accounts/vdb:sources/h2-connector");
        updateAttr.setViewDdl("CREATE VIEW blah blah");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 500);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("DDL Parsing encountered a problem"));
    }

    @Test
    public void shouldNotGenerateViewDdlForSingleTableMissingParameter() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceViewDdlForSingleTable").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("missing one or more required parameters"));
    }

    @Test
    public void shouldNotGenerateViewDdlForSingleTableBadTablePath() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceViewDdlForSingleTable").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("/path/to/table");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("specified Table does not exist"));
    }

    @Test
    public void shouldGenerateViewDdlForSingleTable() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceViewDdlForSingleTable").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/PersonalValuations/Sheet1");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestDataserviceViewInfo viewInfo = (RestDataserviceViewInfo)KomodoJsonMarshaller.unmarshall((String)entity, RestDataserviceViewInfo.class);
        Assert.assertEquals((Object)"DDL", (Object)viewInfo.getInfoType());
        Assert.assertEquals((Object)"CREATE VIEW MyDataServiceView ( ROW_ID INTEGER, ACCOUNT_ID INTEGER, PRODUCT_TYPE STRING, PRODUCT_VALUE STRING, CONSTRAINT PK0 PRIMARY KEY (ROW_ID)) AS \nSELECT  ROW_ID, ACCOUNT_ID, PRODUCT_TYPE, PRODUCT_VALUE \nFROM Portfolio.Sheet1;", (Object)viewInfo.getViewDdl());
        Assert.assertEquals((Object)false, (Object)viewInfo.isViewEditable());
    }

    @Test
    public void shouldNotGenerateViewDdlForJoinTablesMissingParameter() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceViewDdlForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("/path/to/lhTable");
        updateAttr.setRhTablePath("/path/to/rhTable");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("missing one or more required parameters"));
    }

    @Test
    public void shouldNotGenerateViewDdlForJoinTablesBadTablePath() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceViewDdlForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("/path/to/lhTable");
        updateAttr.setRhTablePath("/path/to/rhTable");
        updateAttr.setJoinType("INNER");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("specified Table does not exist"));
    }

    @Test
    public void shouldGenerateViewDdlForJoinTables() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("ServiceViewDdlForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setDataserviceName(DATASERVICE_NAME);
        updateAttr.setTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/PersonalValuations/Sheet1");
        updateAttr.setRhTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio/PersonalValuations/Sheet1");
        updateAttr.setJoinType("INNER");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestDataserviceViewInfo viewInfo = (RestDataserviceViewInfo)KomodoJsonMarshaller.unmarshall((String)entity, RestDataserviceViewInfo.class);
        Assert.assertEquals((Object)"DDL", (Object)viewInfo.getInfoType());
        Assert.assertEquals((Object)"CREATE VIEW MyDataServiceView (RowId integer PRIMARY KEY,  A_ROW_ID INTEGER, A_ACCOUNT_ID INTEGER, A_PRODUCT_TYPE STRING, A_PRODUCT_VALUE STRING,  B_ROW_ID INTEGER, B_ACCOUNT_ID INTEGER, B_PRODUCT_TYPE STRING, B_PRODUCT_VALUE STRING) AS \nSELECT ROW_NUMBER() OVER (ORDER BY A.ROW_ID), A.ROW_ID, A.ACCOUNT_ID, A.PRODUCT_TYPE, A.PRODUCT_VALUE, B.ROW_ID, B.ACCOUNT_ID, B.PRODUCT_TYPE, B.PRODUCT_VALUE \nFROM \nPortfolio.Sheet1 AS A \nINNER JOIN \nPortfolio.Sheet1 AS B ;", (Object)viewInfo.getViewDdl());
        Assert.assertEquals((Object)false, (Object)viewInfo.isViewEditable());
    }

    @Test
    public void shouldFailNameValidationWhenNameAlreadyExists() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path(DATASERVICE_NAME).build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldFailNameValidationWhenVdbWithSameNameExists() throws Exception {
        this.createVdb(DATASERVICE_NAME);
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path(DATASERVICE_NAME).build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)errorMsg.isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldFailNameValidationWhenNameHasInvalidCharacters() throws Exception {
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path("InvalidN@me").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)errorMsg.isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldFailNameValidationWhenNameIsEmpty() throws Exception {
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path("").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.execute((HttpUriRequest)request);
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)500));
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)StringStartsWith.startsWith((String)"RESTEASY"));
    }

    @Test
    public void shouldFailNameValidationWhenNameHasSpaces() throws Exception {
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path("a b c").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)errorMsg.isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldFailNameValidationWhenNameHasBackslash() throws Exception {
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path("\\").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)errorMsg.isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldFailNameValidationWhenNameHasSpecialChars() throws Exception {
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path("a#").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)errorMsg.isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldFailNameValidationWhenMissingNameSegment() throws Exception {
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.execute((HttpUriRequest)request);
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)500));
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)StringStartsWith.startsWith((String)"RESTEASY"));
    }

    @Test
    public void shouldValidateName() throws Exception {
        URI dsUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dsUri).path("nameValidation").path("ValidName").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldNotGenerateJoinCriteriaMissingParameter() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("CriteriaForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setTablePath("/path/to/lhTable");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("missing one or more required parameters"));
    }

    @Test
    public void shouldNotGenerateJoinCriteriaBadTablePath() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("CriteriaForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setTablePath("/path/to/lhTable");
        updateAttr.setRhTablePath("/path/to/rhTable");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("specified Table does not exist"));
    }

    @Test
    public void shouldGenerateJoinCriteriaEmpty() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("CriteriaForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/MyPartsVDB_Dynamic/PartsSS/PARTS");
        updateAttr.setRhTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/MyPartsVDB_Dynamic/PartsSS/STATUS");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataserviceViewInfo viewInfo = (RestDataserviceViewInfo)KomodoJsonMarshaller.unmarshall((String)entity, RestDataserviceViewInfo.class);
        Assert.assertTrue((boolean)"CRITERIA".equals(viewInfo.getInfoType()));
        Assert.assertEquals((long)viewInfo.getCriteriaPredicates().size(), (long)0L);
    }

    @Test
    public void shouldGenerateJoinCriteria() throws Exception {
        this.loadVdbs();
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("CriteriaForJoinTables").build(new Object[0]);
        KomodoDataserviceUpdateAttributes updateAttr = new KomodoDataserviceUpdateAttributes();
        updateAttr.setTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/MyPartsVDB_Dynamic/PartsSS/PARTS");
        updateAttr.setRhTablePath("tko:komodo/tko:workspace/" + USER_NAME + "/MyPartsVDB_Dynamic/PartsSS/SUPPLIER_PARTS");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)updateAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataserviceViewInfo viewInfo = (RestDataserviceViewInfo)KomodoJsonMarshaller.unmarshall((String)entity, RestDataserviceViewInfo.class);
        Assert.assertTrue((boolean)"CRITERIA".equals(viewInfo.getInfoType()));
        Assert.assertEquals((long)1L, (long)viewInfo.getCriteriaPredicates().size());
        Assert.assertEquals((Object)"PART_ID", (Object)((ViewBuilderCriteriaPredicate)viewInfo.getCriteriaPredicates().get(0)).getLhColumn());
        Assert.assertEquals((Object)"PART_ID", (Object)((ViewBuilderCriteriaPredicate)viewInfo.getCriteriaPredicates().get(0)).getRhColumn());
        Assert.assertEquals((Object)"=", (Object)((ViewBuilderCriteriaPredicate)viewInfo.getCriteriaPredicates().get(0)).getOperator());
    }

    @Test
    public void shouldCloneDataservice() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("clone").path(DATASERVICE_NAME).build(new Object[0]);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, "newDataservice");
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestDataservice dataservice = (RestDataservice)KomodoJsonMarshaller.unmarshall((String)entity, RestDataservice.class);
        Assert.assertNotNull((Object)dataservice);
        Assert.assertEquals((Object)dataservice.getId(), (Object)"newDataservice");
    }

    @Test
    public void shouldNotCloneDataservice() throws Exception {
        this.createDataservice(DATASERVICE_NAME);
        URI dataservicesUri = _uriBuilder.workspaceDataservicesUri();
        URI uri = UriBuilder.fromUri((URI)dataservicesUri).path("clone").path(DATASERVICE_NAME).build(new Object[0]);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, DATASERVICE_NAME);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("cannot be the same"));
    }
}

