/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestConnectionDriver;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.AbstractKomodoServiceTest;

public class KomodoDriverServiceTest
extends AbstractKomodoServiceTest {
    public static String DRIVER_NAME = "MyDriver";
    @Rule
    public TestName testName = new TestName();

    @Test
    @Ignore
    public void shouldGetDrivers() throws Exception {
        this.createDriver(DRIVER_NAME);
        URI uri = _uriBuilder.workspaceDriversUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        Assert.assertNotNull((Object)entities);
        Assert.assertThat((Object)entities, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestConnectionDriver[] driver = (RestConnectionDriver[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestConnectionDriver[].class);
        Assert.assertEquals((long)1L, (long)driver.length);
        RestConnectionDriver myDriver = driver[0];
        Assert.assertTrue((boolean)DRIVER_NAME.equals(myDriver.getName()));
    }

    @Test
    public void shouldReturnEmptyListWhenNoDriversInWorkspace() throws Exception {
        URI uri = _uriBuilder.workspaceDriversUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestConnectionDriver[] drivers = (RestConnectionDriver[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestConnectionDriver[].class);
        Assert.assertNotNull((Object)drivers);
        Assert.assertEquals((long)0L, (long)drivers.length);
    }
}

