/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.ImportExportStatus;
import org.komodo.rest.relational.response.KomodoStorageAttributes;
import org.komodo.rest.relational.response.RestStorageType;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.AbstractKomodoServiceTest;
import org.komodo.spi.repository.DocumentType;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.test.utils.TestUtilities;
import org.komodo.utils.FileUtils;
import org.komodo.utils.StringUtils;

public class KomodoImportExportServiceTest
extends AbstractKomodoServiceTest {
    private File myGitDir;
    private Git myGit;
    private File gitRepoDest;

    private void initGitRepository() throws Exception {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirPath);
        long timestamp = System.currentTimeMillis();
        this.myGitDir = new File(tmpDir, "mygit-" + timestamp);
        Assert.assertTrue((boolean)this.myGitDir.mkdir());
        this.myGit = Git.init().setDirectory(this.myGitDir).setBare(true).call();
        Assert.assertNotNull((Object)this.myGit);
        File seedDir = new File(tmpDir, "seedDir-" + timestamp);
        Git seedGit = Git.cloneRepository().setURI(this.myGitDir.getAbsolutePath()).setDirectory(seedDir).call();
        File tweetVdbFile = new File(seedDir, "tweet-example-vdb.xml");
        Assert.assertTrue((boolean)tweetVdbFile.createNewFile());
        FileUtils.write((InputStream)TestUtilities.tweetExample(), (File)tweetVdbFile);
        Assert.assertTrue((tweetVdbFile.length() > 0L ? 1 : 0) != 0);
        File usStatesZipFile = new File(tmpDir, "UsStatesService.zip");
        FileUtils.write((InputStream)TestUtilities.usStatesDataserviceExample(), (File)usStatesZipFile);
        try (FileInputStream fis = new FileInputStream(usStatesZipFile);){
            File usStatesDir = new File(seedDir, "UsStatesService");
            usStatesDir.mkdir();
            FileUtils.zipExtract((InputStream)fis, (File)usStatesDir);
            usStatesZipFile.delete();
        }
        seedGit.add().addFilepattern(".").call();
        seedGit.commit().setMessage("First Commit").call();
        seedGit.push().call();
        FileUtils.removeDirectoryAndChildren((File)seedDir);
        String dirName = System.currentTimeMillis() + "-";
        this.gitRepoDest = new File(FileUtils.tempDirectory(), dirName);
        this.gitRepoDest.mkdir();
    }

    private void destroyGitRepository() throws Exception {
        if (this.gitRepoDest != null) {
            FileUtils.removeDirectoryAndChildren((File)this.gitRepoDest);
        }
        if (this.myGit != null) {
            this.myGit.close();
        }
        if (this.myGitDir != null) {
            FileUtils.removeDirectoryAndChildren((File)this.myGitDir);
        }
    }

    @Before
    public void setup() throws Exception {
        this.initGitRepository();
    }

    @After
    public void tearDown() throws Exception {
        this.destroyGitRepository();
    }

    @Test
    public void shouldNotImportVdbBlankPayload() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("The storage type requested from the import export service is unsupported"));
    }

    @Test
    public void shouldImportVdb() throws Exception {
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "importVdb" + ":" + System.currentTimeMillis(), false, null);
        KomodoObject workspace = repository.komodoWorkspace(uow);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setDocumentType(DocumentType.VDB_XML);
        String portfolioCnt = FileUtils.streamToString((InputStream)TestUtilities.portfolioExample());
        String content = Base64.getEncoder().encodeToString(portfolioCnt.getBytes());
        storageAttr.setContent(content);
        Assert.assertFalse((boolean)workspace.hasChild(uow, "Portfolio"));
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        this.okResponse(response);
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertFalse((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"-vdb.xml", (Object)status.getType());
        Assert.assertTrue((boolean)workspace.hasChild(uow, "Portfolio"));
    }

    @Test
    public void shouldNotExportVdbInvalidArtifactPath() throws Exception {
        this.loadVdbs();
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("export").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        String artifactPath = "/export/blah";
        storageAttr.setArtifactPath(artifactPath);
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        storageAttr.setParameter("files-home-path-property", tmpDirPath);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("No artifact could be found to export at path"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExportVdb() throws Exception {
        this.loadVdbs();
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("export").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setArtifactPath("/tko:komodo/tko:workspace/" + USER_NAME + "/myVDB");
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        storageAttr.setParameter("files-home-path-property", tmpDirPath);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        File tmpFile = new File(tmpDirPath, "myVDB-vdb.xml");
        Assert.assertTrue((boolean)tmpFile.exists());
        tmpFile.deleteOnExit();
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertTrue((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"-vdb.xml", (Object)status.getType());
        String content = status.getContent();
        Assert.assertNotNull((Object)content);
        byte[] decBytes = Base64.getDecoder().decode(content);
        String decContent = new String(decBytes) + "\n";
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(tmpFile);
            String tmpFileContent = FileUtils.streamToString((InputStream)stream) + "\n";
            Assert.assertEquals((Object)tmpFileContent, (Object)decContent);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    @Test
    public void shouldImportDataservice() throws Exception {
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "importDataservice" + ":" + System.currentTimeMillis(), false, null);
        KomodoObject workspace = repository.komodoWorkspace(uow);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setDocumentType(DocumentType.ZIP);
        String dsName = "MyDataService";
        InputStream sampleDsStream = TestUtilities.sampleDataserviceExample();
        byte[] sampleBytes = TestUtilities.streamToBytes((InputStream)sampleDsStream);
        String content = Base64.getEncoder().encodeToString(sampleBytes);
        storageAttr.setContent(content);
        Assert.assertFalse((boolean)workspace.hasChild(uow, dsName));
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        System.out.println(entity);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertFalse((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"zip", (Object)status.getType());
        Assert.assertTrue((boolean)workspace.hasChild(uow, dsName));
        KomodoObject dataservice = workspace.getChild(uow, dsName);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        Dataservice ds = (Dataservice)mgr.resolve(uow, (Object)dataservice, Dataservice.class);
        Assert.assertNotNull((Object)ds);
        Vdb[] vdbs = ds.getVdbs(uow, new String[]{StringUtils.toCamelCase((String)"portfolio-vdb.xml")});
        Assert.assertTrue((vdbs.length == 1 ? 1 : 0) != 0);
        String vdbName = ds.getServiceVdb(uow).getVdbName(uow);
        Assert.assertEquals((Object)"DynamicProducts", (Object)vdbName);
    }

    @Test
    public void shouldImportUSDataservice() throws Exception {
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "importDataservice" + ":" + System.currentTimeMillis(), false, null);
        KomodoObject workspace = repository.komodoWorkspace(uow);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setDocumentType(DocumentType.ZIP);
        String dsName = "UsStatesService";
        InputStream usDsStream = TestUtilities.usStatesDataserviceExample();
        byte[] usBytes = TestUtilities.streamToBytes((InputStream)usDsStream);
        String content = Base64.getEncoder().encodeToString(usBytes);
        storageAttr.setContent(content);
        Assert.assertFalse((boolean)workspace.hasChild(uow, dsName));
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        System.out.println(entity);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertFalse((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"zip", (Object)status.getType());
        Assert.assertTrue((boolean)workspace.hasChild(uow, dsName));
        KomodoObject dataservice = workspace.getChild(uow, dsName);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        Dataservice ds = (Dataservice)mgr.resolve(uow, (Object)dataservice, Dataservice.class);
        Assert.assertNotNull((Object)ds);
        Vdb vdb = ds.getServiceVdb(uow);
        Assert.assertNotNull((Object)vdb);
        String vdbName = vdb.getVdbName(uow);
        Assert.assertEquals((Object)"usstates", (Object)vdbName);
    }

    @Test
    public void shouldImportUSDataserviceFromGit() throws Exception {
        String dsName = "UsStatesService";
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "importDataservice" + ":" + System.currentTimeMillis(), false, null);
        KomodoObject workspace = repository.komodoWorkspace(uow);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("git");
        storageAttr.setDocumentType(DocumentType.ZIP);
        storageAttr.setParameter("repo-path-property", "file://" + this.myGitDir);
        storageAttr.setParameter("file-path-property", dsName);
        storageAttr.setParameter("author-name-property", "user");
        storageAttr.setParameter("author-email-property", "user@user.com");
        Assert.assertFalse((boolean)workspace.hasChild(uow, dsName));
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        System.out.println(entity);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertFalse((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"zip", (Object)status.getType());
        Assert.assertTrue((boolean)workspace.hasChild(uow, dsName));
        KomodoObject dataservice = workspace.getChild(uow, dsName);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        Dataservice ds = (Dataservice)mgr.resolve(uow, (Object)dataservice, Dataservice.class);
        Assert.assertNotNull((Object)ds);
        Vdb vdb = ds.getServiceVdb(uow);
        Assert.assertNotNull((Object)vdb);
        String vdbName = vdb.getVdbName(uow);
        Assert.assertEquals((Object)"usstates", (Object)vdbName);
    }

    @Test
    public void shouldExportDataserviceToFile() throws Exception {
        this.loadVdbs();
        String dsName = "MyDataService";
        this.getRestApp().createDataservice(dsName, true, USER_NAME);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("export").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setArtifactPath("/tko:komodo/tko:workspace/" + USER_NAME + "/" + dsName);
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        storageAttr.setParameter("files-home-path-property", tmpDirPath);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        File tmpFile = new File(tmpDirPath, dsName + ".zip");
        Assert.assertTrue((boolean)tmpFile.exists());
        tmpFile.deleteOnExit();
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertTrue((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"zip", (Object)status.getType());
        String content = status.getContent();
        Assert.assertNotNull((Object)content);
        byte[] decBytes = Base64.getDecoder().decode(content);
        File dsZip = File.createTempFile("DSZip", ".zip");
        dsZip.deleteOnExit();
        FileUtils.write((byte[])decBytes, (File)dsZip);
        TestUtilities.testZipFile((File)dsZip);
    }

    @Test
    public void shouldExportDataserviceToGit() throws Exception {
        this.loadStatesDataService();
        String dsName = "UsStatesService";
        List zipEntries = TestUtilities.zipEntries((String)dsName, (InputStream)TestUtilities.usStatesDataserviceExample());
        System.out.println(zipEntries);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("export").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("git");
        storageAttr.setArtifactPath("/tko:komodo/tko:workspace/" + USER_NAME + "/" + dsName);
        storageAttr.setParameter("repo-path-property", "file://" + this.myGitDir);
        storageAttr.setParameter("repo-dest-property", this.gitRepoDest.getAbsolutePath());
        storageAttr.setParameter("author-name-property", "user");
        storageAttr.setParameter("author-email-property", "user@user.com");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        System.out.println(entity);
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertFalse((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"zip", (Object)status.getType());
        org.eclipse.jgit.lib.Repository repository = this.myGit.getRepository();
        ObjectId commitId = repository.resolve("HEAD");
        try (RevWalk revWalk = new RevWalk(repository);){
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
            RevTree tree = commit.getTree();
            try (TreeWalk treeWalk = new TreeWalk(repository);){
                treeWalk.addTree((AnyObjectId)tree);
                treeWalk.setRecursive(false);
                while (treeWalk.next()) {
                    zipEntries.remove(treeWalk.getPathString());
                    if (!treeWalk.isSubtree()) continue;
                    treeWalk.enterSubtree();
                }
            }
            Assert.assertTrue((String)("Remaining entries: " + Arrays.toString(zipEntries.toArray(new String[0]))), (boolean)zipEntries.isEmpty());
        }
    }

    @Test
    public void shouldGetStorageTypes() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("availableStorageTypes").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        System.out.println(entity);
        RestStorageType[] entities = (RestStorageType[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestStorageType[].class);
        Assert.assertNotNull((Object)entities);
        Assert.assertEquals((long)2L, (long)entities.length);
        for (RestStorageType type : entities) {
            List descriptors = type.getDescriptors();
            Assert.assertNotNull((Object)descriptors);
            Assert.assertTrue((descriptors.size() > 0 ? 1 : 0) != 0);
            String name = type.getName();
            Assert.assertTrue((name.equals("file") || name.equals("git") ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldImportDdl() throws Exception {
        String VDB_NAME = "testVDB";
        String MODEL_NAME = "testModel";
        this.createVdbModel(VDB_NAME, MODEL_NAME);
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "importVdb" + ":" + System.currentTimeMillis(), false, null);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        KomodoObject kObj = mgr.getChild(uow, VDB_NAME, "vdb:virtualDatabase");
        Vdb testVdb = (Vdb)Vdb.RESOLVER.resolve(uow, kObj);
        Model[] models = testVdb.getModels(uow, new String[]{MODEL_NAME});
        Model testModel = models[0];
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setDocumentType(DocumentType.DDL);
        String modelPath = testModel.getAbsolutePath();
        storageAttr.setArtifactPath(modelPath);
        String patientsDdlCnt = FileUtils.streamToString((InputStream)TestUtilities.patientsDdl());
        String content = Base64.getEncoder().encodeToString(patientsDdlCnt.getBytes());
        storageAttr.setContent(content);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertFalse((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"ddl", (Object)status.getType());
        Assert.assertTrue((boolean)testModel.hasChild(uow, "vdbwebtest.ER_VISIT"));
    }
}

