/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.rest.relational.RestEntityFactory;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoSearcherAttributes;
import org.komodo.rest.relational.response.KomodoSavedSearcher;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.rest.relational.response.RestVdbModel;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.AbstractKomodoServiceTest;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;

public class KomodoSearchServiceTest
extends AbstractKomodoServiceTest {
    private static String PORTFOLIO_DATA_PATH = "/tko:komodo/tko:workspace/" + USER_NAME + "/Portfolio";

    @Test
    public void shouldFailNoParameters() throws Exception {
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        System.out.println("Response:\n" + entity);
        JsonElement jelement = new JsonParser().parse(entity);
        Assert.assertNotNull((Object)jelement);
        JsonObject jobject = jelement.getAsJsonObject();
        Assert.assertEquals((Object)"\"The search service requires at least one parameter\"", (Object)jobject.get("error").toString());
    }

    @Test
    public void shouldSearchForAnythingContainingView() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("contains", (Object)"view");
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)19L, (long)entities.length);
        for (RestBasicEntity e : entities) {
            Assert.assertNotNull((Object)e.getId());
            Assert.assertNotNull((Object)e.getBaseUri());
            Assert.assertNotNull((Object)e.getDataPath());
            Assert.assertNotNull((Object)e.getkType());
            Assert.assertNotNull((Object)e.hasChildren());
            Assert.assertNotEquals((Object)KomodoType.UNKNOWN, (Object)e.getkType());
        }
    }

    @Test
    public void shouldSearchForAnyModelContainingView() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("type", (Object)"vdb:declarativeModel");
        properties.addProperty("contains", (Object)"view");
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)5L, (long)entities.length);
        for (RestBasicEntity e : entities) {
            Assert.assertNotNull((Object)e.getId());
            Assert.assertNotNull((Object)e.getBaseUri());
            Assert.assertNotNull((Object)e.getDataPath());
            Assert.assertNotNull((Object)e.getkType());
            Assert.assertNotNull((Object)e.hasChildren());
            Assert.assertEquals((Object)KomodoType.MODEL, (Object)e.getkType());
        }
    }

    @Test
    public void shouldSearchForAnyModelUnderPortfolioContainingView() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("type", (Object)"vdb:declarativeModel");
        properties.addProperty("parent", (Object)PORTFOLIO_DATA_PATH);
        properties.addProperty("contains", (Object)"view");
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)2L, (long)entities.length);
        for (RestBasicEntity e : entities) {
            Assert.assertNotNull((Object)e.getId());
            Assert.assertNotNull((Object)e.getBaseUri());
            Assert.assertNotNull((Object)e.getDataPath());
            Assert.assertNotNull((Object)e.getkType());
            Assert.assertNotNull((Object)e.hasChildren());
            Assert.assertEquals((Object)KomodoType.MODEL, (Object)e.getkType());
            Assert.assertTrue((boolean)e.getDataPath().startsWith(PORTFOLIO_DATA_PATH));
        }
    }

    @Test
    public void shouldSearchByPath() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("path", (Object)PORTFOLIO_DATA_PATH);
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)1L, (long)entities.length);
        RestBasicEntity basicEntity = entities[0];
        RestVdb vdb = (RestVdb)RestEntityFactory.resolve((RestBasicEntity)basicEntity, RestVdb.class);
        Assert.assertNotNull((Object)vdb);
        this.assertPortfolio(vdb);
    }

    @Test
    public void shouldSearchByParent() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("parent", (Object)PORTFOLIO_DATA_PATH);
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)5L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            RestVdbModel model = (RestVdbModel)RestEntityFactory.resolve((RestBasicEntity)basicEntity, RestVdbModel.class);
            Assert.assertNotNull((Object)model);
        }
    }

    @Test
    public void shouldSearchByAncestor() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("ancestor", (Object)PORTFOLIO_DATA_PATH);
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)110L, (long)entities.length);
    }

    @Test
    public void shouldSearchByType() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("type", (Object)"teiidddl:tableElement");
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)38L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.COLUMN, (Object)kType);
        }
    }

    @Test
    public void shouldSearchByKType() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("type", (Object)KomodoType.COLUMN.getType());
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)38L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.COLUMN, (Object)kType);
        }
    }

    @Test
    public void shouldSearchByKTypeAndLocalName() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("type", (Object)KomodoType.COLUMN.getType());
        properties.addProperty("objectName", (Object)"%ID%");
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)12L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.COLUMN, (Object)kType);
            Assert.assertTrue((boolean)basicEntity.getId().contains("ID"));
        }
    }

    @Test
    public void shouldExecuteSavedSearch() throws Exception {
        this.loadVdbs();
        List<String> searchNames = this.loadSampleSearches();
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("searchName", (Object)searchNames.get(0));
        URI uri = _uriBuilder.searchUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)4L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.VDB, (Object)kType);
        }
    }

    @Test
    public void shouldReturnSavedSearches() throws Exception {
        this.loadVdbs();
        List<String> searchNames = this.loadSampleSearches();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.savedSearchCollectionUri(properties);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        KomodoSavedSearcher[] entities = (KomodoSavedSearcher[])KomodoJsonMarshaller.unmarshallArray((String)entity, KomodoSavedSearcher[].class);
        Assert.assertEquals((long)searchNames.size(), (long)entities.length);
        for (KomodoSavedSearcher kso : entities) {
            searchNames.contains(kso.getName());
        }
    }

    @Test
    public void shouldSaveSearch() throws Exception {
        this.loadVdbs();
        URI uri = _uriBuilder.savedSearchCollectionUri(new KomodoProperties());
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        String searchName = "Vdbs Search";
        searchAttr.setSearchName(searchName);
        searchAttr.setType("vdb:virtualDatabase");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        this.executeOk((HttpUriRequest)request);
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "FindSavedSearches" + ":" + System.currentTimeMillis(), true, null);
        KomodoObject searches = repository.komodoSearches(uow);
        KomodoObject[] children = searches.getChildren(uow, new String[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)searchName, (Object)children[0].getName(uow));
    }

    @Test
    public void shouldSaveSearchWithParameters() throws Exception {
        this.loadVdbs();
        URI uri = _uriBuilder.savedSearchCollectionUri(new KomodoProperties());
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        String searchName = "Vdbs Search";
        searchAttr.setSearchName(searchName);
        searchAttr.setType("{fromTypeParam}");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        this.executeOk((HttpUriRequest)request);
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "FindSavedSearches" + ":" + System.currentTimeMillis(), true, null);
        KomodoObject searches = repository.komodoSearches(uow);
        KomodoObject[] children = searches.getChildren(uow, new String[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals((Object)searchName, (Object)children[0].getName(uow));
    }

    @Test
    public void shouldDeleteSavedSearch() throws Exception {
        this.loadVdbs();
        List<String> searchNames = this.loadSampleSearches();
        URI uri = _uriBuilder.savedSearchCollectionUri(new KomodoProperties());
        String searchName = searchNames.get(0);
        uri = UriBuilder.fromUri((URI)uri).path(searchName).build(new Object[0]);
        HttpDelete request = (HttpDelete)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.DELETE);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.execute((HttpUriRequest)request);
        Repository repository = this.getRestApp().getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(USER_NAME, this.getClass().getSimpleName() + ":" + "FindSavedSearches" + ":" + System.currentTimeMillis(), true, null);
        KomodoObject searches = repository.komodoSearches(uow);
        KomodoObject[] children = searches.getChildren(uow, new String[0]);
        Assert.assertEquals((long)(searchNames.size() - 1), (long)children.length);
        for (KomodoObject child : children) {
            Assert.assertNotEquals((Object)searchName, (Object)child.getName(uow));
        }
    }

    @Test
    public void shouldAdvancedSearchForAnythingContainingView() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setContains("view");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)19L, (long)entities.length);
        for (RestBasicEntity e : entities) {
            Assert.assertNotNull((Object)e.getId());
            Assert.assertNotNull((Object)e.getBaseUri());
            Assert.assertNotNull((Object)e.getDataPath());
            Assert.assertNotNull((Object)e.getkType());
            Assert.assertNotNull((Object)e.hasChildren());
            Assert.assertNotEquals((Object)KomodoType.UNKNOWN, (Object)e.getkType());
        }
    }

    @Test
    public void shouldAdvancedSearchForAnyModelContainingView() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setType("vdb:declarativeModel");
        searchAttr.setContains("view");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)5L, (long)entities.length);
        for (RestBasicEntity e : entities) {
            Assert.assertNotNull((Object)e.getId());
            Assert.assertNotNull((Object)e.getBaseUri());
            Assert.assertNotNull((Object)e.getDataPath());
            Assert.assertNotNull((Object)e.getkType());
            Assert.assertNotNull((Object)e.hasChildren());
            Assert.assertEquals((Object)KomodoType.MODEL, (Object)e.getkType());
        }
    }

    @Test
    public void shouldAdvancedSearchForAnyModelUnderPortfolioContainingView() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setType("vdb:declarativeModel");
        searchAttr.setParent(PORTFOLIO_DATA_PATH);
        searchAttr.setContains("view");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)2L, (long)entities.length);
        for (RestBasicEntity e : entities) {
            Assert.assertNotNull((Object)e.getId());
            Assert.assertNotNull((Object)e.getBaseUri());
            Assert.assertNotNull((Object)e.getDataPath());
            Assert.assertNotNull((Object)e.getkType());
            Assert.assertNotNull((Object)e.hasChildren());
            Assert.assertEquals((Object)KomodoType.MODEL, (Object)e.getkType());
            Assert.assertTrue((boolean)e.getDataPath().startsWith(PORTFOLIO_DATA_PATH));
        }
    }

    @Test
    public void shouldAdvancedSearchByPath() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setPath(PORTFOLIO_DATA_PATH);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        System.out.println("Response:\n" + entity);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)1L, (long)entities.length);
        RestBasicEntity basicEntity = entities[0];
        RestVdb vdb = (RestVdb)RestEntityFactory.resolve((RestBasicEntity)basicEntity, RestVdb.class);
        Assert.assertNotNull((Object)vdb);
        this.assertPortfolio(vdb);
    }

    @Test
    public void shouldAdvancedSearchByParent() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setParent(PORTFOLIO_DATA_PATH);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)5L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            RestVdbModel model = (RestVdbModel)RestEntityFactory.resolve((RestBasicEntity)basicEntity, RestVdbModel.class);
            Assert.assertNotNull((Object)model);
        }
    }

    @Test
    public void shouldAdvancedSearchByAncestor() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setAncestor(PORTFOLIO_DATA_PATH);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)110L, (long)entities.length);
    }

    @Test
    public void shouldAdvancedSearchByType() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setType("teiidddl:tableElement");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        System.out.println("Response:\n" + entity);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)38L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.COLUMN, (Object)kType);
        }
    }

    @Test
    public void shouldAdvancedSearchByKType() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setType(KomodoType.COLUMN.getType());
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)38L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.COLUMN, (Object)kType);
        }
    }

    @Test
    public void shouldAdvancedSearchByKTypeAndLocalName() throws Exception {
        this.loadVdbs();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setType(KomodoType.COLUMN.getType());
        searchAttr.setObjectName("%ID%");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)12L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.COLUMN, (Object)kType);
            Assert.assertTrue((boolean)basicEntity.getId().contains("ID"));
        }
    }

    @Test
    public void shouldAdvancedExecuteSavedSearch() throws Exception {
        this.loadVdbs();
        List<String> searchNames = this.loadSampleSearches();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setSearchName(searchNames.get(0));
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)4L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.VDB, (Object)kType);
        }
    }

    @Test
    public void shouldAdvancedExecuteSavedSearchWithParameter() throws Exception {
        this.loadVdbs();
        List<String> searchNames = this.loadSampleSearches();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setSearchName(searchNames.get(2));
        searchAttr.setParameter("valueParam", "%_ID");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)12L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.COLUMN, (Object)kType);
            Assert.assertTrue((boolean)basicEntity.getId().endsWith("_ID"));
        }
    }

    @Test
    public void shouldFailToSavedSearchDueToLackofParameter() throws Exception {
        this.loadVdbs();
        List<String> searchNames = this.loadSampleSearches();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setSearchName(searchNames.get(2));
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 403);
        String entity = this.extractResponse(response);
        System.out.println("Response:\n" + entity);
        Assert.assertTrue((boolean)entity.contains("An error occurred whilst searching the workspace: Search requires the parameter valueParam but has not been provided a value"));
    }

    @Test
    public void shouldAdvancedExecuteSavedSearchWithKTypeParameter() throws Exception {
        this.loadVdbs();
        List<String> searchNames = this.loadSampleSearches();
        KomodoProperties properties = new KomodoProperties();
        URI uri = _uriBuilder.searchUri(properties);
        KomodoSearcherAttributes searchAttr = new KomodoSearcherAttributes();
        searchAttr.setSearchName(searchNames.get(3));
        searchAttr.setParameter("fromTypeParam", "Vdb");
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)searchAttr);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.okResponse(response);
        String entity = this.extractResponse(response);
        RestBasicEntity[] entities = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertEquals((long)4L, (long)entities.length);
        for (RestBasicEntity basicEntity : entities) {
            KomodoType kType = basicEntity.getkType();
            Assert.assertEquals((Object)KomodoType.VDB, (Object)kType);
        }
    }
}

