/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.AbstractKomodoServiceTest;
import org.komodo.rest.service.KomodoUtilService;
import org.komodo.spi.repository.KomodoType;
import org.komodo.test.utils.TestUtilities;

public class KomodoUtilServiceTest
extends AbstractKomodoServiceTest {
    private void loadSamples(String user) throws Exception {
        for (String sample : KomodoUtilService.SAMPLES) {
            this.getRestApp().importVdb(KomodoUtilService.getVdbSample((String)sample), user);
        }
        Assert.assertEquals((long)KomodoUtilService.SAMPLES.length, (long)this.getRestApp().getVdbs(user).length);
    }

    @Test
    public void shouldAbout() throws Exception {
        String[] EXPECTED = new String[]{"{\n", "  \"Information\": {\n", "    \"Repository Workspace\": \"komodoLocalWorkspace\",\n", "    \"Repository Configuration\"", "    \"Repository Vdb Total\": \"" + KomodoUtilService.SAMPLES.length + "\"" + "\n", "  }\n"};
        this.loadSamples(USER_NAME);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("service").path("about").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        this.addHeader((HttpUriRequest)request, "Origin", "http://localhost:2772");
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        System.out.println("Response from uri " + uri + ":\n" + entity);
        for (String expected : EXPECTED) {
            Assert.assertTrue((boolean)entity.contains(expected));
        }
        Assert.assertTrue((boolean)entity.contains("App Name"));
        Assert.assertTrue((boolean)entity.contains("App Title"));
        Assert.assertTrue((boolean)entity.contains("App Version"));
        Assert.assertTrue((boolean)entity.contains("App Description"));
    }

    @Test
    public void shouldLoadSampleData() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("service").path("samples").build(new Object[0]);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        KomodoStatusObject status = (KomodoStatusObject)KomodoJsonMarshaller.unmarshall((String)entity, KomodoStatusObject.class);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"Sample Vdb Import", (Object)status.getTitle());
        Map attributes = status.getAttributes();
        for (String sample : KomodoUtilService.SAMPLES) {
            String message = (String)attributes.get(sample);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_IMPORT_SUCCESS, (Object[])new Object[]{sample}), (Object)message);
        }
    }

    @Test
    public void shouldLoadSamplesDataAlreadyExists() throws Exception {
        this.loadSamples(USER_NAME);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("service").path("samples").build(new Object[0]);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        KomodoStatusObject status = (KomodoStatusObject)KomodoJsonMarshaller.unmarshall((String)entity, KomodoStatusObject.class);
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"Sample Vdb Import", (Object)status.getTitle());
        Map attributes = status.getAttributes();
        for (String sample : KomodoUtilService.SAMPLES) {
            String message = (String)attributes.get(sample);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_IMPORT_VDB_EXISTS, (Object[])new Object[]{sample}), (Object)message);
        }
    }

    @Test
    public void shouldReturnTeiidSchema() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("service").path("schema").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        System.out.println("Response from uri " + uri + ":\n" + entity);
        InputStream schemaStream = this.getClass().getResourceAsStream("teiid-schema.json");
        String expected = TestUtilities.toString((InputStream)schemaStream);
        if (!expected.trim().equals(entity)) {
            schemaStream = this.getClass().getResourceAsStream("teiid-schema2.json");
            expected = TestUtilities.toString((InputStream)schemaStream);
            Assert.assertEquals((Object)expected.trim(), (Object)entity);
        }
    }

    @Test
    public void shouldReturnTeiidSchemaForKType() throws Exception {
        UriBuilder baseBuilder = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("service").path("schema");
        URI uri = baseBuilder.clone().queryParam("ktype", new Object[]{KomodoType.MODEL}).build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        System.out.println("Response from uri " + uri + ":\n" + entity);
        Assert.assertFalse((boolean)entity.contains("\"schema-1\" : {"));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"vdb\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\": \"connection\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"importVdb\""));
        Assert.assertTrue((boolean)entity.contains("\"keng__id\" : \"model\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"source\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"metadata\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"validationError\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"translator\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"dataRole\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"permission\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"condition\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"mask\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"entry\""));
        uri = baseBuilder.clone().queryParam("ktype", new Object[]{KomodoType.VDB_DATA_ROLE}).build(new Object[0]);
        request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        response = this.executeOk((HttpUriRequest)request);
        entity = this.extractResponse(response);
        Assert.assertFalse((boolean)entity.contains("\"schema-1\" : {"));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"vdb\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\": \"connection\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"importVdb\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"model\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"source\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"metadata\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"validationError\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"translator\""));
        Assert.assertTrue((boolean)entity.contains("\"keng__id\" : \"dataRole\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"permission\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"condition\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"mask\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"entry\""));
        uri = baseBuilder.clone().queryParam("ktype", new Object[]{KomodoType.VDB_MASK}).build(new Object[0]);
        request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        response = this.executeOk((HttpUriRequest)request);
        entity = this.extractResponse(response);
        Assert.assertFalse((boolean)entity.contains("\"schema-1\" : {"));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"vdb\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\": \"connection\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"importVdb\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"model\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"source\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"metadata\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"validationError\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"translator\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"dataRole\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"permission\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"condition\""));
        Assert.assertTrue((boolean)entity.contains("\"keng__id\" : \"mask\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"entry\""));
        uri = baseBuilder.clone().queryParam("ktype", new Object[]{KomodoType.CONNECTION}).build(new Object[0]);
        request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        response = this.executeOk((HttpUriRequest)request);
        entity = this.extractResponse(response);
        Assert.assertFalse((boolean)entity.contains("\"schema-1\" : {"));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"vdb\""));
        Assert.assertTrue((boolean)entity.contains("\"keng__id\": \"connection\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"importVdb\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"model\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"source\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"metadata\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"validationError\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"translator\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"dataRole\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"permission\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"condition\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"mask\""));
        Assert.assertFalse((boolean)entity.contains("\"keng__id\" : \"entry\""));
    }
}

