/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.komodo.relational.model.Model;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.rest.relational.response.RestVdbCondition;
import org.komodo.rest.relational.response.RestVdbDataRole;
import org.komodo.rest.relational.response.RestVdbImport;
import org.komodo.rest.relational.response.RestVdbMask;
import org.komodo.rest.relational.response.RestVdbModel;
import org.komodo.rest.relational.response.RestVdbModelSource;
import org.komodo.rest.relational.response.RestVdbModelTable;
import org.komodo.rest.relational.response.RestVdbModelTableColumn;
import org.komodo.rest.relational.response.RestVdbPermission;
import org.komodo.rest.relational.response.RestVdbTranslator;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.AbstractKomodoServiceTest;
import org.komodo.spi.repository.KomodoType;
import org.komodo.test.utils.TestUtilities;

public class KomodoVdbServiceTest
extends AbstractKomodoServiceTest {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void shouldGetVdbs() throws Exception {
        this.loadVdbs();
        URI uri = _uriBuilder.workspaceVdbsUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdb[] vdbs = (RestVdb[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdb[].class);
        Assert.assertEquals((long)4L, (long)vdbs.length);
        boolean foundPortfolio = false;
        for (RestVdb vdb : vdbs) {
            Assert.assertNotNull((Object)vdb.getId());
            Assert.assertNotNull((Object)vdb.getDataPath());
            Assert.assertNotNull((Object)vdb.getkType());
            if (!"Portfolio".equals(vdb.getId())) continue;
            foundPortfolio = true;
            this.assertPortfolio(vdb);
        }
        Assert.assertTrue((boolean)foundPortfolio);
    }

    @Test
    public void shouldNotGetVdbsXml() throws Exception {
        this.loadVdbs();
        URI uri = _uriBuilder.workspaceVdbsUri();
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.APPLICATION_XML_TYPE);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 500);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertTrue((boolean)entity.contains("No match for accept header"));
    }

    @Test
    public void shouldCreateModel() throws Exception {
        String vdbName = "blah";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        URI uri = _uriBuilder.vdbUri(RestLink.LinkType.SELF, settings);
        RestVdb vdb = new RestVdb();
        vdb.setName(vdbName);
        vdb.setDescription("blah VDB description");
        vdb.setOriginalFilePath("/Users/elvis/vdbs/blah.vdb");
        vdb.setPreview(false);
        vdb.setConnectionType("connType");
        vdb.setVersion(1);
        vdb.setId(vdbName);
        vdb.setkType(KomodoType.VDB);
        vdb.setDataPath("/tko:komodo/tko:workspace/" + USER_NAME + "/blah");
        String json = KomodoJsonMarshaller.marshall((KRestEntity)vdb);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, json);
        this.executeOk((HttpUriRequest)request);
        String modelName = "elvis";
        String dataPath = "/tko:komodo/tko:workspace/" + USER_NAME + "/blah/elvis";
        String ddl = "CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
        String description = "model description goes here";
        String id = modelName;
        KomodoType kType = KomodoType.MODEL;
        String metadataType = "DDL";
        Model.Type modelType = Model.Type.VIRTUAL;
        boolean visible = true;
        Properties settings2 = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        _uriBuilder.addSetting(settings2, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings2, KomodoRestUriBuilder.SettingNames.MODEL_NAME, modelName);
        URI uri2 = _uriBuilder.vdbModelUri(RestLink.LinkType.SELF, settings2);
        RestVdbModel inModel = new RestVdbModel();
        inModel.setDataPath(dataPath);
        inModel.setDdl(ddl);
        inModel.setDescription(description);
        inModel.setId(id);
        inModel.setkType(kType);
        inModel.setMetadataType(metadataType);
        inModel.setModelType(modelType);
        inModel.setVisible(visible);
        String json2 = KomodoJsonMarshaller.marshall((KRestEntity)inModel);
        HttpPost request2 = (HttpPost)this.jsonRequest(uri2, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request2, json2);
        HttpResponse response = this.executeOk((HttpUriRequest)request2);
        String entity = this.extractResponse(response);
        Assert.assertThat((Object)entity, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestVdbModel outModel = (RestVdbModel)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbModel.class);
        Assert.assertNotNull((Object)outModel);
        Assert.assertThat((Object)outModel.getDataPath(), (Matcher)Is.is((Object)dataPath));
        Assert.assertThat((Object)outModel.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)outModel.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)outModel.getkType(), (Matcher)Is.is((Object)kType));
        Assert.assertThat((Object)outModel.getMetadataType(), (Matcher)Is.is((Object)metadataType));
        Assert.assertThat((Object)outModel.getModelType(), (Matcher)Is.is((Object)modelType));
        Assert.assertThat((Object)outModel.isVisible(), (Matcher)Is.is((Object)visible));
        HttpGet request3 = (HttpGet)this.jsonRequest(uri2, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response2 = this.executeOk((HttpUriRequest)request3);
        String entity2 = this.extractResponse(response2);
        Assert.assertThat((Object)entity2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        RestVdbModel newModel = (RestVdbModel)KomodoJsonMarshaller.unmarshall((String)entity2, RestVdbModel.class);
        Assert.assertNotNull((Object)newModel);
        Assert.assertThat((Object)newModel.getDataPath(), (Matcher)Is.is((Object)dataPath));
        Assert.assertThat((Object)newModel.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)newModel.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)newModel.getkType(), (Matcher)Is.is((Object)kType));
        Assert.assertThat((Object)newModel.getMetadataType(), (Matcher)Is.is((Object)metadataType));
        Assert.assertThat((Object)newModel.getModelType(), (Matcher)Is.is((Object)modelType));
        Assert.assertThat((Object)newModel.isVisible(), (Matcher)Is.is((Object)visible));
        String actual = newModel.getDdl().toLowerCase().replace('\n', ' ').trim();
        String expected = ddl.toLowerCase().replace('\n', ' ').trim();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void shouldCreateModelSource() throws Exception {
        String modelSourceName;
        String vdbName = "blah";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        URI uri = _uriBuilder.vdbUri(RestLink.LinkType.SELF, settings);
        RestVdb vdb = new RestVdb();
        vdb.setName(vdbName);
        vdb.setDescription("blah VDB description");
        vdb.setOriginalFilePath("/Users/elvis/vdbs/blah.vdb");
        vdb.setPreview(false);
        vdb.setConnectionType("connType");
        vdb.setVersion(1);
        vdb.setId(vdbName);
        vdb.setkType(KomodoType.VDB);
        vdb.setDataPath("/tko:komodo/tko:workspace/" + USER_NAME + "/blah");
        String json = KomodoJsonMarshaller.marshall((KRestEntity)vdb);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, json);
        this.executeOk((HttpUriRequest)request);
        String modelName = "elvis";
        RestVdbModel model = new RestVdbModel();
        model.setDataPath("/tko:komodo/tko:workspace/" + USER_NAME + "/blah/elvis");
        model.setDdl("CREATE VIEW Tweet AS select * FROM twitterview.getTweets;");
        model.setDescription("model description goes here");
        model.setId(modelName);
        model.setkType(KomodoType.MODEL);
        model.setMetadataType("DDL");
        model.setModelType(Model.Type.VIRTUAL);
        model.setVisible(true);
        Properties settings2 = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        _uriBuilder.addSetting(settings2, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings2, KomodoRestUriBuilder.SettingNames.MODEL_NAME, modelName);
        URI uri2 = _uriBuilder.vdbModelUri(RestLink.LinkType.SELF, settings2);
        String json2 = KomodoJsonMarshaller.marshall((KRestEntity)model);
        HttpPost request2 = (HttpPost)this.jsonRequest(uri2, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request2, json2);
        this.executeOk((HttpUriRequest)request2);
        String id = modelSourceName = "sledge";
        String dataPath = "/tko:komodo/tko:workspace/" + USER_NAME + "/blah/elvis/vdb:sources/sledge";
        KomodoType kType = KomodoType.VDB_MODEL_SOURCE;
        String jndiName = "myJndiName";
        String translator = "myTranslator";
        Properties settings3 = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        _uriBuilder.addSetting(settings3, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings3, KomodoRestUriBuilder.SettingNames.MODEL_NAME, modelName);
        _uriBuilder.addSetting(settings3, KomodoRestUriBuilder.SettingNames.SOURCE_NAME, modelSourceName);
        URI uri3 = _uriBuilder.vdbModelSourceUri(RestLink.LinkType.SELF, settings3);
        RestVdbModelSource inModelSource = new RestVdbModelSource();
        inModelSource.setDataPath(dataPath);
        inModelSource.setId(id);
        inModelSource.setkType(kType);
        inModelSource.setJndiName(jndiName);
        inModelSource.setTranslator(translator);
        String json3 = KomodoJsonMarshaller.marshall((KRestEntity)inModelSource);
        HttpPost request3 = (HttpPost)this.jsonRequest(uri3, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request3, json3);
        HttpResponse response = this.executeOk((HttpUriRequest)request3);
        String entity = this.extractResponse(response);
        RestVdbModelSource outModelSource = (RestVdbModelSource)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbModelSource.class);
        Assert.assertNotNull((Object)outModelSource);
        Assert.assertThat((Object)outModelSource.getDataPath(), (Matcher)Is.is((Object)dataPath));
        Assert.assertThat((Object)outModelSource.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)outModelSource.getkType(), (Matcher)Is.is((Object)kType));
        Assert.assertThat((Object)outModelSource.getJndiName(), (Matcher)Is.is((Object)jndiName));
        Assert.assertThat((Object)outModelSource.getTranslator(), (Matcher)Is.is((Object)translator));
        HttpGet request4 = (HttpGet)this.jsonRequest(uri3, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response2 = this.executeOk((HttpUriRequest)request4);
        String entity2 = this.extractResponse(response2);
        RestVdbModelSource newModelSource = (RestVdbModelSource)KomodoJsonMarshaller.unmarshall((String)entity2, RestVdbModelSource.class);
        Assert.assertNotNull((Object)newModelSource);
        Assert.assertThat((Object)newModelSource.getDataPath(), (Matcher)Is.is((Object)dataPath));
        Assert.assertThat((Object)newModelSource.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)newModelSource.getkType(), (Matcher)Is.is((Object)kType));
        Assert.assertThat((Object)newModelSource.getJndiName(), (Matcher)Is.is((Object)jndiName));
        Assert.assertThat((Object)newModelSource.getTranslator(), (Matcher)Is.is((Object)translator));
    }

    @Test
    public void shouldCreateVdb() throws Exception {
        String vdbName = "blah";
        String description = "blah VDB description";
        String originalFilePath = "/Users/elvis/vdbs/blah.vdb";
        boolean preview = false;
        String connectionType = "connType";
        int version = 5;
        String id = vdbName;
        KomodoType kType = KomodoType.VDB;
        String dataPath = "/tko:komodo/tko:workspace/" + USER_NAME + "/blah";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        URI uri = _uriBuilder.vdbUri(RestLink.LinkType.SELF, settings);
        RestVdb inVdb = new RestVdb();
        inVdb.setName(vdbName);
        inVdb.setDescription(description);
        inVdb.setOriginalFilePath(originalFilePath);
        inVdb.setPreview(preview);
        inVdb.setConnectionType(connectionType);
        inVdb.setVersion(version);
        inVdb.setId(id);
        inVdb.setkType(kType);
        inVdb.setDataPath(dataPath);
        String json = KomodoJsonMarshaller.marshall((KRestEntity)inVdb);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, json);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdb outVdb = (RestVdb)KomodoJsonMarshaller.unmarshall((String)entity, RestVdb.class);
        Assert.assertNotNull((Object)outVdb);
        Assert.assertThat((Object)outVdb.getName(), (Matcher)Is.is((Object)vdbName));
        Assert.assertThat((Object)outVdb.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)outVdb.getOriginalFilePath(), (Matcher)Is.is((Object)originalFilePath));
        Assert.assertThat((Object)outVdb.isPreview(), (Matcher)Is.is((Object)preview));
        Assert.assertThat((Object)outVdb.getConnectionType(), (Matcher)Is.is((Object)connectionType));
        Assert.assertThat((Object)outVdb.getVersion(), (Matcher)Is.is((Object)version));
        Assert.assertThat((Object)outVdb.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)outVdb.getkType(), (Matcher)Is.is((Object)kType));
        Assert.assertThat((Object)outVdb.getDataPath(), (Matcher)Is.is((Object)dataPath));
        HttpGet request2 = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response2 = this.executeOk((HttpUriRequest)request2);
        String entity2 = this.extractResponse(response2);
        RestVdb newVdb = (RestVdb)KomodoJsonMarshaller.unmarshall((String)entity2, RestVdb.class);
        Assert.assertNotNull((Object)newVdb);
        Assert.assertThat((Object)newVdb.getName(), (Matcher)Is.is((Object)vdbName));
        Assert.assertThat((Object)newVdb.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)newVdb.getOriginalFilePath(), (Matcher)Is.is((Object)originalFilePath));
        Assert.assertThat((Object)newVdb.isPreview(), (Matcher)Is.is((Object)preview));
        Assert.assertThat((Object)newVdb.getConnectionType(), (Matcher)Is.is((Object)connectionType));
        Assert.assertThat((Object)newVdb.getVersion(), (Matcher)Is.is((Object)version));
        Assert.assertThat((Object)newVdb.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)newVdb.getkType(), (Matcher)Is.is((Object)kType));
        Assert.assertThat((Object)newVdb.getDataPath(), (Matcher)Is.is((Object)dataPath));
    }

    @Test
    public void shouldGetVdb() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "Portfolio");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        URI uri = _uriBuilder.vdbUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdb vdb = (RestVdb)KomodoJsonMarshaller.unmarshall((String)entity, RestVdb.class);
        Assert.assertNotNull((Object)vdb);
        this.assertPortfolio(vdb);
    }

    @Test
    public void shouldGetVdbXml() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "Portfolio");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        URI uri = _uriBuilder.vdbUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.APPLICATION_XML_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        System.out.println("Response:\n" + entity);
        Assert.assertTrue((boolean)entity.contains("<?xml version="));
        Assert.assertTrue((boolean)entity.contains("encoding="));
        Assert.assertTrue((boolean)entity.contains("<vdb name=\"Portfolio\" version=\"1\">"));
        Assert.assertTrue((boolean)entity.contains("</vdb>"));
    }

    @Test
    public void shouldGetVdbWhenPatternMatches() throws Exception {
        this.loadVdbs();
        String pattern = "*P*";
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.workspaceVdbsUri()).queryParam("pattern", new Object[]{pattern}).build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdb[] vdbs = (RestVdb[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdb[].class);
        Assert.assertEquals((long)2L, (long)vdbs.length);
        for (RestVdb vdb : vdbs) {
            if ("MyPartsVDB_Dynamic".equals(vdb.getName())) continue;
            if ("Portfolio".equals(vdb.getName())) {
                this.assertPortfolio(vdb);
                continue;
            }
            Assert.fail((String)("Invalid VDB returned from search pattern " + pattern));
        }
    }

    @Test
    public void shouldLimitNumberOfVdbsReturnedWhenUsingSizeQueryParameter() throws Exception {
        this.loadVdbs();
        int resultSize = 3;
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.workspaceVdbsUri()).queryParam("size", new Object[]{resultSize}).build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdb[] vdbs = (RestVdb[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdb[].class);
        Assert.assertEquals((long)resultSize, (long)vdbs.length);
    }

    @Test
    public void shouldLimitNumberOfVdbsReturnedWhenUsingStartQueryParameter() throws Exception {
        this.loadVdbs();
        int start = 3;
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.workspaceVdbsUri()).queryParam("start", new Object[]{start}).build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdb[] vdbs = (RestVdb[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdb[].class);
        Assert.assertEquals((long)1L, (long)vdbs.length);
    }

    @Test
    public void shouldNotFindVdb() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.workspaceVdbsUri()).path("blah").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 404);
    }

    @Test
    public void shouldReturnEmptyListWhenNoVdbsInWorkspace() throws Exception {
        URI uri = _uriBuilder.workspaceVdbsUri();
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdb[] vdbs = (RestVdb[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdb[].class);
        Assert.assertNotNull((Object)vdbs);
        Assert.assertEquals((long)0L, (long)vdbs.length);
    }

    @Test
    public void shouldGetVdbModels() throws Exception {
        this.loadVdbs();
        URI vdbBaseUri = _uriBuilder.workspaceVdbsUri();
        URI uri = _uriBuilder.vdbChildGroupUri(vdbBaseUri, "Portfolio", RestLink.LinkType.MODELS);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbModel[] models = (RestVdbModel[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbModel[].class);
        Assert.assertNotNull((Object)models);
        Assert.assertEquals((long)5L, (long)models.length);
        for (RestVdbModel model : models) {
            Assert.assertEquals((Object)KomodoType.MODEL, (Object)model.getkType());
            Assert.assertEquals((Object)true, (Object)model.isVisible());
            if ("MarketData".equals(model.getId())) {
                Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)model.getModelType());
            } else if ("Accounts".equals(model.getId())) {
                Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)model.getModelType());
            } else if ("PersonalValuations".equals(model.getId())) {
                Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)model.getModelType());
            } else if ("Stocks".equals(model.getId())) {
                Assert.assertEquals((Object)Model.Type.VIRTUAL, (Object)model.getModelType());
            } else if ("StocksMatModel".equals(model.getId())) {
                Assert.assertEquals((Object)Model.Type.VIRTUAL, (Object)model.getModelType());
            } else {
                Assert.fail((String)"Model has invalid id");
            }
            Collection links = model.getLinks();
            Assert.assertEquals((long)4L, (long)links.size());
        }
    }

    @Test
    public void shouldGetVdbModel() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "Portfolio");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, "PersonalValuations");
        URI uri = _uriBuilder.vdbModelUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbModel model = (RestVdbModel)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"PersonalValuations", (Object)model.getId());
        Assert.assertEquals((Object)KomodoType.MODEL, (Object)model.getkType());
        Assert.assertEquals((Object)true, (Object)model.isVisible());
        Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)model.getModelType());
        Collection links = model.getLinks();
        Assert.assertEquals((long)4L, (long)links.size());
    }

    @Test
    public void shouldGetVdbModelSources() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "Portfolio");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, "PersonalValuations");
        URI uri = _uriBuilder.vdbModelUri(RestLink.LinkType.SOURCES, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdbModelSource[] sources = (RestVdbModelSource[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdbModelSource[].class);
        Assert.assertEquals((long)1L, (long)sources.length);
        RestVdbModelSource source = sources[0];
        Assert.assertEquals((Object)"excelconnector", (Object)source.getId());
        Assert.assertEquals((Object)KomodoType.VDB_MODEL_SOURCE, (Object)source.getkType());
        Assert.assertEquals((Object)"java:/excel-file", (Object)source.getJndiName());
        Assert.assertEquals((Object)"excel", (Object)source.getTranslator());
        Collection links = source.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbModelTables() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "MyPartsVDB_Dynamic");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, "PartsSS");
        URI modelUri = _uriBuilder.vdbModelUri(RestLink.LinkType.SELF, settings);
        URI uri = UriBuilder.fromUri((URI)modelUri).path(RestLink.LinkType.TABLES.uriName()).build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdbModelTable[] tables = (RestVdbModelTable[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdbModelTable[].class);
        Assert.assertEquals((long)5L, (long)tables.length);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (RestVdbModelTable table : tables) {
            tableNames.add(table.getId());
        }
        Assert.assertTrue((boolean)tableNames.contains("PARTS"));
        Assert.assertTrue((boolean)tableNames.contains("SHIP_VIA"));
        Assert.assertTrue((boolean)tableNames.contains("STATUS"));
        Assert.assertTrue((boolean)tableNames.contains("SUPPLIER"));
        Assert.assertTrue((boolean)tableNames.contains("SUPPLIER_PARTS"));
    }

    @Test
    public void shouldGetVdbModelTableColumns() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "MyPartsVDB_Dynamic");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, "PartsSS");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.TABLE_NAME, "SUPPLIER_PARTS");
        URI modelTableUri = _uriBuilder.vdbModelTableUri(RestLink.LinkType.SELF, settings);
        URI uri = UriBuilder.fromUri((URI)modelTableUri).path(RestLink.LinkType.COLUMNS.uriName()).build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdbModelTableColumn[] columns = (RestVdbModelTableColumn[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdbModelTableColumn[].class);
        Assert.assertEquals((long)4L, (long)columns.length);
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, String> columnTypeMap = new HashMap<String, String>();
        for (RestVdbModelTableColumn column : columns) {
            columnNames.add(column.getId());
            columnTypeMap.put(column.getId(), column.getDatatypeName());
        }
        Assert.assertTrue((boolean)columnNames.contains("SUPPLIER_ID"));
        Assert.assertTrue((boolean)((String)columnTypeMap.get("SUPPLIER_ID")).equalsIgnoreCase("string"));
        Assert.assertTrue((boolean)columnNames.contains("PART_ID"));
        Assert.assertTrue((boolean)((String)columnTypeMap.get("PART_ID")).equalsIgnoreCase("string"));
        Assert.assertTrue((boolean)columnNames.contains("QUANTITY"));
        Assert.assertTrue((boolean)((String)columnTypeMap.get("QUANTITY")).equalsIgnoreCase("bigdecimal"));
        Assert.assertTrue((boolean)columnNames.contains("SHIPPER_ID"));
        Assert.assertTrue((boolean)((String)columnTypeMap.get("SHIPPER_ID")).equalsIgnoreCase("bigdecimal"));
    }

    @Test
    public void shouldGetVdbModelSourcesIncludeReferenceForTranslator() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "twitter");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, "twitter");
        URI uri = _uriBuilder.vdbModelUri(RestLink.LinkType.SOURCES, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entities = this.extractResponse(response);
        RestVdbModelSource[] sources = (RestVdbModelSource[])KomodoJsonMarshaller.unmarshallArray((String)entities, RestVdbModelSource[].class);
        Assert.assertEquals((long)1L, (long)sources.length);
        RestVdbModelSource source = sources[0];
        Assert.assertEquals((Object)"twitter", (Object)source.getId());
        Assert.assertEquals((Object)KomodoType.VDB_MODEL_SOURCE, (Object)source.getkType());
        Assert.assertEquals((Object)"java:/twitterDS", (Object)source.getJndiName());
        Assert.assertEquals((Object)"rest", (Object)source.getTranslator());
        Collection links = source.getLinks();
        Assert.assertEquals((long)4L, (long)links.size());
        RestLink refLink = null;
        for (RestLink link : links) {
            if (!RestLink.LinkType.REFERENCE.equals((Object)link.getRel())) continue;
            refLink = link;
        }
        Assert.assertNotNull(refLink);
        URI href = refLink.getHref();
        Assert.assertTrue((boolean)href.toString().endsWith("workspace/vdbs/twitter/VdbTranslators/rest"));
    }

    @Test
    public void shouldGetVdbModelSource() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "Portfolio");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, "PersonalValuations");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.SOURCE_NAME, "excelconnector");
        URI uri = _uriBuilder.vdbModelSourceUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbModelSource source = (RestVdbModelSource)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbModelSource.class);
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((Object)"excelconnector", (Object)source.getId());
        Assert.assertEquals((Object)KomodoType.VDB_MODEL_SOURCE, (Object)source.getkType());
        Assert.assertEquals((Object)"java:/excel-file", (Object)source.getJndiName());
        Assert.assertEquals((Object)"excel", (Object)source.getTranslator());
        Collection links = source.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbTranslators() throws Exception {
        this.loadVdbs();
        URI vdbBaseUri = _uriBuilder.workspaceVdbsUri();
        URI uri = _uriBuilder.vdbChildGroupUri(vdbBaseUri, "twitter", RestLink.LinkType.TRANSLATORS);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbTranslator[] translators = (RestVdbTranslator[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbTranslator[].class);
        Assert.assertNotNull((Object)translators);
        Assert.assertEquals((long)1L, (long)translators.length);
        RestVdbTranslator translator = translators[0];
        Assert.assertEquals((Object)KomodoType.VDB_TRANSLATOR, (Object)translator.getkType());
        Assert.assertEquals((Object)"ws", (Object)translator.getType());
        Assert.assertEquals((Object)"Rest Web Service translator", (Object)translator.getDescription());
        Collection links = translator.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbTranslatorsEmptyList() throws Exception {
        this.loadVdbs();
        URI vdbBaseUri = _uriBuilder.workspaceVdbsUri();
        URI uri = _uriBuilder.vdbChildGroupUri(vdbBaseUri, "Portfolio", RestLink.LinkType.TRANSLATORS);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbTranslator[] translators = (RestVdbTranslator[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbTranslator[].class);
        Assert.assertNotNull((Object)translators);
        Assert.assertEquals((long)0L, (long)translators.length);
    }

    @Test
    public void shouldGetVdbTranslator() throws Exception {
        this.loadVdbs();
        String vdbName = "twitter";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        URI parentUri = _uriBuilder.vdbUri(_uriBuilder.workspaceVdbsUri(), vdbName);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, parentUri);
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.TRANSLATOR_NAME, "rest");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.ADD_TRANSLATORS_SEGMENT, "true");
        URI uri = _uriBuilder.vdbTranslatorUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbTranslator translator = (RestVdbTranslator)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbTranslator.class);
        Assert.assertNotNull((Object)translator);
        Assert.assertEquals((Object)KomodoType.VDB_TRANSLATOR, (Object)translator.getkType());
        Assert.assertEquals((Object)"ws", (Object)translator.getType());
        Assert.assertEquals((Object)"Rest Web Service translator", (Object)translator.getDescription());
        Collection links = translator.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbImports() throws Exception {
        this.loadVdbs();
        URI vdbBaseUri = _uriBuilder.workspaceVdbsUri();
        URI uri = _uriBuilder.vdbChildGroupUri(vdbBaseUri, "myVDB", RestLink.LinkType.IMPORTS);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbImport[] imports = (RestVdbImport[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbImport[].class);
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)1L, (long)imports.length);
        RestVdbImport vdbImport = imports[0];
        Assert.assertEquals((Object)KomodoType.VDB_IMPORT, (Object)vdbImport.getkType());
        Assert.assertEquals((Object)"x", (Object)vdbImport.getName());
        Assert.assertEquals((long)2L, (long)vdbImport.getVersion());
        Assert.assertEquals((Object)false, (Object)vdbImport.isImportDataPolicies());
        Collection links = vdbImport.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbImportsEmptyList() throws Exception {
        this.loadVdbs();
        URI vdbBaseUri = _uriBuilder.workspaceVdbsUri();
        URI uri = _uriBuilder.vdbChildGroupUri(vdbBaseUri, "Portfolio", RestLink.LinkType.IMPORTS);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbImport[] imports = (RestVdbImport[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbImport[].class);
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)0L, (long)imports.length);
    }

    @Test
    public void shouldGetVdbImport() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.IMPORT_NAME, "x");
        URI uri = _uriBuilder.vdbImportUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbImport vdbImport = (RestVdbImport)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbImport.class);
        Assert.assertNotNull((Object)vdbImport);
        Assert.assertEquals((Object)KomodoType.VDB_IMPORT, (Object)vdbImport.getkType());
        Assert.assertEquals((Object)"x", (Object)vdbImport.getName());
        Assert.assertEquals((long)2L, (long)vdbImport.getVersion());
        Assert.assertEquals((Object)false, (Object)vdbImport.isImportDataPolicies());
        Collection links = vdbImport.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldCreateDataRole() throws Exception {
        String permissionName;
        this.loadVdbs();
        String dataRoleName = "MyDataRole";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "Portfolio");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, dataRoleName);
        URI uri = _uriBuilder.vdbDataRoleUri(RestLink.LinkType.SELF, settings);
        boolean allowCreateTempTables = true;
        boolean anyAuthenticated = true;
        String dataPath = "/tko:komodo/tko:workspace/" + USER_NAME + "/" + "Portfolio" + "/" + "vdb:dataRoles" + "/" + dataRoleName;
        String description = "My data role description";
        boolean grantAll = true;
        Object[] mappedRoles = new String[]{"a", "b", "c", "d", "e"};
        KomodoType type = KomodoType.VDB_DATA_ROLE;
        String id = dataRoleName;
        String permissionId = permissionName = "MyPermission";
        KomodoType permissionType = KomodoType.VDB_PERMISSION;
        String permissionDataPath = dataPath + "/" + "vdb:permissions" + "/" + permissionName;
        boolean allowAlter = true;
        boolean allowCreate = false;
        boolean allowDelete = true;
        boolean allowExecute = false;
        boolean allowLanguage = true;
        boolean allowRead = false;
        boolean allowUpdate = true;
        RestVdbDataRole inDataRole = new RestVdbDataRole();
        inDataRole.setAllowCreateTempTables(allowCreateTempTables);
        inDataRole.setAnyAuthenticated(anyAuthenticated);
        inDataRole.setDataPath(dataPath);
        inDataRole.setDescription(description);
        inDataRole.setGrantAll(grantAll);
        inDataRole.setId(id);
        inDataRole.setkType(type);
        inDataRole.setMappedRoles((String[])mappedRoles);
        inDataRole.setName(dataRoleName);
        RestVdbPermission permission = new RestVdbPermission();
        permission.setName(permissionName);
        permission.setAllowAlter(allowAlter);
        permission.setAllowCreate(allowCreate);
        permission.setAllowDelete(allowDelete);
        permission.setAllowExecute(allowExecute);
        permission.setAllowLanguage(allowLanguage);
        permission.setAllowRead(allowRead);
        permission.setAllowUpdate(allowUpdate);
        permission.setId(permissionId);
        permission.setkType(permissionType);
        permission.setDataPath(permissionDataPath);
        inDataRole.setPermissions(new RestVdbPermission[]{permission});
        String json = KomodoJsonMarshaller.marshall((KRestEntity)inDataRole);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, json);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbDataRole outDataRole = (RestVdbDataRole)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbDataRole.class);
        Assert.assertNotNull((Object)outDataRole);
        Assert.assertThat((Object)outDataRole.isAllowCreateTempTables(), (Matcher)Is.is((Object)allowCreateTempTables));
        Assert.assertThat((Object)outDataRole.isAnyAuthenticated(), (Matcher)Is.is((Object)anyAuthenticated));
        Assert.assertThat((Object)outDataRole.getDataPath(), (Matcher)Is.is((Object)dataPath));
        Assert.assertThat((Object)outDataRole.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)outDataRole.isGrantAll(), (Matcher)Is.is((Object)grantAll));
        Assert.assertThat((Object)outDataRole.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)outDataRole.getkType(), (Matcher)Is.is((Object)type));
        Assert.assertThat((Object)Arrays.equals(outDataRole.getMappedRoles(), mappedRoles), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outDataRole.getName(), (Matcher)Is.is((Object)dataRoleName));
        Assert.assertThat((Object)outDataRole.getPermissions().length, (Matcher)Is.is((Object)1));
        RestVdbPermission outPermission = outDataRole.getPermissions()[0];
        Assert.assertThat((Object)outPermission.getName(), (Matcher)Is.is((Object)permissionName));
        Assert.assertThat((Object)outPermission.isAllowAlter(), (Matcher)Is.is((Object)allowAlter));
        Assert.assertThat((Object)outPermission.isAllowCreate(), (Matcher)Is.is((Object)allowCreate));
        Assert.assertThat((Object)outPermission.isAllowDelete(), (Matcher)Is.is((Object)allowDelete));
        Assert.assertThat((Object)outPermission.isAllowExecute(), (Matcher)Is.is((Object)allowExecute));
        Assert.assertThat((Object)outPermission.isAllowLanguage(), (Matcher)Is.is((Object)allowLanguage));
        Assert.assertThat((Object)outPermission.isAllowRead(), (Matcher)Is.is((Object)allowRead));
        Assert.assertThat((Object)outPermission.isAllowUpdate(), (Matcher)Is.is((Object)allowUpdate));
        HttpGet request2 = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response2 = this.executeOk((HttpUriRequest)request2);
        String entity2 = this.extractResponse(response2);
        RestVdbDataRole dataRole = (RestVdbDataRole)KomodoJsonMarshaller.unmarshall((String)entity2, RestVdbDataRole.class);
        Assert.assertNotNull((Object)dataRole);
        Assert.assertThat((Object)dataRole.isAllowCreateTempTables(), (Matcher)Is.is((Object)allowCreateTempTables));
        Assert.assertThat((Object)dataRole.isAnyAuthenticated(), (Matcher)Is.is((Object)anyAuthenticated));
        Assert.assertThat((Object)dataRole.getDataPath(), (Matcher)Is.is((Object)dataPath));
        Assert.assertThat((Object)dataRole.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)dataRole.isGrantAll(), (Matcher)Is.is((Object)grantAll));
        Assert.assertThat((Object)dataRole.getId(), (Matcher)Is.is((Object)id));
        Assert.assertThat((Object)dataRole.getkType(), (Matcher)Is.is((Object)type));
        Assert.assertThat((Object)Arrays.equals(dataRole.getMappedRoles(), mappedRoles), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dataRole.getName(), (Matcher)Is.is((Object)dataRoleName));
        Assert.assertThat((Object)dataRole.getPermissions().length, (Matcher)Is.is((Object)1));
        Collection links = dataRole.getLinks();
        Assert.assertEquals((long)4L, (long)links.size());
    }

    @Test
    public void shouldDeleteDataRole() throws Exception {
        this.loadVdbs();
        String dataRoleName = "MyDataRole";
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "Portfolio");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, dataRoleName);
        URI uri = _uriBuilder.vdbDataRoleUri(RestLink.LinkType.SELF, settings);
        boolean allowCreateTempTables = true;
        boolean anyAuthenticated = true;
        String dataPath = "/tko:komodo/tko:workspace/" + USER_NAME + "/" + "Portfolio" + "/" + "vdb:dataRoles" + "/" + dataRoleName;
        String description = "My data role description";
        boolean grantAll = true;
        String[] mappedRoles = new String[]{"a", "b", "c", "d", "e"};
        KomodoType type = KomodoType.VDB_DATA_ROLE;
        String id = dataRoleName;
        RestVdbDataRole dataRole = new RestVdbDataRole();
        dataRole.setAllowCreateTempTables(allowCreateTempTables);
        dataRole.setAnyAuthenticated(anyAuthenticated);
        dataRole.setDataPath(dataPath);
        dataRole.setDescription(description);
        dataRole.setGrantAll(grantAll);
        dataRole.setId(id);
        dataRole.setkType(type);
        dataRole.setMappedRoles(mappedRoles);
        dataRole.setName(dataRoleName);
        String json = KomodoJsonMarshaller.marshall((KRestEntity)dataRole);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, json);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        this.extractResponse(response);
        HttpDelete request2 = (HttpDelete)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.DELETE);
        this.executeOk((HttpUriRequest)request2);
        request2 = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response2 = this.execute((HttpUriRequest)request2);
        this.assertResponse(response2, 404);
    }

    @Test
    public void shouldGetVdbDataRoles() throws Exception {
        this.loadVdbs();
        URI vdbBaseUri = _uriBuilder.workspaceVdbsUri();
        URI uri = _uriBuilder.vdbChildGroupUri(vdbBaseUri, "myVDB", RestLink.LinkType.DATA_ROLES);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbDataRole[] dataRoles = (RestVdbDataRole[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbDataRole[].class);
        Assert.assertNotNull((Object)dataRoles);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        RestVdbDataRole dataRole = dataRoles[0];
        Assert.assertEquals((Object)KomodoType.VDB_DATA_ROLE, (Object)dataRole.getkType());
        Assert.assertEquals((Object)"roleOne", (Object)dataRole.getName());
        Assert.assertEquals((Object)"roleOne described", (Object)dataRole.getDescription());
        Assert.assertEquals((Object)true, (Object)dataRole.isAllowCreateTempTables());
        Assert.assertEquals((Object)false, (Object)dataRole.isAnyAuthenticated());
        Assert.assertEquals((Object)true, (Object)dataRole.isGrantAll());
        Assert.assertEquals((long)2L, (long)dataRole.getMappedRoles().length);
        Assert.assertTrue((dataRole.getMappedRoles()[0].equals("ROLE1") || dataRole.getMappedRoles()[0].equals("ROLE2") ? 1 : 0) != 0);
        Assert.assertTrue((dataRole.getMappedRoles()[1].equals("ROLE1") || dataRole.getMappedRoles()[1].equals("ROLE2") ? 1 : 0) != 0);
        Collection links = dataRole.getLinks();
        Assert.assertEquals((long)4L, (long)links.size());
    }

    @Test
    public void shouldGetVdbDataRolesEmptyList() throws Exception {
        this.loadVdbs();
        URI vdbBaseUri = _uriBuilder.workspaceVdbsUri();
        URI uri = _uriBuilder.vdbChildGroupUri(vdbBaseUri, "Portfolio", RestLink.LinkType.DATA_ROLES);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestBasicEntity[] dataRoles = (RestBasicEntity[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestBasicEntity[].class);
        Assert.assertNotNull((Object)dataRoles);
        Assert.assertEquals((long)0L, (long)dataRoles.length);
    }

    @Test
    public void shouldGetVdbDataRole() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, "roleOne");
        URI uri = _uriBuilder.vdbDataRoleUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbDataRole dataRole = (RestVdbDataRole)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbDataRole.class);
        Assert.assertNotNull((Object)dataRole);
        Assert.assertEquals((Object)KomodoType.VDB_DATA_ROLE, (Object)dataRole.getkType());
        Assert.assertEquals((Object)"roleOne", (Object)dataRole.getName());
        Assert.assertEquals((Object)"roleOne described", (Object)dataRole.getDescription());
        Assert.assertEquals((Object)true, (Object)dataRole.isAllowCreateTempTables());
        Assert.assertEquals((Object)false, (Object)dataRole.isAnyAuthenticated());
        Assert.assertEquals((Object)true, (Object)dataRole.isGrantAll());
        Assert.assertEquals((long)2L, (long)dataRole.getMappedRoles().length);
        Assert.assertTrue((dataRole.getMappedRoles()[0].equals("ROLE1") || dataRole.getMappedRoles()[0].equals("ROLE2") ? 1 : 0) != 0);
        Assert.assertTrue((dataRole.getMappedRoles()[1].equals("ROLE1") || dataRole.getMappedRoles()[1].equals("ROLE2") ? 1 : 0) != 0);
        Collection links = dataRole.getLinks();
        Assert.assertEquals((long)4L, (long)links.size());
    }

    @Test
    public void shouldGetVdbPermissions() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, "roleOne");
        URI uri = _uriBuilder.vdbDataRoleUri(RestLink.LinkType.PERMISSIONS, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbPermission[] permissions = (RestVdbPermission[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbPermission[].class);
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((long)4L, (long)permissions.length);
        for (RestVdbPermission permission : permissions) {
            Assert.assertEquals((Object)KomodoType.VDB_PERMISSION, (Object)permission.getkType());
            Collection links = permission.getLinks();
            Assert.assertEquals((long)5L, (long)links.size());
            if (permission.getId().equals("myTable.T1")) {
                Assert.assertFalse((boolean)permission.hasChildren());
                Assert.assertFalse((boolean)permission.isAllowAlter());
                Assert.assertFalse((boolean)permission.isAllowCreate());
                Assert.assertFalse((boolean)permission.isAllowDelete());
                Assert.assertFalse((boolean)permission.isAllowExecute());
                Assert.assertFalse((boolean)permission.isAllowLanguage());
                Assert.assertTrue((boolean)permission.isAllowRead());
                Assert.assertFalse((boolean)permission.isAllowUpdate());
                continue;
            }
            if (permission.getId().equals("myTable.T2")) {
                Assert.assertTrue((boolean)permission.hasChildren());
                Assert.assertTrue((boolean)permission.isAllowAlter());
                Assert.assertTrue((boolean)permission.isAllowCreate());
                Assert.assertTrue((boolean)permission.isAllowDelete());
                Assert.assertTrue((boolean)permission.isAllowExecute());
                Assert.assertFalse((boolean)permission.isAllowLanguage());
                Assert.assertFalse((boolean)permission.isAllowRead());
                Assert.assertTrue((boolean)permission.isAllowUpdate());
                continue;
            }
            if (permission.getId().equals("myTable.T2.col1")) {
                Assert.assertTrue((boolean)permission.hasChildren());
                Assert.assertFalse((boolean)permission.isAllowAlter());
                Assert.assertFalse((boolean)permission.isAllowCreate());
                Assert.assertFalse((boolean)permission.isAllowDelete());
                Assert.assertFalse((boolean)permission.isAllowExecute());
                Assert.assertFalse((boolean)permission.isAllowLanguage());
                Assert.assertFalse((boolean)permission.isAllowRead());
                Assert.assertFalse((boolean)permission.isAllowUpdate());
                continue;
            }
            if (!permission.getId().equals("javascript")) continue;
            Assert.assertFalse((boolean)permission.hasChildren());
            Assert.assertFalse((boolean)permission.isAllowAlter());
            Assert.assertFalse((boolean)permission.isAllowCreate());
            Assert.assertFalse((boolean)permission.isAllowDelete());
            Assert.assertFalse((boolean)permission.isAllowExecute());
            Assert.assertTrue((boolean)permission.isAllowLanguage());
            Assert.assertFalse((boolean)permission.isAllowRead());
            Assert.assertFalse((boolean)permission.isAllowUpdate());
        }
    }

    @Test
    public void shouldGetVdbPermission() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, "roleOne");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, "myTable.T1");
        URI uri = _uriBuilder.vdbPermissionUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbPermission permission = (RestVdbPermission)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbPermission.class);
        Assert.assertNotNull((Object)permission);
        Assert.assertEquals((Object)KomodoType.VDB_PERMISSION, (Object)permission.getkType());
        Assert.assertEquals((Object)"myTable.T1", (Object)permission.getId());
        Assert.assertFalse((boolean)permission.hasChildren());
        Assert.assertFalse((boolean)permission.isAllowAlter());
        Assert.assertFalse((boolean)permission.isAllowCreate());
        Assert.assertFalse((boolean)permission.isAllowDelete());
        Assert.assertFalse((boolean)permission.isAllowExecute());
        Assert.assertFalse((boolean)permission.isAllowLanguage());
        Assert.assertTrue((boolean)permission.isAllowRead());
        Assert.assertFalse((boolean)permission.isAllowUpdate());
        Collection links = permission.getLinks();
        Assert.assertEquals((long)5L, (long)links.size());
    }

    @Test
    public void shouldGetVdbConditions() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, "roleOne");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, "myTable.T2");
        URI uri = _uriBuilder.vdbPermissionUri(RestLink.LinkType.CONDITIONS, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbCondition[] conditions = (RestVdbCondition[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbCondition[].class);
        Assert.assertNotNull((Object)conditions);
        Assert.assertEquals((long)1L, (long)conditions.length);
        RestVdbCondition condition = conditions[0];
        Assert.assertEquals((Object)"col1 = user()", (Object)condition.getName());
        Assert.assertFalse((boolean)condition.isConstraint());
        Collection links = condition.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbCondition() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, "roleOne");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, "myTable.T2");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_TYPE, RestLink.LinkType.CONDITIONS.uriName());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_ID, "col1 = user()");
        URI uri = _uriBuilder.vdbPermissionChildUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbCondition condition = (RestVdbCondition)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbCondition.class);
        Assert.assertNotNull((Object)condition);
        Assert.assertEquals((Object)"col1 = user()", (Object)condition.getName());
        Assert.assertFalse((boolean)condition.isConstraint());
        Collection links = condition.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbMasks() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, "roleOne");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, "myTable.T2.col1");
        URI uri = _uriBuilder.vdbPermissionUri(RestLink.LinkType.MASKS, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbMask[] masks = (RestVdbMask[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestVdbMask[].class);
        Assert.assertNotNull((Object)masks);
        Assert.assertEquals((long)1L, (long)masks.length);
        RestVdbMask mask = masks[0];
        Assert.assertEquals((Object)"col2", (Object)mask.getName());
        Assert.assertEquals((Object)"1", (Object)mask.getOrder());
        Collection links = mask.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldGetVdbMask() throws Exception {
        this.loadVdbs();
        Properties settings = _uriBuilder.createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, "myVDB");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, _uriBuilder.workspaceVdbsUri());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, "roleOne");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, "myTable.T2.col1");
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_TYPE, RestLink.LinkType.MASKS.uriName());
        _uriBuilder.addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_ID, "col2");
        URI uri = _uriBuilder.vdbPermissionChildUri(RestLink.LinkType.SELF, settings);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestVdbMask mask = (RestVdbMask)KomodoJsonMarshaller.unmarshall((String)entity, RestVdbMask.class);
        Assert.assertNotNull((Object)mask);
        Assert.assertEquals((Object)"col2", (Object)mask.getName());
        Assert.assertEquals((Object)"1", (Object)mask.getOrder());
        Collection links = mask.getLinks();
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void shouldFailNameValidationWhenNameAlreadyExists() throws Exception {
        _restApp.importVdb(TestUtilities.partsExample(), USER_NAME);
        URI vdbUri = _uriBuilder.workspaceVdbsUri();
        URI uri = UriBuilder.fromUri((URI)vdbUri).path("nameValidation").path("MyPartsVDB_Dynamic").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        this.extractResponse(response);
    }

    @Test
    public void shouldFailNameValidationWhenConnectionWithSameNameExists() throws Exception {
        String sourceName = "elvis";
        _restApp.createConnection(sourceName, USER_NAME);
        URI vdbUri = _uriBuilder.workspaceVdbsUri();
        URI uri = UriBuilder.fromUri((URI)vdbUri).path("nameValidation").path(sourceName).build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        this.extractResponse(response);
    }

    @Test
    public void shouldFailNameValidationWhenNameHasInvalidCharacters() throws Exception {
        URI vdbUri = _uriBuilder.workspaceVdbsUri();
        URI uri = UriBuilder.fromUri((URI)vdbUri).path("nameValidation").path("InvalidN@me").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        this.extractResponse(response);
    }

    @Test
    public void shouldFailNameValidationWhenNameIsEmpty() throws Exception {
        URI vdbUri = _uriBuilder.workspaceConnectionsUri();
        URI uri = UriBuilder.fromUri((URI)vdbUri).path("nameValidation").path("").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 500);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)StringStartsWith.startsWith((String)"RESTEASY"));
    }

    @Test
    public void shouldFailNameValidationWhenNameHasSpaces() throws Exception {
        URI vdbUri = _uriBuilder.workspaceVdbsUri();
        URI uri = UriBuilder.fromUri((URI)vdbUri).path("nameValidation").path("a b c").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldFailNameValidationWhenMissingNameSegment() throws Exception {
        URI vdbUri = _uriBuilder.workspaceVdbsUri();
        URI uri = UriBuilder.fromUri((URI)vdbUri).path("nameValidation").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.execute((HttpUriRequest)request);
        this.assertResponse(response, 500);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)StringStartsWith.startsWith((String)"RESTEASY"));
    }

    @Test
    public void shouldValidateName() throws Exception {
        URI vdbUri = _uriBuilder.workspaceVdbsUri();
        URI uri = UriBuilder.fromUri((URI)vdbUri).path("nameValidation").path("ValidName").build(new Object[0]);
        HttpGet request = (HttpGet)this.request(uri, AbstractFrameworkTest.RequestType.GET, MediaType.TEXT_PLAIN_TYPE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String errorMsg = this.extractResponse(response);
        Assert.assertThat((Object)errorMsg, (Matcher)Is.is((Object)""));
    }
}

