/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service.integration;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.komodo.core.repository.RepositoryImpl;
import org.komodo.importer.ImportOptions;
import org.komodo.metadata.TeiidConnectionProvider;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.TeiidSwarmConnectionProvider;
import org.komodo.rest.TeiidSwarmMetadataInstance;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoPathAttribute;
import org.komodo.rest.relational.request.KomodoQueryAttribute;
import org.komodo.rest.relational.response.ImportExportStatus;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.rest.relational.response.KomodoStorageAttributes;
import org.komodo.rest.relational.response.RestQueryResult;
import org.komodo.rest.relational.response.RestQueryRow;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.spi.metadata.MetadataInstance;
import org.komodo.spi.repository.DocumentType;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.test.utils.TestUtilities;
import org.komodo.utils.FileUtils;

public abstract class AbstractKomodoMetadataServiceTest
extends AbstractFrameworkTest {
    protected static String MYSQL_DRIVER = "mysql-connector";
    private int testIndex = 0;
    private TeiidSwarmMetadataInstance instance;

    @Deployment(testable=false)
    public static WebArchive createRestDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/vdb-builder.war"));
    }

    @BeforeClass
    public static void beforeAllSetupBaseUri() throws Exception {
        System.setProperty("org.jboss.resteasy.port", Integer.toString(TEST_PORT));
        URI baseUri = URI.create("http://localhost:" + TEST_PORT);
        baseUri = UriBuilder.fromUri((URI)baseUri).scheme("http").path("/vdb-builder/v1").build(new Object[0]);
        _uriBuilder = new KomodoRestUriBuilder(baseUri);
    }

    protected void assertNoMysqlDriver() throws Exception {
        this.wait(2);
        Collection drivers = this.getMetadataInstance().getDataSourceDrivers();
        for (ConnectionDriver driver : drivers) {
            Assert.assertFalse((boolean)driver.getName().startsWith(MYSQL_DRIVER));
        }
    }

    protected void assertMysqlDriver() throws Exception {
        boolean found = false;
        block0: for (int i = 0; i < 10 && !found; ++i) {
            this.wait(3);
            Collection drivers = this.getMetadataInstance().getDataSourceDrivers();
            for (ConnectionDriver driver : drivers) {
                if (!driver.getName().startsWith(MYSQL_DRIVER)) continue;
                found = true;
                continue block0;
            }
        }
        Assert.assertTrue((String)"Cannot find deployed driver", (boolean)found);
    }

    protected MetadataInstance getMetadataInstance() throws Exception {
        if (this.instance == null) {
            TeiidSwarmConnectionProvider connectionProvider = new TeiidSwarmConnectionProvider();
            this.instance = new TeiidSwarmMetadataInstance((TeiidConnectionProvider)connectionProvider);
        }
        return this.instance;
    }

    protected void waitForVdb() throws Exception {
        Thread.sleep(20L);
    }

    protected void wait(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void undeployDrivers() throws Exception {
        HashSet<String> undeployDrivers = new HashSet<String>();
        Collection drivers = this.getMetadataInstance().getDataSourceDrivers();
        for (ConnectionDriver connectionDriver : drivers) {
            if (!connectionDriver.getName().startsWith(MYSQL_DRIVER)) continue;
            String driverName = connectionDriver.getName();
            int endsWithClass = driverName.lastIndexOf("jar_");
            if (endsWithClass > -1) {
                driverName = driverName.substring(0, endsWithClass + "jar".length());
            }
            undeployDrivers.add(driverName);
        }
        for (String string : undeployDrivers) {
            try {
                this.getMetadataInstance().undeployDataSourceDriver(string);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void undeployVdbs() throws Exception {
        this.deleteSample();
    }

    private void undeployDataSources() throws Exception {
        MetadataInstance teiidInstance = this.getMetadataInstance();
        for (TeiidDataSource ds : teiidInstance.getDataSources()) {
            if (ds.getName().contains("Example")) continue;
            this.getMetadataInstance().deleteDataSource(ds.getName());
        }
    }

    protected void deleteSample() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("workspace").path("vdbs").path("sample").build(new Object[0]);
        Object request = this.jsonRequest(uri, AbstractFrameworkTest.RequestType.DELETE);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.execute((HttpUriRequest)request);
    }

    protected void loadSample() throws Exception {
        this.deleteSample();
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setDocumentType(DocumentType.VDB_XML);
        storageAttr.setParameter("import-overwrite-property", ImportOptions.ExistingNodeOptions.OVERWRITE.name());
        String sampleCnt = FileUtils.streamToString((InputStream)TestUtilities.sampleExample());
        String content = Base64.getEncoder().encodeToString(sampleCnt.getBytes());
        storageAttr.setContent(content);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        ImportExportStatus status = (ImportExportStatus)KomodoJsonMarshaller.unmarshall((String)entity, ImportExportStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isSuccess());
        Assert.assertFalse((boolean)status.hasDownloadable());
        Assert.assertEquals((Object)"-vdb.xml", (Object)status.getType());
        String samplePath = "/tko:komodo/tko:workspace/" + USER_NAME + "/sample";
        KomodoPathAttribute pathAttribute = new KomodoPathAttribute();
        pathAttribute.setPath(samplePath);
        uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("vdb").build(new Object[0]);
        request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addJsonConsumeContentType((HttpUriRequest)request);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)pathAttribute);
        response = this.executeOk((HttpUriRequest)request);
    }

    @Before
    public void beforeEach() throws Exception {
        ++this.testIndex;
        this.loadSample();
        this.waitForVdb();
    }

    protected abstract int getTestTotalInClass();

    @After
    public void afterEach() throws Exception {
        if (this.testIndex == this.getTestTotalInClass()) {
            try {
                this.undeployVdbs();
                this.undeployDataSources();
                this.undeployDrivers();
                this.wait(2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void importDataService() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("importexport").path("import").build(new Object[0]);
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        storageAttr.setStorageType("file");
        storageAttr.setDocumentType(DocumentType.ZIP);
        InputStream usStatesDSStream = TestUtilities.usStatesDataserviceExample();
        byte[] sampleBytes = TestUtilities.streamToBytes((InputStream)usStatesDSStream);
        String content = Base64.getEncoder().encodeToString(sampleBytes);
        storageAttr.setContent(content);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)storageAttr);
        this.executeOk((HttpUriRequest)request);
    }

    protected void deployDataService() throws Exception {
        KomodoPathAttribute pathAttr = new KomodoPathAttribute();
        String path = RepositoryImpl.komodoWorkspacePath(null) + "/" + USER_NAME + "/" + "UsStatesService";
        pathAttr.setPath(path);
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("dataservice").build(new Object[0]);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)pathAttr);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        KomodoStatusObject status = (KomodoStatusObject)KomodoJsonMarshaller.unmarshall((String)entity, KomodoStatusObject.class);
        Assert.assertNotNull((Object)status);
        Map attributes = status.getAttributes();
        for (Map.Entry attribute : attributes.entrySet()) {
            Assert.assertFalse((String)("Error occurred in deployment: " + (String)attribute.getValue()), (boolean)((String)attribute.getKey()).startsWith("ErrorMessage"));
        }
    }

    protected void queryDataService(KomodoQueryAttribute queryAttr, int expRowCount, int firstCellValue) throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("query").build(new Object[0]);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)queryAttr);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestQueryResult result = (RestQueryResult)KomodoJsonMarshaller.unmarshall((String)entity, RestQueryResult.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)expRowCount, (long)result.getRows().length);
        RestQueryRow firstRow = result.getRows()[0];
        String value = firstRow.getValues()[0];
        Assert.assertEquals((Object)new Integer(firstCellValue).toString(), (Object)value);
    }
}

