/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service.integration;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Base64;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoFileAttributes;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.integration.AbstractKomodoMetadataServiceTest;
import org.komodo.spi.constants.StringConstants;
import org.komodo.test.utils.TestUtilities;
import org.komodo.utils.FileUtils;

@RunWith(value=Arquillian.class)
public class IT_KomodoMetadataServiceDriverTests
extends AbstractKomodoMetadataServiceTest
implements StringConstants {
    @Override
    protected int getTestTotalInClass() {
        return 2;
    }

    @Test
    public void shouldDeployDriver() throws Exception {
        this.undeployDrivers();
        this.assertNoMysqlDriver();
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("driver").build(new Object[0]);
        KomodoFileAttributes fileAttr = new KomodoFileAttributes();
        fileAttr.setName(MYSQL_DRIVER);
        InputStream driverStream = TestUtilities.mySqlDriver();
        Assert.assertNotNull((Object)driverStream);
        byte[] driverBytes = TestUtilities.streamToBytes((InputStream)driverStream);
        String content = Base64.getEncoder().encodeToString(driverBytes);
        fileAttr.setContent(content);
        HttpPost request = (HttpPost)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.POST);
        this.addBody((HttpEntityEnclosingRequestBase)request, (KRestEntity)fileAttr);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        KomodoStatusObject status = (KomodoStatusObject)KomodoJsonMarshaller.unmarshall((String)entity, KomodoStatusObject.class);
        Assert.assertNotNull((Object)status);
        String title = RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
        Assert.assertEquals((Object)title, (Object)status.getTitle());
        Map attributes = status.getAttributes();
        Assert.assertFalse((boolean)attributes.isEmpty());
        String deployMsg = RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_SUCCESSFULLY_DEPLOYED, (Object[])new Object[0]);
        boolean foundValue = false;
        for (String value : attributes.values()) {
            if (!deployMsg.equals(value)) continue;
            foundValue = true;
            break;
        }
        Assert.assertTrue((boolean)foundValue);
        this.assertMysqlDriver();
    }

    @Test
    public void shouldUndeployDriver() throws Exception {
        InputStream driverStream = TestUtilities.mySqlDriver();
        Assert.assertNotNull((Object)driverStream);
        byte[] driverBytes = TestUtilities.streamToBytes((InputStream)driverStream);
        File driverFile = File.createTempFile(MYSQL_DRIVER, ".jar");
        FileUtils.write((byte[])driverBytes, (File)driverFile);
        this.getMetadataInstance().deployDataSourceDriver(MYSQL_DRIVER, driverFile);
        this.assertMysqlDriver();
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("driver").path(MYSQL_DRIVER).build(new Object[0]);
        HttpDelete request = (HttpDelete)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.DELETE);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        KomodoStatusObject status = (KomodoStatusObject)KomodoJsonMarshaller.unmarshall((String)entity, KomodoStatusObject.class);
        Assert.assertNotNull((Object)status);
        this.wait(4);
        this.getMetadataInstance().refresh();
        String title = RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
        Assert.assertEquals((Object)title, (Object)status.getTitle());
        Map attributes = status.getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
        String deployMsg = RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_SUCCESSFULLY_UNDEPLOYED, (Object[])new Object[0]);
        Assert.assertEquals((Object)deployMsg, attributes.values().iterator().next());
        this.assertNoMysqlDriver();
    }
}

