/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service.integration;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.metadata.RestMetadataConnection;
import org.komodo.rest.relational.response.metadata.RestMetadataStatus;
import org.komodo.rest.relational.response.metadata.RestMetadataTemplate;
import org.komodo.rest.relational.response.metadata.RestMetadataTemplateEntry;
import org.komodo.rest.relational.response.metadata.RestMetadataVdb;
import org.komodo.rest.relational.response.metadata.RestMetadataVdbStatus;
import org.komodo.rest.relational.response.metadata.RestMetadataVdbStatusVdb;
import org.komodo.rest.relational.response.metadata.RestMetadataVdbTranslator;
import org.komodo.rest.service.AbstractFrameworkTest;
import org.komodo.rest.service.integration.AbstractKomodoMetadataServiceTest;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.repository.KomodoType;

@RunWith(value=Arquillian.class)
public class IT_KomodoMetadataServiceGetTests
extends AbstractKomodoMetadataServiceTest
implements StringConstants {
    private void testTranslators(RestMetadataStatus status) throws Exception {
        Assert.assertEquals((long)this.getMetadataInstance().getTranslators().size(), (long)status.getTranslatorSize());
    }

    @Override
    protected int getTestTotalInClass() {
        return 12;
    }

    @Test
    public void shouldLoadSampleVdb() throws Exception {
        this.loadSample();
    }

    @Test
    public void shouldReturnSwaggerSpec() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("swagger.json").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        Assert.assertTrue((boolean)entity.contains("\"swagger\""));
        Assert.assertTrue((boolean)entity.contains("\"/service/about\""));
        Assert.assertTrue((boolean)entity.contains("\"/service/samples\""));
        Assert.assertTrue((boolean)entity.contains("\"/service/schema\""));
        Assert.assertTrue((boolean)entity.contains("\"/workspace/vdbs\""));
        Assert.assertTrue((boolean)entity.contains("\"/workspace/vdbs/{vdbName}\""));
        Assert.assertTrue((boolean)entity.contains("\"keng__id\""));
        Assert.assertTrue((boolean)entity.contains("\"keng__kType\""));
    }

    @Test
    public void shouldGetTeiidStatus() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("status").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataStatus status = (RestMetadataStatus)KomodoJsonMarshaller.unmarshall((String)entity, RestMetadataStatus.class);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isAvailable());
        Assert.assertEquals((long)this.getMetadataInstance().getDataSources().size(), (long)status.getDataSourceSize());
        Assert.assertEquals((long)this.getMetadataInstance().getDataSourceDrivers().size(), (long)status.getDataSourceDriverSize());
        this.testTranslators(status);
        Assert.assertEquals((long)this.getMetadataInstance().getVdbs().size(), (long)status.getVdbSize());
    }

    @Test
    public void shouldGetTeiidVdbStatus() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("status").path("vdbs").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataVdbStatus status = (RestMetadataVdbStatus)KomodoJsonMarshaller.unmarshall((String)entity, RestMetadataVdbStatus.class);
        Assert.assertNotNull((Object)status);
        List vdbProperties = status.getVdbProperties();
        Assert.assertTrue((vdbProperties.size() > 0 ? 1 : 0) != 0);
        RestMetadataVdbStatusVdb vdb = (RestMetadataVdbStatusVdb)vdbProperties.get(0);
        Assert.assertNotNull((Object)vdb);
        Assert.assertEquals((Object)"sample", (Object)vdb.getName());
        Assert.assertEquals((Object)"1", (Object)vdb.getVersion());
    }

    @Test
    public void shouldGetVdbs() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("vdbs").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataVdb[] vdbs = (RestMetadataVdb[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestMetadataVdb[].class);
        Assert.assertFalse((vdbs.length == 0 ? 1 : 0) != 0);
        RestMetadataVdb vdb = vdbs[0];
        String vdbName = "sample";
        Assert.assertNotNull((String)vdbName, (Object)vdb.getId());
        Assert.assertEquals((Object)(_uriBuilder.baseUri() + "/"), (Object)vdb.getBaseUri().toString());
        Assert.assertEquals((Object)KomodoType.VDB, (Object)vdb.getkType());
        Assert.assertTrue((boolean)vdb.hasChildren());
        Assert.assertEquals((Object)vdbName, (Object)vdb.getName());
        for (RestLink link : vdb.getLinks()) {
            switch (link.getRel()) {
                case SELF: {
                    Assert.assertEquals((Object)(_uriBuilder.baseUri() + "/" + "metadata" + "/" + "vdbs" + "/" + vdbName), (Object)link.getHref().toString());
                    break;
                }
                case PARENT: {
                    Assert.assertEquals((Object)(_uriBuilder.baseUri() + "/" + "metadata" + "/" + "vdbs"), (Object)link.getHref().toString());
                }
            }
        }
    }

    @Test
    public void shouldGetVdb() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("vdbs").path("sample").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataVdb vdb = (RestMetadataVdb)KomodoJsonMarshaller.unmarshall((String)entity, RestMetadataVdb.class);
        Assert.assertNotNull((Object)vdb);
        String vdbName = "sample";
        Assert.assertNotNull((String)vdbName, (Object)vdb.getId());
        Assert.assertEquals((Object)(_uriBuilder.baseUri() + "/"), (Object)vdb.getBaseUri().toString());
        Assert.assertEquals((Object)KomodoType.VDB, (Object)vdb.getkType());
        Assert.assertTrue((boolean)vdb.hasChildren());
        Assert.assertEquals((Object)vdbName, (Object)vdb.getName());
        for (RestLink link : vdb.getLinks()) {
            switch (link.getRel()) {
                case SELF: {
                    Assert.assertEquals((Object)(_uriBuilder.baseUri() + "/" + "metadata" + "/" + "vdbs" + "/" + vdbName), (Object)link.getHref().toString());
                    break;
                }
                case PARENT: {
                    Assert.assertEquals((Object)(_uriBuilder.baseUri() + "/" + "metadata" + "/" + "vdbs"), (Object)link.getHref().toString());
                }
            }
        }
    }

    @Test
    public void shouldGetTeiidStatusMultiQueries() throws Exception {
        final URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("status").build(new Object[0]);
        int iterations = 3;
        final CountDownLatch latch = new CountDownLatch(iterations);
        final ArrayList assertionFailures = new ArrayList();
        for (int i = 0; i < iterations; ++i) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HttpGet request = (HttpGet)IT_KomodoMetadataServiceGetTests.this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
                        HttpResponse response = IT_KomodoMetadataServiceGetTests.this.execute((HttpUriRequest)request);
                        Thread.yield();
                        IT_KomodoMetadataServiceGetTests.this.okResponse(response);
                        String entity = IT_KomodoMetadataServiceGetTests.this.extractResponse(response);
                        RestMetadataStatus status = (RestMetadataStatus)KomodoJsonMarshaller.unmarshall((String)entity, RestMetadataStatus.class);
                        Assert.assertNotNull((Object)status);
                        Assert.assertTrue((boolean)status.isAvailable());
                        Assert.assertEquals((long)IT_KomodoMetadataServiceGetTests.this.getMetadataInstance().getDataSources().size(), (long)status.getDataSourceSize());
                        Assert.assertEquals((long)IT_KomodoMetadataServiceGetTests.this.getMetadataInstance().getDataSourceDrivers().size(), (long)status.getDataSourceDriverSize());
                        IT_KomodoMetadataServiceGetTests.this.testTranslators(status);
                        Assert.assertEquals((long)IT_KomodoMetadataServiceGetTests.this.getMetadataInstance().getVdbs().size(), (long)status.getVdbSize());
                    }
                    catch (Throwable ex) {
                        assertionFailures.add(ex);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
        Assert.assertTrue((boolean)latch.await(3L, TimeUnit.MINUTES));
        for (Throwable t : assertionFailures) {
            t.printStackTrace();
        }
        Assert.assertTrue((boolean)assertionFailures.isEmpty());
    }

    @Test
    public void shouldGetTranslators() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("VdbTranslators").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataVdbTranslator[] translators = (RestMetadataVdbTranslator[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestMetadataVdbTranslator[].class);
        Assert.assertTrue((translators.length > 0 ? 1 : 0) != 0);
        for (RestMetadataVdbTranslator translator : translators) {
            Assert.assertNotNull((Object)translator.getId());
            Assert.assertEquals((long)2L, (long)translator.getLinks().size());
        }
    }

    @Test
    public void shouldGetConnections() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("connections").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataConnection[] connections = (RestMetadataConnection[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestMetadataConnection[].class);
        Assert.assertNotNull((Object)connections);
    }

    @Test
    public void shouldGetConnectionTemplates() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("templates").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataTemplate[] templates = (RestMetadataTemplate[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestMetadataTemplate[].class);
        Assert.assertTrue((templates.length > 0 ? 1 : 0) != 0);
        for (RestMetadataTemplate template : templates) {
            Assert.assertNotNull((Object)template.getId());
            Assert.assertFalse((boolean)template.getEntries().isEmpty());
            Assert.assertEquals((long)3L, (long)template.getLinks().size());
        }
    }

    @Test
    public void shouldGetConnectionTemplate() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("templates").path("teiid").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataTemplate template = (RestMetadataTemplate)KomodoJsonMarshaller.unmarshall((String)entity, RestMetadataTemplate.class);
        Assert.assertNotNull((Object)template);
        Assert.assertNotNull((Object)template.getId());
        Assert.assertFalse((boolean)template.getEntries().isEmpty());
        Assert.assertEquals((long)3L, (long)template.getLinks().size());
    }

    @Test
    public void shouldGetConnectionTemplateEntries() throws Exception {
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("metadata").path("templates").path("teiid").path("entries").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        RestMetadataTemplateEntry[] templateEntries = (RestMetadataTemplateEntry[])KomodoJsonMarshaller.unmarshallArray((String)entity, RestMetadataTemplateEntry[].class);
        Assert.assertTrue((templateEntries.length > 0 ? 1 : 0) != 0);
        for (RestMetadataTemplateEntry entry : templateEntries) {
            Assert.assertNotNull((Object)entry.getId());
            Assert.assertEquals((long)2L, (long)entry.getLinks().size());
        }
    }

    @Test
    public void shouldAbout() throws Exception {
        String[] EXPECTED = new String[]{"\"Information\": {\n", "\"Repository Workspace\": \"komodoLocalWorkspace\",\n", "\"Repository Configuration\"", "\"Repository Vdb Total\":"};
        URI uri = UriBuilder.fromUri((URI)_uriBuilder.baseUri()).path("service").path("about").build(new Object[0]);
        HttpGet request = (HttpGet)this.jsonRequest(uri, AbstractFrameworkTest.RequestType.GET);
        this.addHeader((HttpUriRequest)request, "Origin", "http://localhost:2772");
        HttpResponse response = this.executeOk((HttpUriRequest)request);
        String entity = this.extractResponse(response);
        this.okResponse(response);
        for (String expected : EXPECTED) {
            Assert.assertTrue((String)(expected + " is not contained in " + entity), (boolean)entity.contains(expected));
        }
    }
}

