/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service.integration;

import org.jboss.arquillian.junit.Arquillian;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.komodo.core.repository.RepositoryImpl;
import org.komodo.rest.relational.request.KomodoQueryAttribute;
import org.komodo.rest.service.integration.AbstractKomodoMetadataServiceTest;
import org.komodo.spi.constants.StringConstants;

@RunWith(value=Arquillian.class)
public class IT_KomodoMetadataServiceQueryTests
extends AbstractKomodoMetadataServiceTest
implements StringConstants {
    @Override
    protected int getTestTotalInClass() {
        return 3;
    }

    @Before
    public void setup() throws Exception {
        this.importDataService();
        if (!this.getMetadataInstance().hasVdb("usstates")) {
            this.deployDataService();
        }
        this.waitForVdb();
    }

    @Test
    public void shouldQueryTeiid() throws Exception {
        KomodoQueryAttribute queryAttr = new KomodoQueryAttribute();
        queryAttr.setQuery("SELECT * FROM state");
        queryAttr.setTarget("usstates");
        this.queryDataService(queryAttr, 59, 1);
    }

    @Test
    public void shouldQueryTeiidWithLimitAndOffset() throws Exception {
        KomodoQueryAttribute queryAttr = new KomodoQueryAttribute();
        queryAttr.setQuery("SELECT * FROM state");
        queryAttr.setTarget("usstates");
        int offset = 5;
        int limit = 10;
        queryAttr.setLimit(limit);
        queryAttr.setOffset(offset);
        this.queryDataService(queryAttr, limit, offset);
    }

    @Test
    public void shouldQueryTeiidUsingDataservice() throws Exception {
        String dsPath = RepositoryImpl.komodoWorkspacePath(null) + "/" + USER_NAME + "/" + "UsStatesService";
        KomodoQueryAttribute queryAttr = new KomodoQueryAttribute();
        queryAttr.setQuery("SELECT * FROM state");
        queryAttr.setTarget(dsPath);
        this.queryDataService(queryAttr, 59, 1);
    }
}

