/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.utils.ArgCheck;

public abstract class AbstractKEntity
implements KRestEntity {
    private transient KomodoRestUriBuilder uriBuilder;
    protected Map<String, Object> tuples = new LinkedHashMap();
    protected List<RestProperty> properties = new ArrayList();
    protected Map<RestLink.LinkType, RestLink> links = RestLink.NO_LINKS;
    private transient String xml;

    public AbstractKEntity() {
        this.uriBuilder = null;
    }

    public boolean supports(MediaType mediaType) {
        return MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    public AbstractKEntity(URI baseUri) throws KException {
        ArgCheck.isNotNull((Object)baseUri, (String)"baseUri");
        this.setBaseUri(baseUri);
    }

    public Map<String, Object> getTuples() {
        return Collections.unmodifiableMap(this.tuples);
    }

    public void addTuple(String key, Object value) {
        this.tuples.put(key, value);
    }

    public URI getBaseUri() {
        Object uri = this.tuples.get("keng__baseUri");
        return uri != null ? UriBuilder.fromUri((String)uri.toString()).build(new Object[0]) : null;
    }

    public void setBaseUri(URI baseUri) {
        this.tuples.put("keng__baseUri", baseUri);
        this.uriBuilder = new KomodoRestUriBuilder(baseUri);
    }

    public KomodoRestUriBuilder getUriBuilder() {
        return this.uriBuilder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestBasicEntity other = (RestBasicEntity)obj;
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.tuples == null ? other.tuples != null : !this.tuples.equals(other.tuples));
    }

    public final Collection<RestLink> getLinks() {
        return this.links.values();
    }

    public final List<RestProperty> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.tuples == null ? 0 : this.tuples.hashCode());
        return result;
    }

    public final void addLink(RestLink newLink) {
        if (this.links == null || this.links == RestLink.NO_LINKS) {
            this.links = new LinkedHashMap();
        }
        this.links.put(newLink.getRel(), newLink);
    }

    public final void removeLink(RestLink.LinkType type) {
        if (this.links == null || this.links == RestLink.NO_LINKS) {
            return;
        }
        this.links.remove(type);
    }

    public final void setLinks(Collection<RestLink> newLinks) {
        if (newLinks == null) {
            this.links = RestLink.NO_LINKS;
        } else {
            for (RestLink link : newLinks) {
                this.addLink(link);
            }
        }
    }

    public final void addProperty(String name, Object value) {
        this.properties.add(new RestProperty(name, value));
    }

    public final void setProperties(List<RestProperty> newProperties) {
        this.properties.clear();
        if (newProperties != null && !newProperties.isEmpty()) {
            for (RestProperty property : newProperties) {
                ArgCheck.isNotNull((Object)property);
                this.properties.add(property);
            }
        }
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public void clone(AbstractKEntity instance) {
        instance.tuples = this.tuples;
        instance.properties = this.properties;
        instance.links = this.links;
        instance.uriBuilder = this.uriBuilder;
        instance.xml = this.xml;
    }

    public String toString() {
        return "AbstractKEntity [tuples=" + this.tuples + ", properties=" + this.properties + ", links=" + this.links + "]";
    }
}

