/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverters;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.komodo.core.KEngine;
import org.komodo.core.repository.LocalRepository;
import org.komodo.core.repository.SynchronousCallback;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.metadata.TeiidConnectionProvider;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.dataservice.internal.DataserviceConveyor;
import org.komodo.relational.importer.vdb.VdbImporter;
import org.komodo.relational.resource.Driver;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.KomodoExceptionMapper;
import org.komodo.rest.Messages;
import org.komodo.rest.TeiidSwarmConnectionProvider;
import org.komodo.rest.TeiidSwarmMetadataInstance;
import org.komodo.rest.cors.KCorsFactory;
import org.komodo.rest.cors.KCorsHandler;
import org.komodo.rest.service.KomodoConnectionService;
import org.komodo.rest.service.KomodoDataserviceService;
import org.komodo.rest.service.KomodoDriverService;
import org.komodo.rest.service.KomodoImportExportService;
import org.komodo.rest.service.KomodoMetadataService;
import org.komodo.rest.service.KomodoSearchService;
import org.komodo.rest.service.KomodoUtilService;
import org.komodo.rest.service.KomodoVdbService;
import org.komodo.rest.swagger.RestDataserviceConverter;
import org.komodo.rest.swagger.RestPropertyConverter;
import org.komodo.rest.swagger.RestVdbConditionConverter;
import org.komodo.rest.swagger.RestVdbConverter;
import org.komodo.rest.swagger.RestVdbDataRoleConverter;
import org.komodo.rest.swagger.RestVdbImportConverter;
import org.komodo.rest.swagger.RestVdbMaskConverter;
import org.komodo.rest.swagger.RestVdbModelConverter;
import org.komodo.rest.swagger.RestVdbModelSourceConverter;
import org.komodo.rest.swagger.RestVdbPermissionConverter;
import org.komodo.rest.swagger.RestVdbTranslatorConverter;
import org.komodo.spi.KClient;
import org.komodo.spi.KEvent;
import org.komodo.spi.KException;
import org.komodo.spi.KObserver;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.logging.KLogger;
import org.komodo.spi.metadata.MetadataInstance;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.repository.RepositoryClientEvent;
import org.komodo.utils.KLog;
import org.komodo.utils.observer.KLatchObserver;

@ApplicationPath(value="/v1")
public class KomodoRestV1Application
extends Application
implements StringConstants {
    private static final int TIMEOUT = 1;
    private static final TimeUnit UNIT = TimeUnit.MINUTES;
    private KEngine kengine;
    private final Set<Object> singletons;

    public KomodoRestV1Application() throws WebApplicationException {
        KCorsHandler corsHandler;
        try {
            String baseDir = System.getProperty("jboss.server.base.dir", ".") + File.separator;
            String komodoDataDir = System.getProperty("komodo.dataDir");
            if (komodoDataDir == null) {
                System.setProperty("komodo.dataDir", baseDir + "data");
            }
            KLog.getLogger().setLogPath(baseDir + "log/vdb-builder.log");
            KLog.getLogger().setLevel(KLogger.Level.INFO);
            corsHandler = this.initCorsHandler();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.kengine = this.start();
        HashSet<Object> objs = new HashSet<Object>();
        objs.add(new KomodoExceptionMapper());
        objs.add(new KomodoUtilService(this.kengine));
        objs.add(new KomodoDataserviceService(this.kengine));
        objs.add(new KomodoConnectionService(this.kengine));
        objs.add(new KomodoDriverService(this.kengine));
        objs.add(new KomodoVdbService(this.kengine));
        objs.add(new KomodoSearchService(this.kengine));
        objs.add(new KomodoMetadataService(this.kengine));
        objs.add(new KomodoImportExportService(this.kengine));
        objs.add(corsHandler);
        this.singletons = Collections.unmodifiableSet(objs);
        this.initSwaggerConfiguration();
    }

    private KCorsHandler initCorsHandler() throws Exception {
        KCorsHandler corsHandler = KCorsFactory.getInstance().createHandler();
        corsHandler.getAllowedOrigins().add("*");
        corsHandler.setAllowedHeaders("Content-Type, X-Requested-With, accept, Origin,Access-Control-Request-Method,Access-Control-Request-Headers, Authorization");
        corsHandler.setAllowCredentials(true);
        corsHandler.setAllowedMethods("GET, POST, PUT, DELETE, OPTIONS, HEAD");
        corsHandler.setCorsMaxAge(1209600);
        return corsHandler;
    }

    private void initSwaggerConfiguration() {
        ModelConverters converters = ModelConverters.getInstance();
        converters.addConverter((ModelConverter)new RestPropertyConverter());
        converters.addConverter((ModelConverter)new RestVdbConditionConverter());
        converters.addConverter((ModelConverter)new RestVdbConverter());
        converters.addConverter((ModelConverter)new RestVdbDataRoleConverter());
        converters.addConverter((ModelConverter)new RestVdbImportConverter());
        converters.addConverter((ModelConverter)new RestVdbMaskConverter());
        converters.addConverter((ModelConverter)new RestVdbModelConverter());
        converters.addConverter((ModelConverter)new RestVdbModelSourceConverter());
        converters.addConverter((ModelConverter)new RestVdbPermissionConverter());
        converters.addConverter((ModelConverter)new RestVdbTranslatorConverter());
        converters.addConverter((ModelConverter)new RestDataserviceConverter());
    }

    public Repository getDefaultRepository() throws KException {
        return this.kengine.getDefaultRepository();
    }

    public void clearRepository() throws WebApplicationException {
        try {
            RepositoryClientEvent event = RepositoryClientEvent.createClearEvent((KClient)this.kengine);
            this.kengine.getDefaultRepository().notify(event);
        }
        catch (KException e1) {
            throw new WebApplicationException((Throwable)new Exception(Messages.getString((Enum)Messages.Error.KOMODO_ENGINE_CLEAR_TIMEOUT, (Object[])new Object[]{1, UNIT})), Response.Status.INTERNAL_SERVER_ERROR);
        }
        KLatchObserver observer = new KLatchObserver(new KEvent.Type[]{KEvent.Type.REPOSITORY_CLEARED});
        this.kengine.addObserver((KObserver)observer);
        boolean cleared = false;
        try {
            cleared = observer.getLatch().await(1L, UNIT);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            this.kengine.removeObserver((KObserver)observer);
        }
        if (!cleared) {
            throw new WebApplicationException((Throwable)new Exception(Messages.getString((Enum)Messages.Error.KOMODO_ENGINE_CLEAR_TIMEOUT, (Object[])new Object[]{1, UNIT})), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public Set<Class<?>> getClasses() {
        HashSet resources = new HashSet();
        try {
            resources.add(Class.forName("io.swagger.jaxrs.listing.ApiListingResource"));
            resources.add(Class.forName("io.swagger.jaxrs.listing.SwaggerSerializers"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return resources;
    }

    private KEngine start() throws WebApplicationException {
        boolean started;
        KEngine kengine = new KEngine();
        try {
            TeiidSwarmConnectionProvider connectionProvider = new TeiidSwarmConnectionProvider();
            TeiidSwarmMetadataInstance metadata = new TeiidSwarmMetadataInstance((TeiidConnectionProvider)connectionProvider);
            kengine.setMetadataInstance((MetadataInstance)metadata);
            LocalRepository repository = new LocalRepository();
            kengine.setDefaultRepository((Repository)repository);
            started = kengine.startAndWait();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!started) {
            throw new WebApplicationException((Throwable)new Exception(Messages.getString((Enum)Messages.Error.KOMODO_ENGINE_STARTUP_TIMEOUT, (Object[])new Object[]{1, UNIT})), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return kengine;
    }

    @PreDestroy
    public void stop() throws WebApplicationException {
        if (this.kengine == null) {
            return;
        }
        KLatchObserver observer = new KLatchObserver(new KEvent.Type[]{KEvent.Type.ENGINE_SHUTDOWN});
        this.kengine.addObserver((KObserver)observer);
        boolean shutdown = false;
        try {
            this.kengine.shutdownAndWait();
            shutdown = observer.getLatch().await(1L, UNIT);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)new Exception(Messages.getString((Enum)Messages.Error.KOMODO_ENGINE_SHUTDOWN_ERROR, (Object[])new Object[0])), Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            this.kengine = null;
        }
        if (!shutdown) {
            throw new WebApplicationException((Throwable)new Exception(Messages.getString((Enum)Messages.Error.KOMODO_ENGINE_SHUTDOWN_TIMEOUT, (Object[])new Object[]{1, UNIT})), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void importVdb(InputStream vdbStream, String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Import Vdb", false, (Repository.UnitOfWorkListener)callback);
        ImportOptions importOptions = new ImportOptions();
        ImportMessages importMessages = new ImportMessages();
        KomodoObject workspace = repository.komodoWorkspace(uow);
        VdbImporter importer = new VdbImporter(repository);
        importer.importVdb(uow, vdbStream, workspace, importOptions, importMessages);
        uow.commit();
        callback.await(3L, TimeUnit.MINUTES);
    }

    public void importDataservice(InputStream dsStream, String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        MetadataInstance metadataInstance = this.kengine.getMetadataInstance();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Import Dataservice", false, (Repository.UnitOfWorkListener)callback);
        ImportOptions importOptions = new ImportOptions();
        ImportMessages importMessages = new ImportMessages();
        KomodoObject workspace = repository.komodoWorkspace(uow);
        DataserviceConveyor dsConveyor = new DataserviceConveyor(repository, metadataInstance);
        dsConveyor.dsImport(uow, dsStream, workspace, importOptions, importMessages);
        uow.commit();
        callback.await(3L, TimeUnit.MINUTES);
    }

    public Vdb[] getVdbs(String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Find vdbs", true, null);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        Vdb[] vdbs = mgr.findVdbs(uow);
        uow.commit();
        return vdbs;
    }

    public void createDataservice(String dataserviceName, boolean populateWithSamples, String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Create Dataservice", false, (Repository.UnitOfWorkListener)callback);
        KomodoObject wkspace = repository.komodoWorkspace(uow);
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        VdbImporter importer = new VdbImporter(repository);
        ImportMessages importMessages = new ImportMessages();
        ImportOptions importOptions = new ImportOptions();
        importOptions.setOption(ImportOptions.OptionKeys.HANDLE_EXISTING, (Object)ImportOptions.ExistingNodeOptions.RETURN);
        String portfolioSample = KomodoUtilService.SAMPLES[1];
        String nwSample = KomodoUtilService.SAMPLES[4];
        InputStream portSampleStream = KomodoUtilService.getVdbSample((String)portfolioSample);
        InputStream nwindSampleStream = KomodoUtilService.getVdbSample((String)nwSample);
        importer.importVdb(uow, portSampleStream, wkspace, importOptions, importMessages);
        importer.importVdb(uow, nwindSampleStream, wkspace, importOptions, importMessages);
        KomodoObject pfSampleObj = wkspace.getChild(uow, "Portfolio");
        Vdb pfVdb = (Vdb)wsMgr.resolve(uow, (Object)pfSampleObj, Vdb.class);
        KomodoObject nwSampleObj = wkspace.getChild(uow, "Northwind");
        Vdb nwVdb = (Vdb)wsMgr.resolve(uow, (Object)nwSampleObj, Vdb.class);
        Dataservice dataservice = wsMgr.createDataservice(uow, wkspace, dataserviceName);
        dataservice.setDescription(uow, "This is my dataservice");
        dataservice.addVdb(uow, pfVdb);
        dataservice.setServiceVdb(uow, nwVdb);
        uow.commit();
        callback.await(3L, TimeUnit.MINUTES);
    }

    public Dataservice[] getDataservices(String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Find dataservices", true, null);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        Dataservice[] services = mgr.findDataservices(uow);
        uow.commit();
        return services;
    }

    public void createVdb(String vdbName, String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Create VDB", false, (Repository.UnitOfWorkListener)callback);
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        wsMgr.createVdb(uow, null, vdbName, vdbName);
        uow.commit();
        callback.await(3L, TimeUnit.MINUTES);
    }

    public void createVdbModel(String vdbName, String modelName, String user) throws Exception {
        SynchronousCallback callback;
        Repository.UnitOfWork uow;
        Repository repository = this.kengine.getDefaultRepository();
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)(uow = repository.createTransaction(user, "Create Model", false, (Repository.UnitOfWorkListener)(callback = new SynchronousCallback()))));
        if (!wsMgr.hasChild(uow, vdbName, "vdb:virtualDatabase")) {
            wsMgr.createVdb(uow, null, vdbName, vdbName);
        }
        KomodoObject kobj = wsMgr.getChild(uow, vdbName, "vdb:virtualDatabase");
        Vdb vdb = (Vdb)Vdb.RESOLVER.resolve(uow, kobj);
        vdb.addModel(uow, modelName);
        uow.commit();
        callback.await(3L, TimeUnit.MINUTES);
    }

    public void createConnection(String connectionName, String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Create Connection", false, (Repository.UnitOfWorkListener)callback);
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        wsMgr.createConnection(uow, null, connectionName);
        uow.commit();
        callback.await(3L, TimeUnit.MINUTES);
    }

    public Connection[] getConnections(String user) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction(user, "Find connections", true, null);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        Connection[] sources = mgr.findConnections(uow);
        uow.commit();
        return sources;
    }

    public void createDriver(String driverName) throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork uow = repository.createTransaction("SYSTEM", "Create Driver", false, (Repository.UnitOfWorkListener)callback);
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        wsMgr.createDriver(uow, null, driverName);
        uow.commit();
        callback.await(3L, TimeUnit.MINUTES);
    }

    public Driver[] getDrivers() throws Exception {
        Repository repository = this.kengine.getDefaultRepository();
        Repository.UnitOfWork uow = repository.createTransaction("SYSTEM", "Find drivers", true, null);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)uow);
        Driver[] drivers = mgr.findDrivers(uow);
        uow.commit();
        return drivers;
    }
}

