/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import com.google.gson.Gson;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.Variant;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.komodo.core.KEngine;
import org.komodo.core.repository.SynchronousCallback;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.CallbackTimeoutException;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.KomodoService;
import org.komodo.rest.Messages;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.RestEntityFactory;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.KLog;
import org.komodo.utils.StringNameValidator;
import org.komodo.utils.StringUtils;

public abstract class KomodoService
implements KomodoRestV1Application.V1Constants {
    public static final String KOMODO_USER = "anonymous";
    protected static final KLog LOGGER = KLog.getLogger();
    protected static final StringNameValidator VALIDATOR = new StringNameValidator();
    protected static final String DSB_PROP_OWNER = "dsbOwner";
    protected static final String DSB_PROP_SERVICE_SOURCE = "dsbServiceSource";
    protected static final String DSB_PROP_SOURCE_CONNECTION = "dsbSourceConnection";
    protected static final String DSB_PROP_SOURCE_TRANSLATOR = "dsbSourceTranslator";
    protected static final String DSB_PROP_METADATA_STATUS = "dsbMetadataStatus";
    protected static final String DSB_PROP_METADATA_STATUS_MSG = "dsbMetadataStatusMessage";
    private static final int TIMEOUT = 30;
    private static final TimeUnit UNIT = TimeUnit.SECONDS;
    protected static final SecurityPrincipal SYSTEM_USER = new SecurityPrincipal("SYSTEM", null);
    protected final KEngine kengine;
    protected RestEntityFactory entityFactory = new RestEntityFactory();
    @Context
    protected SecurityContext securityContext;

    protected KomodoService(KEngine engine) {
        this.kengine = engine;
    }

    public static String protectPrefix(String value) {
        if (value == null) {
            return null;
        }
        value = value.replaceAll(":", "__");
        return value;
    }

    public static String unprotectPrefix(String value) {
        if (value == null) {
            return null;
        }
        value = value.replaceAll("__", ":");
        return value;
    }

    protected SecurityPrincipal checkSecurityContext(HttpHeaders headers) {
        return new SecurityPrincipal(KOMODO_USER, null);
    }

    protected String encode(byte[] content) {
        if (content == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(content);
    }

    protected byte[] decode(String content) {
        if (content == null) {
            return null;
        }
        return Base64.getDecoder().decode(content);
    }

    protected WorkspaceManager getWorkspaceManager(Repository.UnitOfWork transaction) throws KException {
        Repository repo = this.kengine.getDefaultRepository();
        return WorkspaceManager.getInstance((Repository)repo, (Repository.UnitOfWork)transaction);
    }

    protected Object createErrorResponseEntity(List<MediaType> acceptableMediaTypes, String errorMessage) {
        String responseEntity = null;
        if (acceptableMediaTypes.contains(MediaType.APPLICATION_JSON_TYPE)) {
            Gson gson = new Gson();
            responseEntity = gson.toJson((Object)new ErrorResponse(this, errorMessage));
        } else if (acceptableMediaTypes.contains(MediaType.APPLICATION_XML_TYPE)) {
            ErrorResponse errResponse = new ErrorResponse(this, errorMessage);
            JAXBElement xmlErrResponse = new JAXBElement(new QName("error"), ErrorResponse.class, (Object)errResponse);
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ErrorResponse.class});
                StringWriter writer = new StringWriter();
                Marshaller m = context.createMarshaller();
                m.marshal((Object)xmlErrResponse, (Writer)writer);
                responseEntity = writer.toString();
            }
            catch (Exception ex) {
                responseEntity = errorMessage;
            }
        } else {
            responseEntity = errorMessage;
        }
        return responseEntity;
    }

    protected Response createErrorResponse(Response.Status returnCode, List<MediaType> mediaTypes, Throwable ex, RelationalMessages.Error errorType, Object ... errorMsgInputs) {
        String errorMsg = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : ex.getClass().getSimpleName();
        StringBuffer buf = new StringBuffer(errorMsg).append("\n").append("-----").append("\n");
        String stackTrace = StringUtils.exceptionToString((Throwable)ex);
        buf.append(stackTrace).append("\n");
        String resultMsg = null;
        resultMsg = errorMsgInputs == null || errorMsgInputs.length == 0 ? RelationalMessages.getString((Enum)errorType, (Object[])new Object[]{buf.toString()}) : RelationalMessages.getString((Enum)errorType, (Object[])new Object[]{errorMsgInputs, buf.toString()});
        return this.createErrorResponse(returnCode, mediaTypes, resultMsg);
    }

    protected Response createErrorResponse(Response.Status returnCode, List<MediaType> mediaTypes, RelationalMessages.Error errorType, Object ... errorMsgInputs) {
        String resultMsg = null;
        resultMsg = errorMsgInputs == null || errorMsgInputs.length == 0 ? RelationalMessages.getString((Enum)errorType, (Object[])new Object[0]) : RelationalMessages.getString((Enum)errorType, (Object[])errorMsgInputs);
        return this.createErrorResponse(returnCode, mediaTypes, resultMsg);
    }

    protected Response createErrorResponseWithForbidden(List<MediaType> mediaTypes, Throwable ex, RelationalMessages.Error errorType, Object ... errorMsgInputs) {
        return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, ex, errorType, errorMsgInputs);
    }

    protected Response createErrorResponseWithForbidden(List<MediaType> mediaTypes, RelationalMessages.Error errorType, Object ... errorMsgInputs) {
        return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, errorType, errorMsgInputs);
    }

    protected Response createErrorResponse(Response.Status returnCode, List<MediaType> mediaTypes, String resultMsg) {
        Object responseEntity = this.createErrorResponseEntity(mediaTypes, resultMsg);
        return Response.status((Response.Status)returnCode).entity(responseEntity).build();
    }

    protected Response.ResponseBuilder notAcceptableMediaTypesBuilder() {
        List variants = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build();
        return Response.notAcceptable((List)variants);
    }

    protected boolean isAcceptable(List<MediaType> acceptableTypes, MediaType candidate) {
        if (acceptableTypes == null || acceptableTypes.isEmpty()) {
            return false;
        }
        if (candidate == null) {
            return false;
        }
        for (MediaType acceptableType : acceptableTypes) {
            if (!candidate.isCompatible(acceptableType)) continue;
            return true;
        }
        return false;
    }

    protected Response commit(List<MediaType> acceptableMediaTypes, KRestEntity entity) throws Exception {
        Response.ResponseBuilder builder = null;
        if (entity == RestBasicEntity.NO_CONTENT) {
            builder = Response.noContent();
        } else if (entity instanceof RestBasicEntity.ResourceNotFound) {
            RestBasicEntity.ResourceNotFound resourceNotFound = (RestBasicEntity.ResourceNotFound)entity;
            String notFoundMsg = Messages.getString((Enum)Messages.Error.RESOURCE_NOT_FOUND, (Object[])new Object[]{resourceNotFound.getResourceName(), resourceNotFound.getOperationName()});
            Object responseEntity = this.createErrorResponseEntity(acceptableMediaTypes, notFoundMsg);
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND).entity(responseEntity);
        } else {
            builder = this.isAcceptable(acceptableMediaTypes, MediaType.APPLICATION_JSON_TYPE) ? Response.ok((Object)KomodoJsonMarshaller.marshall((KRestEntity)entity), (String)"application/json") : (this.isAcceptable(acceptableMediaTypes, MediaType.APPLICATION_XML_TYPE) && entity.supports(MediaType.APPLICATION_XML_TYPE) ? Response.ok((Object)entity.getXml(), (String)"application/xml") : this.notAcceptableMediaTypesBuilder());
        }
        return builder.build();
    }

    protected Response commit(Repository.UnitOfWork transaction, List<MediaType> acceptableMediaTypes, KRestEntity entity) throws Exception {
        assert (transaction.getCallback() instanceof SynchronousCallback);
        int timeout = 30;
        TimeUnit unit = UNIT;
        SynchronousCallback callback = (SynchronousCallback)transaction.getCallback();
        transaction.commit();
        if (!callback.await(30L, unit)) {
            String errorMessage = Messages.getString((Enum)Messages.Error.COMMIT_TIMEOUT, (Object[])new Object[]{transaction.getName(), 30, unit});
            Object responseEntity = this.createErrorResponseEntity(acceptableMediaTypes, errorMessage);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(responseEntity).build();
        }
        Throwable error = callback.error();
        if (error != null) {
            Object responseEntity = this.createErrorResponseEntity(acceptableMediaTypes, error.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(responseEntity).build();
        }
        LOGGER.debug("commit: successfully committed '{0}', rollbackOnly = '{1}'", new Object[]{transaction.getName(), transaction.isRollbackOnly()});
        return this.commit(acceptableMediaTypes, entity);
    }

    protected Response commit(Repository.UnitOfWork transaction, List<MediaType> acceptableMediaTypes) throws Exception {
        assert (transaction.getCallback() instanceof SynchronousCallback);
        int timeout = 30;
        TimeUnit unit = UNIT;
        SynchronousCallback callback = (SynchronousCallback)transaction.getCallback();
        transaction.commit();
        if (!callback.await(30L, unit)) {
            String errorMessage = Messages.getString((Enum)Messages.Error.COMMIT_TIMEOUT, (Object[])new Object[]{transaction.getName(), 30, unit});
            Object responseEntity = this.createErrorResponseEntity(acceptableMediaTypes, errorMessage);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity(responseEntity).build();
        }
        Throwable error = transaction.getError();
        if (error != null) {
            Object responseEntity = this.createErrorResponseEntity(acceptableMediaTypes, error.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(responseEntity).build();
        }
        error = callback.error();
        if (error != null) {
            Object responseEntity = this.createErrorResponseEntity(acceptableMediaTypes, error.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(responseEntity).build();
        }
        return Response.ok().build();
    }

    protected Response commit(Repository.UnitOfWork transaction, List<MediaType> acceptableMediaTypes, List<? extends KRestEntity> entities) throws Exception {
        KRestEntity entity;
        this.commit(transaction, acceptableMediaTypes);
        LOGGER.debug("commit: successfully committed '{0}', rollbackOnly = '{1}'", new Object[]{transaction.getName(), transaction.isRollbackOnly()});
        Response.ResponseBuilder builder = null;
        if (entities.size() == 1 && (entity = entities.iterator().next()) instanceof RestBasicEntity.ResourceNotFound) {
            RestBasicEntity.ResourceNotFound resourceNotFound = (RestBasicEntity.ResourceNotFound)entity;
            String notFoundMessage = Messages.getString((Enum)Messages.Error.RESOURCE_NOT_FOUND, (Object[])new Object[]{resourceNotFound.getResourceName(), resourceNotFound.getOperationName()});
            Object responseEntity = this.createErrorResponseEntity(acceptableMediaTypes, notFoundMessage);
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND).entity(responseEntity);
        } else {
            builder = this.isAcceptable(acceptableMediaTypes, MediaType.APPLICATION_JSON_TYPE) ? Response.ok((Object)KomodoJsonMarshaller.marshallArray((KRestEntity[])entities.toArray(new KRestEntity[0]), (boolean)true), (String)"application/json") : this.notAcceptableMediaTypesBuilder();
        }
        return builder.build();
    }

    protected Repository.UnitOfWork createTransaction(SecurityPrincipal user, String name, boolean rollbackOnly, Repository.UnitOfWorkListener callback) throws KException {
        Repository repo = this.kengine.getDefaultRepository();
        Repository.UnitOfWork result = repo.createTransaction(user.getUserName(), this.getClass().getSimpleName() + ":" + name + ":" + System.currentTimeMillis(), rollbackOnly, callback);
        LOGGER.debug("createTransaction:created '{0}', rollbackOnly = '{1}'", new Object[]{result.getName(), result.isRollbackOnly()});
        return result;
    }

    protected Repository.UnitOfWork createTransaction(SecurityPrincipal user, String name, boolean rollbackOnly) throws KException {
        Repository repo = this.kengine.getDefaultRepository();
        SynchronousCallback callback = new SynchronousCallback();
        Repository.UnitOfWork result = repo.createTransaction(user.getUserName(), this.getClass().getSimpleName() + ":" + name + ":" + System.currentTimeMillis(), rollbackOnly, (Repository.UnitOfWorkListener)callback);
        LOGGER.debug("createTransaction:created '{0}', rollbackOnly = '{1}'", new Object[]{result.getName(), result.isRollbackOnly()});
        return result;
    }

    protected Vdb findVdb(Repository.UnitOfWork uow, String vdbName) throws KException {
        if (!this.getWorkspaceManager(uow).hasChild(uow, vdbName, "vdb:virtualDatabase")) {
            return null;
        }
        KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, vdbName, "vdb:virtualDatabase");
        Vdb vdb = (Vdb)this.getWorkspaceManager(uow).resolve(uow, (Object)kobject, Vdb.class);
        LOGGER.debug("VDB '{0}' was found", new Object[]{vdbName});
        return vdb;
    }

    protected Repository.UnitOfWork systemTx(String description, boolean rollback) throws KException {
        SynchronousCallback callback = new SynchronousCallback();
        return this.createTransaction(SYSTEM_USER, description, rollback, (Repository.UnitOfWorkListener)callback);
    }

    protected void awaitCallback(Repository.UnitOfWork transaction) throws KException {
        if (transaction == null) {
            return;
        }
        Repository.UnitOfWorkListener callback = transaction.getCallback();
        if (!(callback instanceof SynchronousCallback)) {
            return;
        }
        SynchronousCallback syncCallback = (SynchronousCallback)callback;
        try {
            if (!syncCallback.await(3L, TimeUnit.MINUTES)) {
                throw new CallbackTimeoutException();
            }
            if (transaction.getError() != null) {
                throw new KException((Throwable)transaction.getError());
            }
            if (syncCallback.hasError()) {
                throw new KException(syncCallback.error());
            }
        }
        catch (Exception ex) {
            throw new KException((Throwable)ex);
        }
    }

    protected Dataservice findDataservice(Repository.UnitOfWork uow, String dataserviceName) throws KException {
        if (!this.getWorkspaceManager(uow).hasChild(uow, dataserviceName, "dv:dataService")) {
            return null;
        }
        KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, dataserviceName, "dv:dataService");
        Dataservice dataservice = (Dataservice)this.getWorkspaceManager(uow).resolve(uow, (Object)kobject, Dataservice.class);
        LOGGER.debug("Dataservice '{0}' was found", new Object[]{dataserviceName});
        return dataservice;
    }

    protected Connection findConnection(Repository.UnitOfWork uow, String connectionName) throws KException {
        if (!this.getWorkspaceManager(uow).hasChild(uow, connectionName, "dv:connection")) {
            return null;
        }
        KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, connectionName, "dv:connection");
        Connection connection = (Connection)this.getWorkspaceManager(uow).resolve(uow, (Object)kobject, Connection.class);
        LOGGER.debug("Connection '{0}' was found", new Object[]{connectionName});
        return connection;
    }

    protected String uri(String ... segments) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < segments.length; ++i) {
            buffer.append(segments[i]);
            if (i >= segments.length - 1) continue;
            buffer.append("/");
        }
        return buffer.toString();
    }

    protected Response commitNoVdbFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String vdbName) throws Exception {
        LOGGER.debug("VDB '{0}' was not found", new Object[]{vdbName});
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(vdbName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoSourceVdbFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes) throws Exception {
        LOGGER.debug("sourceVDB was not found", new Object[0]);
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound("sourceVdb", Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoDataserviceFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String dataserviceName) throws Exception {
        LOGGER.debug("Dataservice '{0}' was not found", new Object[]{dataserviceName});
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(dataserviceName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoConnectionFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String connectionName) throws Exception {
        LOGGER.debug("Connection '{0}' was not found", new Object[]{connectionName});
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(connectionName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoTemplateFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String templateName) throws Exception {
        LOGGER.debug("Template '{0}' was not found", new Object[]{templateName});
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(templateName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoModelFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String modelName, String vdbName) throws Exception {
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "Models", modelName}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoTableFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String tableName, String modelName, String vdbName) throws Exception {
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "Models", modelName, "Tables", tableName}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoDataRoleFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String dataRoleId, String vdbName) throws Exception {
        LOGGER.debug("No data role '{0}' found for vdb '{1}'", new Object[]{dataRoleId, vdbName});
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "VdbDataRoles", dataRoleId}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected Response commitNoPermissionFound(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String permissionId, String dataRoleId, String vdbName) throws Exception {
        LOGGER.debug("No permission '{0}' for data role '{1}' found for vdb '{2}'", new Object[]{permissionId, dataRoleId, vdbName});
        return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "VdbDataRoles", dataRoleId, "VdbPermissions", permissionId}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
    }

    protected void setProperties(Repository.UnitOfWork uow, Connection connection, RestConnection restConnection) throws KException {
        String newJndiName = restConnection.getJndiName();
        String newDriverName = restConnection.getDriverName();
        boolean newJdbc = restConnection.isJdbc();
        String oldJndiName = connection.getJndiName(uow);
        String oldDriverName = connection.getDriverName(uow);
        boolean oldJdbc = connection.isJdbc(uow);
        if (!StringUtils.equals((String)newJndiName, (String)oldJndiName)) {
            connection.setJndiName(uow, newJndiName);
        }
        if (!StringUtils.equals((String)newDriverName, (String)oldDriverName)) {
            connection.setDriverName(uow, newDriverName);
        }
        if (newJdbc != oldJdbc) {
            connection.setJdbc(uow, newJdbc);
        }
        List properties = restConnection.getProperties();
        for (RestProperty property : properties) {
            connection.setProperty(uow, property.getName(), new Object[]{property.getValue()});
        }
    }
}

