/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.AbstractKEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Property;
import org.komodo.spi.repository.PropertyDescriptor;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public class RestBasicEntity
extends AbstractKEntity {
    public static final RestBasicEntity NO_CONTENT = new /* Unavailable Anonymous Inner Class!! */;

    public RestBasicEntity() {
    }

    public RestBasicEntity(URI baseUri) throws KException {
        super(baseUri);
    }

    protected RestBasicEntity(URI baseUri, KomodoObject kObject, Repository.UnitOfWork uow, boolean createCommonLinks) throws KException {
        this(baseUri);
        ArgCheck.isNotNull((Object)kObject, (String)"kObject");
        ArgCheck.isNotNull((Object)uow, (String)"uow");
        this.setId(kObject.getName(uow));
        this.setDataPath(kObject.getAbsolutePath());
        this.setkType(kObject.getTypeIdentifier(uow));
        this.setHasChildren(kObject.hasChildren(uow));
        if (createCommonLinks) {
            KomodoProperties properties = new KomodoProperties();
            properties.addProperty("path", (Object)this.getDataPath());
            this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().searchUri(properties)));
            KomodoObject parent = kObject.getParent(uow);
            ArgCheck.isNotNull((Object)parent);
            properties = new KomodoProperties();
            properties.addProperty("path", (Object)parent.getAbsolutePath());
            this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().searchUri(properties)));
            this.createChildLink();
        }
    }

    protected void createChildLink() {
        KomodoProperties properties = new KomodoProperties();
        properties.addProperty("parent", (Object)this.getDataPath());
        this.addLink(new RestLink(RestLink.LinkType.CHILDREN, this.getUriBuilder().searchUri(properties)));
    }

    public RestBasicEntity(URI baseUri, KomodoObject kObject, Repository.UnitOfWork uow) throws KException {
        this(baseUri, kObject, uow, true);
    }

    protected <T extends KomodoObject> T ancestor(KomodoObject kObject, Class<T> parentClass, Repository.UnitOfWork uow) throws KException {
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)kObject.getRepository(), (Repository.UnitOfWork)uow);
        for (KomodoObject parent = kObject.getParent(uow); parent != null; parent = parent.getParent(uow)) {
            KomodoObject resolvedParent = (KomodoObject)wsMgr.resolve(uow, (Object)parent, parentClass);
            if (resolvedParent == null) continue;
            return (T)resolvedParent;
        }
        return null;
    }

    public String getId() {
        Object id = this.tuples.get("keng__id");
        return id != null ? id.toString() : null;
    }

    public void setId(String id) {
        this.tuples.put("keng__id", id);
    }

    public String getDataPath() {
        Object path = this.tuples.get("keng__dataPath");
        return path != null ? path.toString() : null;
    }

    public void setDataPath(String dataPath) {
        this.tuples.put("keng__dataPath", dataPath);
    }

    public KomodoType getkType() {
        Object ktype = this.tuples.get("keng__kType");
        return ktype != null ? KomodoType.getKomodoType((String)ktype.toString()) : null;
    }

    public void setkType(KomodoType kType) {
        this.tuples.put("keng__kType", kType);
    }

    public boolean hasChildren() {
        Object value = this.tuples.get("keng__hasChildren");
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setHasChildren(boolean hasChildren) {
        this.tuples.put("keng__hasChildren", hasChildren);
    }

    protected boolean hasPrefix(String name) {
        return name.matches("([a-zA-Z]+):(.*)");
    }

    public void addExecutionProperties(Repository.UnitOfWork uow, KomodoObject kObject) throws KException {
        ArrayList<String> propNames = new ArrayList<String>(Arrays.asList(kObject.getPropertyNames(uow)));
        PropertyDescriptor[] descriptors = kObject.getPropertyDescriptors(uow);
        if (descriptors.length != 0) {
            for (PropertyDescriptor descriptor : descriptors) {
                String name = descriptor.getName();
                if (propNames.contains(name)) continue;
                propNames.add(name);
            }
        }
        for (String propName : propNames) {
            Property attribute;
            if (this.hasPrefix(propName) || (attribute = kObject.getProperty(uow, propName)) == null) continue;
            if (attribute.isMultiple(uow)) {
                Object[] values = attribute.getValues(uow);
                this.addProperty(propName, (Object)values);
                continue;
            }
            Object value = attribute.getValue(uow);
            this.addProperty(propName, value);
        }
    }

    public String toString() {
        return "RestBasicEntity [tuples=" + this.tuples + ", properties=" + this.properties + ", links=" + this.links + "]";
    }
}

