/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.komodo.rest.RestLink;
import org.komodo.utils.ArgCheck;

public final class RestLink {
    public static final Map<LinkType, RestLink> NO_LINKS = Collections.emptyMap();
    private LinkType rel;
    private URI href;

    public RestLink() {
    }

    public RestLink(LinkType rel, URI href) {
        ArgCheck.isNotNull((Object)rel, (String)"rel");
        ArgCheck.isNotNull((Object)href, (String)"href");
        this.rel = rel;
        this.href = href;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.rel == null ? 0 : this.rel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestLink other = (RestLink)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        return this.rel == other.rel;
    }

    @ApiModelProperty(required=true)
    public URI getHref() {
        return this.href;
    }

    @ApiModelProperty(required=true)
    public LinkType getRel() {
        return this.rel;
    }

    public void setHref(URI newHref) {
        this.href = newHref;
    }

    public void setRel(LinkType newRel) {
        this.rel = newRel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("rel = ").append(this.rel);
        builder.append(", ");
        builder.append("href = ").append(this.href);
        return builder.toString();
    }
}

