/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.komodo.metadata.TeiidConnectionProvider;
import org.komodo.spi.metadata.MetadataInstance;
import org.komodo.spi.outcome.Outcome;
import org.komodo.spi.outcome.OutcomeFactory;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.jdbc.TeiidDriver;

public class TeiidSwarmConnectionProvider
implements TeiidConnectionProvider {
    private static final String PING_VDB = "<vdb name=\"ping\" version=\"1\"><model visible=\"true\" name=\"Foo\" type=\"PHYSICAL\" path=\"/dummy/Foo\"><source name=\"s\" translator-name=\"loopback\"/><metadata type=\"DDL\"><![CDATA[CREATE FOREIGN TABLE G1 (e1 string, e2 integer);]]></metadata></model></vdb>";
    private Admin admin;

    public TeiidSwarmConnectionProvider() throws AdminException {
        this.connect();
    }

    protected synchronized void connect() throws AdminException {
        if (this.admin != null) {
            return;
        }
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9990, "admin", "admin".toCharArray());
    }

    protected synchronized void disconnect() throws AdminException {
        if (this.admin != null) {
            this.admin.close();
            this.admin = null;
        }
    }

    public Admin getAdmin() throws AdminException {
        return this.admin;
    }

    public Connection getConnection(String vdb, String version) throws SQLException {
        Properties props = new Properties();
        return new TeiidDriver().connect("jdbc:teiid:" + vdb + "." + version, props);
    }

    public Outcome ping(MetadataInstance.ConnectivityType connectivityType) {
        try {
            if (connectivityType == MetadataInstance.ConnectivityType.ADMIN) {
                this.admin.getSessions();
            } else {
                new TeiidDriver().connect("jdbc:teiid:ping", new Properties());
            }
        }
        catch (SQLException | AdminException e) {
            return OutcomeFactory.getInstance().createError(e.getLocalizedMessage(), (Exception)e);
        }
        return OutcomeFactory.getInstance().createOK();
    }

    public void reconnect() throws Exception {
        this.disconnect();
        Thread.sleep(500L);
        this.connect();
    }

    public void onStart() {
        try {
            this.admin.deploy("ping-vdb.xml", (InputStream)new ByteArrayInputStream(PING_VDB.getBytes()));
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }

    public void onShutdown() {
    }
}

