/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kubernetes.client.ModelServiceCatalogClient;
import io.kubernetes.client.Secret;
import io.kubernetes.client.ServiceInstance;
import io.kubernetes.client.ServiceInstanceList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.komodo.metadata.DefaultMetadataInstance;
import org.komodo.metadata.TeiidConnectionProvider;
import org.komodo.rest.ApplicationProperties;
import org.komodo.rest.AuthHandlingFilter;
import org.komodo.spi.KException;
import org.komodo.spi.runtime.TeiidDataSource;
import org.teiid.adminapi.AdminException;

/*
 * Exception performing whole class analysis ignored.
 */
public class TeiidSwarmMetadataInstance
extends DefaultMetadataInstance {
    private static final String OSURL = "https://openshift.default.svc";
    private static final String SC_VERSION = "v1beta1";
    private ModelServiceCatalogClient scClient = new ModelServiceCatalogClient("https://openshift.default.svc", "v1beta1");

    public TeiidSwarmMetadataInstance(TeiidConnectionProvider connectionProvider) {
        super(connectionProvider);
    }

    public Collection<TeiidDataSource> getDataSources() throws KException {
        this.checkStarted();
        try {
            Collection dsNames = this.admin().getDataSourceNames();
            String token = ((AuthHandlingFilter.OAuthCredentials)AuthHandlingFilter.threadOAuthCredentials.get()).getToken();
            System.out.println("Access token = " + token);
            if (token != null) {
                this.scClient.setAuthHeader(token);
                ServiceInstanceList serviceList = this.scClient.getServiceInstances(ApplicationProperties.getNamespace());
                List services = serviceList.getItems();
                if (services != null && !services.isEmpty()) {
                    for (ServiceInstance svc : services) {
                        Secret secret;
                        String name = svc.getMetadata().getName();
                        System.out.println("Service Name = " + name);
                        if (!svc.getStatus().isReady()) continue;
                        String secretName = svc.getSpec().getParametersFrom().getSecretKeyRef().getName();
                        String key = svc.getSpec().getParametersFrom().getSecretKeyRef().getKey();
                        if (dsNames.contains(name) || (secret = this.scClient.getSecret(ApplicationProperties.getNamespace(), secretName)) == null) continue;
                        String json = (String)secret.getData().get(key);
                        Map map = (Map)new ObjectMapper().readerFor(Map.class).readValue(Base64.getDecoder().decode(json));
                        this.createDataSource(name, map);
                    }
                }
            }
            return super.getDataSources();
        }
        catch (Exception ex) {
            throw TeiidSwarmMetadataInstance.handleError((Throwable)ex);
        }
    }

    private void createDataSource(String name, Map<String, String> map) throws AdminException {
        if (map.get("POSTGRESQL_DATABASE") != null) {
            System.out.println("Creating the Datasource = " + name);
            String driverName = null;
            Set templateNames = this.admin().getDataSourceTemplateNames();
            for (String template : templateNames) {
                if (!template.startsWith("postgresql")) continue;
                driverName = template;
            }
            Properties props = new Properties();
            props.setProperty("connection-url", "jdbc:postgresql://" + map.get("DATABASE_SERVICE_NAME") + ":5432/" + map.get("POSTGRESQL_DATABASE"));
            props.setProperty("user-name", map.get("POSTGRESQL_USER"));
            props.setProperty("password", map.get("POSTGRESQL_PASSWORD"));
            this.admin().createDataSource(name, driverName, props);
        }
    }
}

