/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.cors;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import org.komodo.rest.Messages;
import org.komodo.rest.cors.KCorsHandler;

@PreMatching
public class KCorsFilter
implements ContainerRequestFilter,
ContainerResponseFilter,
KCorsHandler {
    protected boolean allowCredentials = true;
    protected String allowedMethods;
    protected String allowedHeaders;
    protected String exposedHeaders;
    protected int corsMaxAge = -1;
    protected Set<String> allowedOrigins = new HashSet();

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null) {
            return;
        }
        if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
            this.preflight(origin, requestContext);
        } else {
            this.checkOrigin(requestContext, origin);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null || requestContext.getMethod().equalsIgnoreCase("OPTIONS") || requestContext.getProperty("cors.failure") != null) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Origin", (Object)origin);
        if (this.allowCredentials) {
            responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Credentials", (Object)"true");
        }
        if (this.exposedHeaders != null) {
            responseContext.getHeaders().putSingle((Object)"Access-Control-Expose-Headers", (Object)this.exposedHeaders);
        }
    }

    protected void preflight(String origin, ContainerRequestContext requestContext) throws IOException {
        String allowHeaders;
        String requestMethods;
        this.checkOrigin(requestContext, origin);
        Response.ResponseBuilder builder = Response.ok();
        builder.header("Access-Control-Allow-Origin", (Object)origin);
        if (this.allowCredentials) {
            builder.header("Access-Control-Allow-Credentials", (Object)"true");
        }
        if ((requestMethods = requestContext.getHeaderString("Access-Control-Request-Method")) != null) {
            if (this.allowedMethods != null) {
                requestMethods = this.allowedMethods;
            }
            builder.header("Access-Control-Allow-Methods", (Object)requestMethods);
        }
        if ((allowHeaders = requestContext.getHeaderString("Access-Control-Request-Headers")) != null) {
            if (this.allowedHeaders != null) {
                allowHeaders = this.allowedHeaders;
            }
            builder.header("Access-Control-Allow-Headers", (Object)allowHeaders);
        }
        if (this.corsMaxAge > -1) {
            builder.header("Access-Control-Max-Age", (Object)this.corsMaxAge);
        }
        requestContext.abortWith(builder.build());
    }

    protected void checkOrigin(ContainerRequestContext requestContext, String origin) {
        if (!this.allowedOrigins.contains("*") && !this.allowedOrigins.contains(origin)) {
            requestContext.setProperty("cors.failure", (Object)true);
            throw new ForbiddenException(Messages.getString((Enum)Messages.Error.ORIGIN_NOT_ALLOWED, (Object[])new Object[]{origin}));
        }
    }
}

