/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.ws.rs.core.UriBuilder;
import org.komodo.rest.Messages;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.response.RestVdbImport;

public final class LinkSerializer
extends TypeAdapter<RestLink> {
    private boolean isComplete(RestLink link) {
        return link.getRel() != null && link.getHref() != null;
    }

    public RestLink read(JsonReader in) throws IOException {
        RestLink link = new RestLink();
        in.beginObject();
        block8: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "href": {
                    String uri = in.nextString();
                    link.setHref(UriBuilder.fromUri((String)uri).build(new Object[0]));
                    continue block8;
                }
                case "rel": {
                    String rel = in.nextString();
                    link.setRel(RestLink.LinkType.fromString((String)rel));
                    continue block8;
                }
            }
            throw new IOException(Messages.getString((Enum)Messages.Error.UNEXPECTED_JSON_TOKEN, (Object[])new Object[]{name}));
        }
        in.endObject();
        if (!this.isComplete(link)) {
            throw new IOException(Messages.getString((Enum)Messages.Error.INCOMPLETE_JSON, (Object[])new Object[]{RestVdbImport.class.getSimpleName()}));
        }
        return link;
    }

    public void write(JsonWriter out, RestLink value) throws IOException {
        if (!this.isComplete(value)) {
            throw new IOException(Messages.getString((Enum)Messages.Error.INCOMPLETE_JSON, (Object[])new Object[]{RestLink.class.getSimpleName()}));
        }
        out.beginObject();
        out.name("rel");
        out.value(value.getRel().toString());
        out.name("href");
        out.value(value.getHref().toString());
        out.endObject();
    }
}

