/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.komodo.rest.Messages;
import org.komodo.rest.RestProperty;
import org.komodo.rest.json.JsonConstants;
import org.komodo.rest.json.RestPropertySerializer;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.utils.StringUtils;

public class RestPropertySerializer
extends TypeAdapter<RestProperty>
implements JsonConstants {
    protected boolean isComplete(RestProperty property) {
        return !StringUtils.isBlank((String)property.getName());
    }

    public RestProperty read(JsonReader in) throws IOException {
        String propName = null;
        Object[] propValue = null;
        in.beginObject();
        block7: while (in.hasNext()) {
            String name = in.nextName();
            if ("name".equals(name)) {
                propName = in.nextString();
                continue;
            }
            if (!"value".equals(name)) continue;
            JsonToken token = in.peek();
            switch (1.$SwitchMap$com$google$gson$stream$JsonToken[token.ordinal()]) {
                case 1: {
                    propValue = in.nextBoolean();
                    continue block7;
                }
                case 2: {
                    double value = in.nextDouble();
                    if (value % 1.0 == 0.0) {
                        propValue = (int)value;
                        continue block7;
                    }
                    propValue = value;
                    continue block7;
                }
                case 3: {
                    propValue = in.nextString();
                    continue block7;
                }
                case 4: {
                    in.nextNull();
                    propValue = null;
                    continue block7;
                }
                case 5: {
                    Object[] value = (Object[])KomodoJsonMarshaller.BUILDER.fromJson(in, Object[].class);
                    for (int i = 0; i < value.length; ++i) {
                        if (!(value[i] instanceof Double) || (Double)value[i] % 1.0 != 0.0) continue;
                        value[i] = ((Double)value[i]).intValue();
                    }
                    propValue = value;
                    continue block7;
                }
            }
            throw new IOException(Messages.getString((Enum)Messages.Error.UNEXPECTED_JSON_TOKEN, (Object[])new Object[]{name}));
        }
        in.endObject();
        RestProperty property = new RestProperty(propName, propValue);
        if (!this.isComplete(property)) {
            throw new IOException(Messages.getString((Enum)Messages.Error.INCOMPLETE_JSON, (Object[])new Object[]{RestProperty.class.getSimpleName()}));
        }
        return property;
    }

    protected void writeValue(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value instanceof Boolean) {
            out.value(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            out.value((long)((Integer)value).intValue());
        } else if (value instanceof Long) {
            out.value(((Long)value).longValue());
        } else if (value instanceof Double) {
            out.value(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            out.value(((Double)value).doubleValue());
        } else if (value instanceof String[]) {
            out.beginArray();
            for (String val : (String[])value) {
                out.value(val);
            }
            out.endArray();
        } else if (value instanceof Object[]) {
            out.beginArray();
            for (Object val : (Object[])value) {
                this.writeValue(out, val);
            }
            out.endArray();
        } else {
            out.value(value.toString());
        }
    }

    public void write(JsonWriter out, RestProperty value) throws IOException {
        out.beginObject();
        out.name("name");
        out.value(value.getName());
        out.name("value");
        this.writeValue(out, value.getValue());
        out.endObject();
    }
}

