/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.UriBuilder;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.Descriptor;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class KomodoRestUriBuilder
implements KomodoRestV1Application.V1Constants {
    private final URI baseUri;

    public KomodoRestUriBuilder(URI baseUri) {
        ArgCheck.isNotNull((Object)baseUri, (String)"baseUri");
        this.baseUri = baseUri;
    }

    private boolean isVdb(Repository.UnitOfWork uow, KomodoObject kObject) throws KException {
        if (kObject == null) {
            return false;
        }
        Descriptor type = kObject.getPrimaryType(uow);
        return "vdb:virtualDatabase".equals(type.getName());
    }

    private String setting(Properties settings, SettingNames settingName) {
        String value = settings.getProperty(settingName.name());
        ArgCheck.isNotEmpty((String)value, (String)settingName.name());
        return value;
    }

    private URI parentUri(Properties settings) {
        Object uriObject = settings.get(SettingNames.PARENT_PATH.name());
        ArgCheck.isInstanceOf(URI.class, (Object)uriObject);
        return (URI)uriObject;
    }

    private URI vdbParentUri(Properties settings) {
        Object uriObject = settings.get(SettingNames.VDB_PARENT_PATH.name());
        ArgCheck.isInstanceOf(URI.class, (Object)uriObject);
        return (URI)uriObject;
    }

    private String vdbName(Properties settings) {
        return this.setting(settings, SettingNames.VDB_NAME);
    }

    public URI dataserviceChildGroupUri(URI parentUri, String dataserviceName, RestLink.LinkType target) {
        return UriBuilder.fromUri((URI)this.dataserviceUri(parentUri, dataserviceName)).path(target.uriName()).build(new Object[0]);
    }

    private URI dataserviceParentUri(Properties settings) {
        Object uriObject = settings.get(SettingNames.DATA_SERVICE_PARENT_PATH.name());
        ArgCheck.isInstanceOf(URI.class, (Object)uriObject);
        return (URI)uriObject;
    }

    public URI dataserviceParentUri(Dataservice dataservice, Repository.UnitOfWork uow) throws KException {
        return this.workspaceDataservicesUri();
    }

    private String dataserviceName(Properties settings) {
        return this.setting(settings, SettingNames.DATA_SERVICE_NAME);
    }

    private String modelName(Properties settings) {
        return this.setting(settings, SettingNames.MODEL_NAME);
    }

    private String sourceName(Properties settings) {
        return this.setting(settings, SettingNames.SOURCE_NAME);
    }

    private String tableName(Properties settings) {
        return this.setting(settings, SettingNames.TABLE_NAME);
    }

    private String columnName(Properties settings) {
        return this.setting(settings, SettingNames.COLUMN_NAME);
    }

    private String dataRoleId(Properties settings) {
        return this.setting(settings, SettingNames.DATA_ROLE_ID);
    }

    private String permissionId(Properties settings) {
        return this.setting(settings, SettingNames.PERMISSION_ID);
    }

    private URI vdbChildUri(URI parentUri, String parentVdb, RestLink.LinkType groupLink, String childName) {
        URI groupUri = this.vdbChildGroupUri(parentUri, parentVdb, groupLink);
        return UriBuilder.fromUri((URI)groupUri).path(childName).build(new Object[0]);
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public URI workspaceDataservicesUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("workspace").path("dataservices").build(new Object[0]);
    }

    public URI workspaceConnectionsUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("workspace").path("connections").build(new Object[0]);
    }

    public URI workspaceDriversUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("workspace").path("drivers").build(new Object[0]);
    }

    public URI workspaceVdbsUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("workspace").path("vdbs").build(new Object[0]);
    }

    public URI mServerUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("metadata").build(new Object[0]);
    }

    public URI mServerVdbsUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("metadata").path("vdbs").build(new Object[0]);
    }

    public URI mServerTranslatorsUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("metadata").path("VdbTranslators").build(new Object[0]);
    }

    public URI mServerTemplatesUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("metadata").path("templates").build(new Object[0]);
    }

    public URI mServerConnectionsUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("metadata").path("connections").build(new Object[0]);
    }

    public URI mServerStatusUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("metadata").path("status").build(new Object[0]);
    }

    public URI mServerVdbStatusUri() {
        return UriBuilder.fromUri((URI)this.baseUri).path("metadata").path("status").path("vdbs").build(new Object[0]);
    }

    public URI searchUri(KomodoProperties properties) {
        UriBuilder builder = UriBuilder.fromUri((URI)this.baseUri).path("workspace").path("search");
        for (Map.Entry entry : properties.entrySet()) {
            builder.queryParam((String)entry.getKey(), new Object[]{entry.getValue().toString()});
        }
        return builder.build(new Object[0]);
    }

    public URI savedSearchCollectionUri(KomodoProperties properties) {
        UriBuilder builder = UriBuilder.fromUri((URI)this.baseUri).path("workspace").path("search").path("savedSearches");
        for (Map.Entry entry : properties.entrySet()) {
            builder.queryParam((String)entry.getKey(), new Object[]{entry.getValue().toString()});
        }
        return builder.build(new Object[0]);
    }

    public URI vdbChildGroupUri(URI parentUri, String vdbName, RestLink.LinkType target) {
        return UriBuilder.fromUri((URI)this.vdbUri(parentUri, vdbName)).path(target.uriName()).build(new Object[0]);
    }

    public URI vdbParentUri(Vdb vdb, Repository.UnitOfWork uow) throws KException {
        return this.workspaceVdbsUri();
    }

    public URI vdbUri(URI parentUri, String vdbName) {
        return UriBuilder.fromUri((URI)parentUri).path(vdbName).build(new Object[0]);
    }

    public URI vdbUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI parentUri = this.vdbParentUri(settings);
        URI result = null;
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String vdbName = this.vdbName(settings);
                result = this.vdbUri(parentUri, vdbName);
                break;
            }
            case 2: {
                result = parentUri;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                String vdbName = this.vdbName(settings);
                result = this.vdbChildGroupUri(parentUri, vdbName, linkType);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbModelUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String parentName = this.vdbName(settings);
        String modelName = this.modelName(settings);
        URI myModelUri = this.vdbChildUri(vdbBaseUri, parentName, RestLink.LinkType.MODELS, modelName);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                result = myModelUri;
                break;
            }
            case 2: {
                result = this.vdbUri(vdbBaseUri, parentName);
                break;
            }
            case 7: {
                result = UriBuilder.fromUri((URI)myModelUri).path(linkType.uriName()).build(new Object[0]);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbModelSourceUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String vdbName = this.vdbName(settings);
        URI modelUri = this.vdbChildUri(vdbBaseUri, vdbName, RestLink.LinkType.MODELS, this.modelName(settings));
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String sourceName = this.sourceName(settings);
                result = UriBuilder.fromUri((URI)modelUri).path(RestLink.LinkType.SOURCES.uriName()).path(sourceName).build(new Object[0]);
                break;
            }
            case 2: {
                result = modelUri;
                break;
            }
            case 8: {
                String translatorName = this.setting(settings, SettingNames.TRANSLATOR_NAME);
                result = this.vdbChildUri(vdbBaseUri, vdbName, RestLink.LinkType.TRANSLATORS, translatorName);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbModelTableUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String vdbName = this.vdbName(settings);
        URI modelUri = this.vdbChildUri(vdbBaseUri, vdbName, RestLink.LinkType.MODELS, this.modelName(settings));
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String tableName = this.tableName(settings);
                result = UriBuilder.fromUri((URI)modelUri).path(RestLink.LinkType.TABLES.uriName()).path(tableName).build(new Object[0]);
                break;
            }
            case 2: {
                result = modelUri;
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbModelTableColumnUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String vdbName = this.vdbName(settings);
        String tableName = this.tableName(settings);
        URI modelUri = this.vdbChildUri(vdbBaseUri, vdbName, RestLink.LinkType.MODELS, this.modelName(settings));
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String columnName = this.columnName(settings);
                result = UriBuilder.fromUri((URI)modelUri).path(RestLink.LinkType.TABLES.uriName()).path(tableName).path(RestLink.LinkType.COLUMNS.uriName()).path(columnName).build(new Object[0]);
                break;
            }
            case 2: {
                result = UriBuilder.fromUri((URI)modelUri).path(RestLink.LinkType.TABLES.uriName()).path(tableName).build(new Object[0]);
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbTranslatorParentUri(Translator translator, Repository.UnitOfWork uow) throws KException {
        KomodoObject parent = translator.getParent(uow);
        if (this.isVdb(uow, parent)) {
            String vdbName = parent.getName(uow);
            return this.vdbUri(this.workspaceVdbsUri(), vdbName);
        }
        throw new KException("Translator has an invalid parent");
    }

    public URI vdbTranslatorUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI parentUri = this.parentUri(settings);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String name = this.setting(settings, SettingNames.TRANSLATOR_NAME);
                if (settings.containsKey(SettingNames.ADD_TRANSLATORS_SEGMENT.name())) {
                    result = UriBuilder.fromUri((URI)parentUri).path("VdbTranslators").path(name).build(new Object[0]);
                    break;
                }
                result = UriBuilder.fromUri((URI)parentUri).path(name).build(new Object[0]);
                break;
            }
            case 2: {
                result = parentUri;
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbImportUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String parentVdb = this.vdbName(settings);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String importName = this.setting(settings, SettingNames.IMPORT_NAME);
                result = this.vdbChildUri(vdbBaseUri, parentVdb, RestLink.LinkType.IMPORTS, importName);
                break;
            }
            case 2: {
                result = this.vdbUri(vdbBaseUri, parentVdb);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbDataRoleUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String parentVdb = this.vdbName(settings);
        String dataRoleId = this.dataRoleId(settings);
        URI myDataRoleUri = this.vdbChildUri(vdbBaseUri, parentVdb, RestLink.LinkType.DATA_ROLES, dataRoleId);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                result = myDataRoleUri;
                break;
            }
            case 2: {
                result = this.vdbUri(vdbBaseUri, parentVdb);
                break;
            }
            case 9: {
                result = UriBuilder.fromUri((URI)myDataRoleUri).path(linkType.uriName()).build(new Object[0]);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbPermissionUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String parentVdb = this.vdbName(settings);
        String dataRoleId = this.dataRoleId(settings);
        String permissionId = this.permissionId(settings);
        URI myDataRoleUri = this.vdbChildUri(vdbBaseUri, parentVdb, RestLink.LinkType.DATA_ROLES, dataRoleId);
        URI myPermUri = UriBuilder.fromUri((URI)myDataRoleUri).path(RestLink.LinkType.PERMISSIONS.uriName()).path(permissionId).build(new Object[0]);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                result = myPermUri;
                break;
            }
            case 2: {
                result = myDataRoleUri;
                break;
            }
            case 10: 
            case 11: {
                result = UriBuilder.fromUri((URI)myPermUri).path(linkType.uriName()).build(new Object[0]);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI vdbPermissionChildUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI vdbBaseUri = this.vdbParentUri(settings);
        String parentVdb = this.vdbName(settings);
        String dataRoleId = this.dataRoleId(settings);
        String permissionId = this.permissionId(settings);
        URI myDataRoleUri = this.vdbChildUri(vdbBaseUri, parentVdb, RestLink.LinkType.DATA_ROLES, dataRoleId);
        URI myPermUri = UriBuilder.fromUri((URI)myDataRoleUri).path(RestLink.LinkType.PERMISSIONS.uriName()).path(permissionId).build(new Object[0]);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String childType = this.setting(settings, SettingNames.PERMISSION_CHILD_TYPE);
                String childId = this.setting(settings, SettingNames.PERMISSION_CHILD_ID);
                result = UriBuilder.fromUri((URI)myPermUri).path(childType).path(childId).build(new Object[0]);
                break;
            }
            case 2: {
                result = myPermUri;
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI dataserviceUri(URI parentUri, String dataserviceName) {
        return UriBuilder.fromUri((URI)parentUri).path(dataserviceName).build(new Object[0]);
    }

    public URI dataserviceUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI parentUri = this.dataserviceParentUri(settings);
        URI result = null;
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String dataserviceName = this.dataserviceName(settings);
                result = this.dataserviceUri(parentUri, dataserviceName);
                break;
            }
            case 2: {
                result = parentUri;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                String dataserviceName = this.dataserviceName(settings);
                result = this.dataserviceChildGroupUri(parentUri, dataserviceName, linkType);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI connectionParentUri(Connection connection, Repository.UnitOfWork uow) throws KException {
        return this.workspaceConnectionsUri();
    }

    public URI connectionUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI parentUri = this.parentUri(settings);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                String name = this.setting(settings, SettingNames.CONNECTION_NAME);
                result = UriBuilder.fromUri((URI)parentUri).path(name).build(new Object[0]);
                break;
            }
            case 2: {
                result = parentUri;
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI templateUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        URI parentUri = this.parentUri(settings);
        String templateName = this.setting(settings, SettingNames.TEMPLATE_NAME);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                result = UriBuilder.fromUri((URI)parentUri).path(templateName).build(new Object[0]);
                break;
            }
            case 2: {
                result = parentUri;
                break;
            }
            case 17: {
                result = UriBuilder.fromUri((URI)parentUri).path(templateName).path("entries").build(new Object[0]);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public URI templateEntryUri(RestLink.LinkType linkType, Properties settings) {
        ArgCheck.isNotNull((Object)linkType, (String)"linkType");
        ArgCheck.isNotNull((Object)settings, (String)"settings");
        URI result = null;
        String templateName = this.setting(settings, SettingNames.TEMPLATE_NAME);
        String templateEntryName = this.setting(settings, SettingNames.TEMPLATE_ENTRY_NAME);
        URI templateUri = UriBuilder.fromUri((URI)this.mServerTemplatesUri()).path("templates").path(templateName).build(new Object[0]);
        switch (1.$SwitchMap$org$komodo$rest$RestLink$LinkType[linkType.ordinal()]) {
            case 1: {
                result = UriBuilder.fromUri((URI)templateUri).path("entries").path(templateEntryName).build(new Object[0]);
                break;
            }
            case 2: {
                result = UriBuilder.fromUri((URI)templateUri).build(new Object[0]);
                break;
            }
            default: {
                throw new RuntimeException("LinkType " + linkType + " not handled");
            }
        }
        assert (result != null);
        return result;
    }

    public Properties createSettings(SettingNames settingName, String value) {
        Properties properties = new Properties();
        properties.setProperty(settingName.name(), value);
        return properties;
    }

    public void addSetting(Properties settings, SettingNames settingName, String value) {
        settings.setProperty(settingName.name(), value);
    }

    public void addSetting(Properties settings, SettingNames settingName, URI value) {
        settings.put(settingName.name(), value);
    }
}

