/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational;

import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.komodo.relational.RelationalModelFactory;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.template.Template;
import org.komodo.relational.template.TemplateEntry;
import org.komodo.relational.vdb.Condition;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Mask;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.AbstractKEntity;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.rest.relational.RestEntityFactory;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.rest.relational.dataservice.RestDataservice;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.rest.relational.response.RestVdbCondition;
import org.komodo.rest.relational.response.RestVdbDataRole;
import org.komodo.rest.relational.response.RestVdbImport;
import org.komodo.rest.relational.response.RestVdbMask;
import org.komodo.rest.relational.response.RestVdbModel;
import org.komodo.rest.relational.response.RestVdbModelSource;
import org.komodo.rest.relational.response.RestVdbModelTable;
import org.komodo.rest.relational.response.RestVdbModelTableColumn;
import org.komodo.rest.relational.response.RestVdbPermission;
import org.komodo.rest.relational.response.RestVdbTranslator;
import org.komodo.rest.relational.response.metadata.RestMetadataConnection;
import org.komodo.rest.relational.response.metadata.RestMetadataTemplate;
import org.komodo.rest.relational.response.metadata.RestMetadataTemplateEntry;
import org.komodo.rest.relational.response.metadata.RestMetadataVdb;
import org.komodo.rest.relational.response.metadata.RestMetadataVdbTranslator;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidPropertyDefinition;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.utils.ArgCheck;
import org.komodo.utils.KLog;

public class RestEntityFactory
implements KomodoRestV1Application.V1Constants {
    private static final KLog LOGGER = KLog.getLogger();

    private void checkTransaction(Repository.UnitOfWork transaction) {
        ArgCheck.isNotNull((Object)transaction, (String)"transaction");
        ArgCheck.isTrue((transaction.getState() == Repository.UnitOfWork.State.NOT_STARTED ? 1 : 0) != 0, (String)"transaction state is not NOT_STARTED");
    }

    public <T extends RestBasicEntity> T create(KomodoObject kObject, URI baseUri, Repository.UnitOfWork transaction, KomodoProperties properties) throws KException {
        this.checkTransaction(transaction);
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)kObject.getRepository(), (Repository.UnitOfWork)transaction);
        KomodoType kType = kObject.getTypeIdentifier(transaction);
        switch (1.$SwitchMap$org$komodo$spi$repository$KomodoType[kType.ordinal()]) {
            case 1: {
                Vdb vdb = (Vdb)wsMgr.resolve(transaction, (Object)kObject, Vdb.class);
                Boolean exportXml = (Boolean)properties.getProperty("vdb-export-xml", (Object)Boolean.FALSE);
                return (T)new RestVdb(baseUri, vdb, exportXml.booleanValue(), transaction);
            }
            case 2: {
                Condition condition = (Condition)wsMgr.resolve(transaction, (Object)kObject, Condition.class);
                return (T)new RestVdbCondition(baseUri, condition, transaction);
            }
            case 3: {
                DataRole dataRole = kObject instanceof DataRole ? (DataRole)kObject : (DataRole)wsMgr.resolve(transaction, (Object)kObject, DataRole.class);
                return (T)new RestVdbDataRole(baseUri, dataRole, transaction);
            }
            case 4: {
                VdbImport vdbImport = (VdbImport)wsMgr.resolve(transaction, (Object)kObject, VdbImport.class);
                return (T)new RestVdbImport(baseUri, vdbImport, transaction);
            }
            case 5: {
                Mask mask = (Mask)wsMgr.resolve(transaction, (Object)kObject, Mask.class);
                return (T)new RestVdbMask(baseUri, mask, transaction);
            }
            case 6: {
                Model model = (Model)wsMgr.resolve(transaction, (Object)kObject, Model.class);
                return (T)new RestVdbModel(baseUri, model, transaction);
            }
            case 7: {
                ModelSource source = (ModelSource)wsMgr.resolve(transaction, (Object)kObject, ModelSource.class);
                return (T)new RestVdbModelSource(baseUri, source, transaction);
            }
            case 8: {
                Table table = (Table)wsMgr.resolve(transaction, (Object)kObject, Table.class);
                return (T)new RestVdbModelTable(baseUri, table, transaction);
            }
            case 9: {
                Column column = (Column)wsMgr.resolve(transaction, (Object)kObject, Column.class);
                return (T)new RestVdbModelTableColumn(baseUri, column, transaction);
            }
            case 10: {
                Permission permission = (Permission)wsMgr.resolve(transaction, (Object)kObject, Permission.class);
                return (T)new RestVdbPermission(baseUri, permission, transaction);
            }
            case 11: {
                Translator translator = (Translator)wsMgr.resolve(transaction, (Object)kObject, Translator.class);
                return (T)new RestVdbTranslator(baseUri, translator, transaction);
            }
            case 12: {
                Connection connection = (Connection)wsMgr.resolve(transaction, (Object)kObject, Connection.class);
                return (T)new RestConnection(baseUri, connection, transaction);
            }
            case 13: {
                Dataservice dataService = (Dataservice)wsMgr.resolve(transaction, (Object)kObject, Dataservice.class);
                return (T)new RestDataservice(baseUri, dataService, false, transaction);
            }
            case 14: {
                return null;
            }
        }
        return (T)new RestBasicEntity(baseUri, kObject, transaction);
    }

    public <T extends RestBasicEntity> T create(KomodoObject kObject, URI baseUri, Repository.UnitOfWork transaction) throws KException {
        return (T)this.create(kObject, baseUri, transaction, new KomodoProperties());
    }

    public static <T extends RestBasicEntity> T resolve(RestBasicEntity basicEntity, Class<T> klazz) {
        try {
            RestBasicEntity instance = (RestBasicEntity)klazz.newInstance();
            basicEntity.clone((AbstractKEntity)instance);
            return (T)instance;
        }
        catch (Exception ex) {
            LOGGER.error("Failure to resolve entity", (Throwable)ex, new Object[0]);
            return null;
        }
    }

    private KomodoObject createTemporaryParent(Repository.UnitOfWork transaction, Repository repository, String primaryType) throws KException {
        String wkspPath = repository.komodoWorkspace(transaction).getAbsolutePath();
        String timeNow = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss-SSS"));
        return repository.add(transaction, wkspPath, timeNow, primaryType);
    }

    public RestMetadataVdb createMetadataVdb(Repository.UnitOfWork transaction, Repository repository, TeiidVdb teiidVdb, URI baseUri) throws Exception {
        this.checkTransaction(transaction);
        ArgCheck.isTrue((boolean)transaction.isRollbackOnly(), (String)"transaction should be rollback-only");
        KomodoObject parent = this.createTemporaryParent(transaction, repository, null);
        KomodoObject vdbObj = parent.getObjectFactory().exportTeiidVdb(transaction, parent, teiidVdb);
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)transaction);
        Vdb vdb = (Vdb)wsMgr.resolve(transaction, (Object)vdbObj, Vdb.class);
        return new RestMetadataVdb(baseUri, vdb, transaction, false);
    }

    public RestMetadataVdbTranslator createMetadataTranslator(Repository.UnitOfWork transaction, Repository repository, TeiidTranslator teiidTranslator, URI baseUri) throws Exception {
        this.checkTransaction(transaction);
        ArgCheck.isTrue((boolean)transaction.isRollbackOnly(), (String)"transaction should be rollback-only");
        KomodoObject parent = this.createTemporaryParent(transaction, repository, "vdb:virtualDatabase");
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repository, (Repository.UnitOfWork)transaction);
        Vdb parentVdb = (Vdb)mgr.resolve(transaction, (Object)parent, Vdb.class);
        String type = teiidTranslator.getType() != null ? teiidTranslator.getType() : teiidTranslator.getName();
        Translator translator = RelationalModelFactory.createTranslator((Repository.UnitOfWork)transaction, (Repository)repository, (Vdb)parentVdb, (String)teiidTranslator.getName(), (String)type);
        translator.setDescription(transaction, teiidTranslator.getDescription());
        Properties props = teiidTranslator.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            translator.setProperty(transaction, entry.getKey().toString(), new Object[]{entry.getValue()});
        }
        return new RestMetadataVdbTranslator(baseUri, translator, transaction);
    }

    public RestMetadataConnection createMetadataDataSource(Repository.UnitOfWork transaction, Repository repository, TeiidDataSource teiidDataSource, URI baseUri) throws Exception {
        this.checkTransaction(transaction);
        ArgCheck.isTrue((boolean)transaction.isRollbackOnly(), (String)"transaction should be rollback-only");
        KomodoObject parent = this.createTemporaryParent(transaction, repository, null);
        Connection connection = RelationalModelFactory.createConnection((Repository.UnitOfWork)transaction, (Repository)repository, (String)parent.getAbsolutePath(), (String)teiidDataSource.getName());
        connection.setDriverName(transaction, teiidDataSource.getType());
        connection.setJndiName(transaction, teiidDataSource.getJndiName());
        for (Map.Entry<Object, Object> property : teiidDataSource.getProperties().entrySet()) {
            String key = property.getKey().toString();
            if ("driver-name".equals(key) || "jndi-name".equals(key)) continue;
            connection.setProperty(transaction, key, new Object[]{property.getValue()});
        }
        return new RestMetadataConnection(baseUri, connection, transaction);
    }

    private String getManagedConnectionFactoryClassDefault(Collection<TeiidPropertyDefinition> propDefns) {
        String resultValue = null;
        for (TeiidPropertyDefinition pDefn : propDefns) {
            if (!pDefn.getName().equalsIgnoreCase("managedconnectionfactory-class")) continue;
            resultValue = (String)pDefn.getDefaultValue();
            break;
        }
        return resultValue;
    }

    private TemplateEntry createMetadataTemplateEntry(Repository.UnitOfWork transaction, Template template, String factoryClass, TeiidPropertyDefinition definition) throws KException {
        TemplateEntry templateEntry = template.addEntry(transaction, definition.getName());
        templateEntry.setDescription(transaction, definition.getDescription());
        templateEntry.setDisplayName(transaction, definition.getDisplayName());
        Collection allowedValues = definition.getAllowedValues();
        if (allowedValues != null && !allowedValues.isEmpty()) {
            ArrayList<String> valuesList = new ArrayList<String>();
            for (String value : allowedValues) {
                valuesList.add(value);
            }
            templateEntry.setAllowedValues(transaction, valuesList);
        }
        templateEntry.setCategory(transaction, definition.getCategory());
        templateEntry.setDefaultValue(transaction, definition.getDefaultValue());
        templateEntry.setTypeClassName(transaction, definition.getPropertyTypeClassName());
        templateEntry.setConstrainedToAllowedValues(transaction, definition.isConstrainedToAllowedValues());
        templateEntry.setAdvanced(transaction, definition.isAdvanced());
        templateEntry.setMasked(transaction, definition.isMasked());
        templateEntry.setModifiable(transaction, definition.isModifiable());
        templateEntry.setRequired(transaction, definition.isRequired());
        templateEntry.setCustomProperties(transaction, definition.getProperties());
        if (definition.getName().equals("class-name")) {
            templateEntry.setDefaultValue(transaction, (Object)factoryClass);
            templateEntry.setRequired(transaction, true);
            templateEntry.setModifiable(transaction, false);
        }
        return templateEntry;
    }

    public RestMetadataTemplate createMetadataTemplate(Repository.UnitOfWork transaction, Repository repository, String templateName, Collection<TeiidPropertyDefinition> propertyDefns, URI baseUri) throws Exception {
        this.checkTransaction(transaction);
        ArgCheck.isTrue((boolean)transaction.isRollbackOnly(), (String)"transaction should be rollback-only");
        KomodoObject parent = this.createTemporaryParent(transaction, repository, null);
        Template template = RelationalModelFactory.createTemplate((Repository.UnitOfWork)transaction, (Repository)repository, (KomodoObject)parent, (String)templateName);
        String factoryClass = this.getManagedConnectionFactoryClassDefault(propertyDefns);
        for (TeiidPropertyDefinition definition : propertyDefns) {
            this.createMetadataTemplateEntry(transaction, template, factoryClass, definition);
        }
        return new RestMetadataTemplate(baseUri, template, transaction);
    }

    public List<RestMetadataTemplateEntry> createMetadataTemplateEntry(Repository.UnitOfWork transaction, Repository repository, Collection<TeiidPropertyDefinition> propertyDefns, URI baseUri) throws Exception {
        this.checkTransaction(transaction);
        ArgCheck.isTrue((boolean)transaction.isRollbackOnly(), (String)"transaction should be rollback-only");
        KomodoObject parent = this.createTemporaryParent(transaction, repository, null);
        Template template = RelationalModelFactory.createTemplate((Repository.UnitOfWork)transaction, (Repository)repository, (KomodoObject)parent, (String)"tempTemplate");
        String factoryClass = this.getManagedConnectionFactoryClassDefault(propertyDefns);
        ArrayList<RestMetadataTemplateEntry> restEntries = new ArrayList<RestMetadataTemplateEntry>();
        for (TeiidPropertyDefinition definition : propertyDefns) {
            TemplateEntry entry = this.createMetadataTemplateEntry(transaction, template, factoryClass, definition);
            RestMetadataTemplateEntry restEntry = new RestMetadataTemplateEntry(baseUri, entry, transaction);
            restEntries.add(restEntry);
        }
        return restEntries;
    }
}

