/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.connection;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.connection.Connection;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;

public class RestConnection
extends RestBasicEntity {
    public static final String JNDI_NAME_LABEL = KomodoService.protectPrefix((String)"dv:jndiName");
    public static final String DRIVER_NAME_LABEL = KomodoService.protectPrefix((String)"dv:driverName");
    public static final String JDBC_LABEL = KomodoService.protectPrefix((String)"dv:type");
    public static final RestConnection[] NO_CONNECTIONS = new RestConnection[0];

    public RestConnection() {
    }

    public RestConnection(URI baseUri) throws KException {
        super(baseUri);
    }

    public RestConnection(URI baseUri, Connection connection, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)connection, uow, false);
        this.setJndiName(connection.getJndiName(uow));
        this.setDriverName(connection.getDriverName(uow));
        this.setJdbc(connection.isJdbc(uow));
        this.addExecutionProperties(uow, (KomodoObject)connection);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.CONNECTION_NAME, this.getId());
        URI parentUri = this.getUriBuilder().connectionParentUri(connection, uow);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, parentUri);
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().connectionUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().connectionUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
    }

    public String getJndiName() {
        Object jndiName = this.tuples.get(JNDI_NAME_LABEL);
        return jndiName != null ? jndiName.toString() : null;
    }

    public void setJndiName(String jndiName) {
        this.tuples.put(JNDI_NAME_LABEL, jndiName);
    }

    public String getDriverName() {
        Object driver = this.tuples.get(DRIVER_NAME_LABEL);
        return driver != null ? driver.toString() : null;
    }

    public void setDriverName(String driver) {
        this.tuples.put(DRIVER_NAME_LABEL, driver);
    }

    public boolean isJdbc() {
        Object jdbc = this.tuples.get(JDBC_LABEL);
        return jdbc != null ? Boolean.parseBoolean(jdbc.toString()) : false;
    }

    public void setJdbc(boolean jdbc) {
        this.tuples.put(JDBC_LABEL, jdbc);
    }
}

