/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.dataservice;

import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.resource.Driver;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;

public final class RestDataservice
extends RestBasicEntity {
    public static final String DESCRIPTION_LABEL = KomodoService.protectPrefix((String)"tko:description");
    public static final String DATASERVICE_VIEW_MODEL_LABEL = "serviceViewModel";
    public static final String DATASERVICE_VIEW_LABEL = "serviceView";
    public static final String DATASERVICE_VDB_NAME_LABEL = "serviceVdbName";
    public static final String DATASERVICE_VDB_VERSION_LABEL = "serviceVdbVersion";
    public static final String DATASERVICE_DRIVER_TOTAL_LABEL = "drivers";
    public static final String DATASERVICE_CONNECTION_TOTAL_LABEL = "connections";
    public static final String DATASERVICE_VIEW_TABLES_LABEL = "serviceViewTables";

    public RestDataservice() {
        this.setkType(KomodoType.DATASERVICE);
    }

    public RestDataservice(URI baseUri, Dataservice dataService, boolean exportXml, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)dataService, uow, false);
        Connection[] connections;
        this.setDescription(dataService.getDescription(uow));
        this.addExecutionProperties(uow, (KomodoObject)dataService);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.DATA_SERVICE_NAME, this.getId());
        URI parentUri = this.getUriBuilder().dataserviceParentUri(dataService, uow);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_SERVICE_PARENT_PATH, parentUri);
        Vdb serviceVdb = dataService.getServiceVdb(uow);
        if (serviceVdb != null) {
            this.setServiceVdbName(serviceVdb.getVdbName(uow));
            this.setServiceVdbVersion(Integer.toString(serviceVdb.getVersion(uow)));
            this.setServiceViewModel(dataService.getServiceViewModelName(uow));
            this.setServiceViewName(dataService.getServiceViewName(uow));
            ArrayList<String> tableNames = new ArrayList<String>();
            Model[] models = serviceVdb.getModels(uow, new String[0]);
            if (models != null) {
                for (Model model : models) {
                    Table[] tables;
                    if (model.getModelType(uow) != Model.Type.PHYSICAL) continue;
                    for (Table table : tables = model.getTables(uow, new String[0])) {
                        tableNames.add(model.getName(uow) + "." + table.getName(uow));
                    }
                }
            }
            this.setServiceViewTables(tableNames.toArray(new String[0]));
        }
        this.setConnectionTotal((connections = dataService.getConnections(uow, new String[0])) != null ? connections.length : 0);
        Driver[] drivers = dataService.getDrivers(uow, new String[0]);
        this.setDriverTotal(drivers != null ? drivers.length : 0);
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().dataserviceUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().dataserviceUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
        this.addLink(new RestLink(RestLink.LinkType.VDBS, this.getUriBuilder().dataserviceUri(RestLink.LinkType.VDBS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.CONNECTIONS, this.getUriBuilder().dataserviceUri(RestLink.LinkType.CONNECTIONS, settings)));
    }

    public String getDescription() {
        Object description = this.tuples.get(DESCRIPTION_LABEL);
        return description != null ? description.toString() : null;
    }

    public void setDescription(String description) {
        this.tuples.put(DESCRIPTION_LABEL, description);
    }

    public String getServiceViewModel() {
        Object modelName = this.tuples.get(DATASERVICE_VIEW_MODEL_LABEL);
        return modelName != null ? modelName.toString() : null;
    }

    public void setServiceViewModel(String modelName) {
        this.tuples.put(DATASERVICE_VIEW_MODEL_LABEL, modelName);
    }

    public String getServiceViewName() {
        Object viewName = this.tuples.get(DATASERVICE_VIEW_LABEL);
        return viewName != null ? viewName.toString() : null;
    }

    public void setServiceViewName(String viewName) {
        this.tuples.put(DATASERVICE_VIEW_LABEL, viewName);
    }

    public String getServiceVdbName() {
        Object serviceVdbName = this.tuples.get(DATASERVICE_VDB_NAME_LABEL);
        return serviceVdbName != null ? serviceVdbName.toString() : null;
    }

    public void setServiceVdbName(String serviceVdbName) {
        this.tuples.put(DATASERVICE_VDB_NAME_LABEL, serviceVdbName);
    }

    public String getServiceVdbVersion() {
        Object version = this.tuples.get(DATASERVICE_VDB_VERSION_LABEL);
        return version != null ? version.toString() : "1";
    }

    public void setServiceVdbVersion(String version) {
        this.tuples.put(DATASERVICE_VDB_VERSION_LABEL, version);
    }

    public int getConnectionTotal() {
        Object total = this.tuples.get(DATASERVICE_CONNECTION_TOTAL_LABEL);
        return total != null ? Integer.parseInt(total.toString()) : 0;
    }

    public void setConnectionTotal(int total) {
        this.tuples.put(DATASERVICE_CONNECTION_TOTAL_LABEL, total);
    }

    public int getDriverTotal() {
        Object total = this.tuples.get(DATASERVICE_DRIVER_TOTAL_LABEL);
        return total != null ? Integer.parseInt(total.toString()) : 0;
    }

    public void setDriverTotal(int total) {
        this.tuples.put(DATASERVICE_DRIVER_TOTAL_LABEL, total);
    }

    public String[] getServiceViewTables() {
        return (String[])this.tuples.get(DATASERVICE_VIEW_TABLES_LABEL);
    }

    public void setServiceViewTables(String[] tableNames) {
        this.tuples.put(DATASERVICE_VIEW_TABLES_LABEL, tableNames);
    }
}

