/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.komodo.rest.AbstractKEntity;
import org.komodo.rest.Messages;
import org.komodo.rest.RestLink;
import org.komodo.rest.RestProperty;
import org.komodo.rest.json.JsonConstants;
import org.komodo.rest.relational.json.AbstractEntitySerializer;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;

public abstract class AbstractEntitySerializer<T extends AbstractKEntity>
extends TypeAdapter<T>
implements JsonConstants {
    protected static final Type BOOLEAN_MAP_TYPE = new /* Unavailable Anonymous Inner Class!! */.getType();
    protected static final Type STRING_MAP_TYPE = new /* Unavailable Anonymous Inner Class!! */.getType();

    protected void beginRead(JsonReader in) throws IOException {
        in.beginObject();
    }

    protected void beginWrite(JsonWriter out) throws IOException {
        out.beginObject();
    }

    protected void endRead(JsonReader in) throws IOException {
        in.endObject();
    }

    protected void endWrite(JsonWriter out) throws IOException {
        out.endObject();
    }

    protected abstract T createEntity();

    protected abstract String readExtension(String var1, T var2, JsonReader var3);

    public T read(JsonReader in) throws IOException {
        AbstractKEntity entity = this.createEntity();
        this.beginRead(in);
        block7: while (in.hasNext()) {
            String name = in.nextName();
            if (this.readExtension(name, entity, in) != null) continue;
            if ("keng__properties".equals(name)) {
                this.readProperties(in, entity);
                continue;
            }
            if ("keng___links".equals(name)) {
                this.readLinks(in, entity);
                continue;
            }
            JsonToken token = in.peek();
            switch (3.$SwitchMap$com$google$gson$stream$JsonToken[token.ordinal()]) {
                case 1: {
                    entity.addTuple(name, (Object)in.nextBoolean());
                    continue block7;
                }
                case 2: {
                    double value = in.nextDouble();
                    if (value % 1.0 == 0.0) {
                        entity.addTuple(name, (Object)((int)value));
                        continue block7;
                    }
                    entity.addTuple(name, (Object)value);
                    continue block7;
                }
                case 3: {
                    entity.addTuple(name, (Object)in.nextString());
                    continue block7;
                }
                case 4: {
                    in.nextNull();
                    entity.addTuple(name, null);
                    continue block7;
                }
                case 5: {
                    Object[] value = (Object[])KomodoJsonMarshaller.BUILDER.fromJson(in, Object[].class);
                    for (int i = 0; i < value.length; ++i) {
                        if (!(value[i] instanceof Double) || (Double)value[i] % 1.0 != 0.0) continue;
                        value[i] = ((Double)value[i]).intValue();
                    }
                    entity.addTuple(name, (Object)value);
                    continue block7;
                }
            }
            throw new IOException(Messages.getString((Enum)Messages.Error.UNEXPECTED_JSON_TOKEN, (Object[])new Object[]{name}));
        }
        if (!this.isComplete(entity)) {
            throw new IOException(Messages.getString((Enum)Messages.Error.INCOMPLETE_JSON, (Object[])new Object[]{this.getClass().getSimpleName()}));
        }
        this.endRead(in);
        return (T)entity;
    }

    protected void readProperties(JsonReader in, T value) {
        RestProperty[] props = (RestProperty[])KomodoJsonMarshaller.BUILDER.fromJson(in, RestProperty[].class);
        if (props == null) {
            value.setProperties(null);
        } else {
            value.setProperties(Arrays.asList(props));
        }
    }

    protected void readLinks(JsonReader in, T value) {
        RestLink[] links = (RestLink[])KomodoJsonMarshaller.BUILDER.fromJson(in, RestLink[].class);
        value.setLinks(Arrays.asList(links));
    }

    protected abstract void writeExtensions(JsonWriter var1, T var2) throws IOException;

    public void write(JsonWriter out, T entity) throws IOException {
        if (!this.isComplete(entity)) {
            throw new IOException(Messages.getString((Enum)Messages.Error.INCOMPLETE_JSON, (Object[])new Object[]{this.getClass().getSimpleName()}));
        }
        this.beginWrite(out);
        this.writeTuples(out, entity);
        this.writeExtensions(out, entity);
        this.writeProperties(out, entity);
        this.writeLinks(out, entity);
        this.endWrite(out);
    }

    protected void writeProperties(JsonWriter out, T value) throws IOException {
        if (value.getProperties().isEmpty()) {
            return;
        }
        out.name("keng__properties");
        KomodoJsonMarshaller.BUILDER.toJson((Object)value.getProperties().toArray(new RestProperty[0]), RestProperty[].class, out);
    }

    protected void writeLinks(JsonWriter out, T value) throws IOException {
        if (value.getLinks().size() != 0) {
            out.name("keng___links");
            KomodoJsonMarshaller.BUILDER.toJson((Object)value.getLinks().toArray(new RestLink[0]), RestLink[].class, out);
        }
    }

    protected void writeValue(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value instanceof Boolean) {
            out.value(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            out.value((long)((Integer)value).intValue());
        } else if (value instanceof Long) {
            out.value(((Long)value).longValue());
        } else if (value instanceof Double) {
            out.value(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            out.value(((Double)value).doubleValue());
        } else if (value instanceof String[]) {
            out.beginArray();
            for (String val : (String[])value) {
                out.value(val);
            }
            out.endArray();
        } else if (value instanceof Object[]) {
            out.beginArray();
            for (Object val : (Object[])value) {
                this.writeValue(out, val);
            }
            out.endArray();
        } else {
            out.value(value.toString());
        }
    }

    protected void writeTuples(JsonWriter out, T entity) throws IOException {
        for (Map.Entry entry : entity.getTuples().entrySet()) {
            out.name((String)entry.getKey());
            Object value = entry.getValue();
            this.writeValue(out, value);
        }
    }

    protected abstract boolean isComplete(T var1);
}

