/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.komodo.rest.Messages;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoConnectionAttributes;

public final class ConnectionAttributesSerializer
extends TypeAdapter<KomodoConnectionAttributes> {
    private static final Type OBJECT_MAP_TYPE = new /* Unavailable Anonymous Inner Class!! */.getType();

    protected KomodoConnectionAttributes createEntity() {
        return new KomodoConnectionAttributes();
    }

    public KomodoConnectionAttributes read(JsonReader in) throws IOException {
        KomodoConnectionAttributes ConnectionAttr = this.createEntity();
        in.beginObject();
        block12: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "jndiName": {
                    ConnectionAttr.setJndi(in.nextString());
                    break;
                }
                case "jdbc": {
                    ConnectionAttr.setJdbc(in.nextBoolean());
                    break;
                }
                case "driverName": {
                    ConnectionAttr.setDriver(in.nextString());
                    break;
                }
                case "parameters": {
                    Map parameters = (Map)KomodoJsonMarshaller.BUILDER.fromJson(in, Map.class);
                    for (Map.Entry parameter : parameters.entrySet()) {
                        ConnectionAttr.setParameter((String)parameter.getKey(), parameter.getValue());
                    }
                    continue block12;
                }
                default: {
                    throw new IOException(Messages.getString((Enum)Messages.Error.UNEXPECTED_JSON_TOKEN, (Object[])new Object[]{name}));
                }
            }
        }
        in.endObject();
        return ConnectionAttr;
    }

    public void write(JsonWriter out, KomodoConnectionAttributes value) throws IOException {
        out.beginObject();
        out.name("jndiName");
        out.value(value.getJndi());
        out.name("driverName");
        out.value(value.getDriver());
        out.name("jdbc");
        out.value(value.isJdbc());
        if (!value.getParameters().isEmpty()) {
            out.name("parameters");
            KomodoJsonMarshaller.BUILDER.toJson((Object)value.getParameters(), OBJECT_MAP_TYPE, out);
        }
        out.endObject();
    }
}

